/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.dapp.rest;

import io.meeds.dapp.web.rest.AuthorizationCodeController;
import io.meeds.dapp.web.security.DeedAccessDeniedHandler;
import io.meeds.dapp.web.security.DeedAuthenticationProvider;
import io.meeds.dapp.web.security.WebSecurityConfig;
import io.meeds.deeds.common.service.AuthorizationCodeService;
import jakarta.servlet.Filter;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.autoconfigure.web.servlet.AutoConfigureMockMvc;
import org.springframework.boot.test.autoconfigure.web.servlet.AutoConfigureWebMvc;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.mock.mockito.MockBean;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.test.web.servlet.request.SecurityMockMvcRequestPostProcessors;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.web.servlet.MockMvc;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.ResultActions;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.request.RequestPostProcessor;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;
import org.springframework.test.web.servlet.setup.DefaultMockMvcBuilder;
import org.springframework.test.web.servlet.setup.MockMvcBuilders;
import org.springframework.web.context.WebApplicationContext;

@SpringBootTest(classes={AuthorizationCodeController.class, DeedAuthenticationProvider.class, DeedAccessDeniedHandler.class})
@AutoConfigureWebMvc
@AutoConfigureMockMvc(addFilters=false)
@ContextConfiguration(classes={WebSecurityConfig.class})
class AuthorizationCodeControllerTest {
    private static final String TEST_PASSWORD = "testPassword";
    private static final String TEST_USER = "testUser";
    private static final String EMAIL = "email";
    @MockBean
    private AuthorizationCodeService authorizationCodeService;
    @Autowired
    private SecurityFilterChain filterChain;
    @Autowired
    private WebApplicationContext context;
    private MockMvc mockMvc;

    AuthorizationCodeControllerTest() {
    }

    @BeforeEach
    public void setup() {
        this.mockMvc = ((DefaultMockMvcBuilder)MockMvcBuilders.webAppContextSetup((WebApplicationContext)this.context).addFilters(this.filterChain.getFilters().toArray(new Filter[0]))).build();
    }

    @Test
    void testGenerateCodeWhenNotAuthenticated() throws Exception {
        String clientIp = "clientIp";
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/authorization/generateCode", (Object[])new Object[0]).with(AuthorizationCodeControllerTest.remoteAddr(clientIp)).contentType("application/x-www-form-urlencoded").param(EMAIL, new String[]{EMAIL}).with((RequestPostProcessor)SecurityMockMvcRequestPostProcessors.csrf()));
        response.andExpect(MockMvcResultMatchers.status().isOk());
    }

    @Test
    void testGenerateCodeWhenNotAuthenticatedAndRemoteAddrNotValid() throws Exception {
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/authorization/generateCode", (Object[])new Object[0]).with(AuthorizationCodeControllerTest.remoteAddr("")).contentType("application/x-www-form-urlencoded").param(EMAIL, new String[]{EMAIL}).with((RequestPostProcessor)SecurityMockMvcRequestPostProcessors.csrf()));
        response.andExpect(MockMvcResultMatchers.status().isForbidden());
    }

    @Test
    void testGenerateCodeWhenAuthenticated() throws Exception {
        String clientIp = "clientIp";
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/authorization/generateCode", (Object[])new Object[0]).with(AuthorizationCodeControllerTest.remoteAddr(clientIp)).contentType("application/x-www-form-urlencoded").param(EMAIL, new String[]{EMAIL}).with(this.testUser()).with((RequestPostProcessor)SecurityMockMvcRequestPostProcessors.csrf()));
        response.andExpect(MockMvcResultMatchers.status().isOk());
        ((AuthorizationCodeService)Mockito.verify((Object)this.authorizationCodeService, (VerificationMode)Mockito.times((int)1))).generateCode(TEST_USER.toLowerCase(), EMAIL, (Object)EMAIL, clientIp);
    }

    @Test
    void testGenerateCodeWhenMaxMailSendingReached() throws Exception {
        String clientIp = "clientIp";
        ((AuthorizationCodeService)Mockito.doThrow(IllegalAccessException.class).when((Object)this.authorizationCodeService)).generateCode(TEST_USER.toLowerCase(), EMAIL, (Object)EMAIL, clientIp);
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/authorization/generateCode", (Object[])new Object[0]).with(AuthorizationCodeControllerTest.remoteAddr(clientIp)).contentType("application/x-www-form-urlencoded").param(EMAIL, new String[]{EMAIL}).with(this.testUser()).with((RequestPostProcessor)SecurityMockMvcRequestPostProcessors.csrf()));
        response.andExpect(MockMvcResultMatchers.status().isUnauthorized());
    }

    @Test
    void testCheckValidityWhenNotAuthenticatedAndNoCode() throws Exception {
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/authorization/checkValidity", (Object[])new Object[0]).contentType("application/x-www-form-urlencoded").param(EMAIL, new String[]{EMAIL}).with((RequestPostProcessor)SecurityMockMvcRequestPostProcessors.csrf()));
        response.andExpect(MockMvcResultMatchers.status().isBadRequest());
    }

    @Test
    void testCheckValidityWhenNotAuthenticated() throws Exception {
        int code = 56422;
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/authorization/checkValidity", (Object[])new Object[0]).contentType("application/x-www-form-urlencoded").param(EMAIL, new String[]{EMAIL}).with((RequestPostProcessor)SecurityMockMvcRequestPostProcessors.csrf()).header("X-AUTHORIZATION", new Object[]{String.valueOf(code)}));
        response.andExpect(MockMvcResultMatchers.status().isOk());
    }

    @Test
    void testCheckValidityWhenNotAuthenticatedAndNoEmail() throws Exception {
        int code = 56422;
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/authorization/checkValidity", (Object[])new Object[0]).contentType("application/x-www-form-urlencoded").param(EMAIL, new String[]{""}).with((RequestPostProcessor)SecurityMockMvcRequestPostProcessors.csrf()).header("X-AUTHORIZATION", new Object[]{String.valueOf(code)}));
        response.andExpect(MockMvcResultMatchers.status().isForbidden());
    }

    @Test
    void testCheckValidityWhenAuthenticated() throws Exception {
        String email = EMAIL;
        int code = 56422;
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/authorization/checkValidity", (Object[])new Object[0]).contentType("application/x-www-form-urlencoded").param(EMAIL, new String[]{email}).with(this.testUser()).with((RequestPostProcessor)SecurityMockMvcRequestPostProcessors.csrf()).header("X-AUTHORIZATION", new Object[]{String.valueOf(code)}));
        response.andExpect(MockMvcResultMatchers.status().isOk());
        ((AuthorizationCodeService)Mockito.verify((Object)this.authorizationCodeService, (VerificationMode)Mockito.times((int)1))).checkValidity(TEST_USER.toLowerCase(), code);
    }

    @Test
    void testCheckValidityWhenMaxVerificationReached() throws Exception {
        String email = EMAIL;
        int code = 56422;
        ((AuthorizationCodeService)Mockito.doThrow(IllegalAccessException.class).when((Object)this.authorizationCodeService)).checkValidity(TEST_USER.toLowerCase(), code);
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)"/api/authorization/checkValidity", (Object[])new Object[0]).contentType("application/x-www-form-urlencoded").param(EMAIL, new String[]{email}).with(this.testUser()).with((RequestPostProcessor)SecurityMockMvcRequestPostProcessors.csrf()).header("X-AUTHORIZATION", new Object[]{String.valueOf(code)}));
        response.andExpect(MockMvcResultMatchers.status().isUnauthorized());
    }

    private RequestPostProcessor testUser() {
        return SecurityMockMvcRequestPostProcessors.user((String)TEST_USER).password(TEST_PASSWORD).authorities(new GrantedAuthority[]{new SimpleGrantedAuthority("USER")});
    }

    private static RequestPostProcessor remoteAddr(final String remoteAddr) {
        return new RequestPostProcessor(){

            public MockHttpServletRequest postProcessRequest(MockHttpServletRequest request) {
                request.setRemoteAddr(remoteAddr);
                return request;
            }
        };
    }
}

