/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.deeds;

import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.format.ResolverStyle;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HttpsURLConnection;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CurrencyExchangeServlet
extends HttpServlet {
    private static final long serialVersionUID = 3406095035407422332L;
    private static final Logger LOG = LoggerFactory.getLogger(CurrencyExchangeServlet.class);
    public static final DateTimeFormatter DATE_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd").withResolverStyle(ResolverStyle.LENIENT);
    private static final LocalDate MEEDS_TOKEN_FIRST_DATE = LocalDate.of(2021, 11, 6);
    private String apiKey = System.getProperty("m3o.apiKey");
    private ScheduledExecutorService scheduledExecutorService = Executors.newScheduledThreadPool(1);

    public void init() throws ServletException {
        this.scheduledExecutorService.scheduleWithFixedDelay(() -> this.computeExchangeRate(), 0L, 1L, TimeUnit.HOURS);
    }

    public void destroy() {
        this.scheduledExecutorService.shutdownNow();
        super.destroy();
    }

    private void computeExchangeRate() {
        block9: {
            try {
                URL exchangeRate = this.getServletContext().getResource("/json/exchangeRate-eur.json");
                if (exchangeRate == null) break block9;
                String exchangeRateObjectString = IOUtils.toString((URL)exchangeRate, (Charset)StandardCharsets.UTF_8);
                JSONObject exchangeRateObject = new JSONObject(exchangeRateObjectString);
                LocalDate localDate = MEEDS_TOKEN_FIRST_DATE;
                LocalDate tomorrow = LocalDate.now().plusDays(1L);
                boolean ratesChanged = false;
                while (localDate.isBefore(tomorrow)) {
                    String dateString = DATE_FORMATTER.format(localDate);
                    if (!exchangeRateObject.has(dateString)) {
                        String exchangeRateResultString = this.retrieveCurrencyExchangeRate(localDate);
                        if (StringUtils.isBlank((String)exchangeRateResultString)) break;
                        JSONObject exchangeRateResult = new JSONObject(exchangeRateResultString);
                        BigDecimal euroExchangeRate = exchangeRateResult.getJSONObject("rates").getBigDecimal("EUR");
                        exchangeRateObject.put(dateString, (Object)euroExchangeRate);
                        ratesChanged = true;
                    }
                    localDate = localDate.plusDays(1L);
                }
                if (!ratesChanged) break block9;
                try (FileOutputStream outputStream = new FileOutputStream(exchangeRate.getPath());){
                    IOUtils.write((String)exchangeRateObject.toString(), (OutputStream)outputStream, (Charset)StandardCharsets.UTF_8);
                }
            }
            catch (Exception e) {
                LOG.error("An error occurred while computing EURO exchange rates", (Throwable)e);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String retrieveCurrencyExchangeRate(LocalDate date) {
        String string;
        if (this.apiKey == null) {
            throw new IllegalStateException("API Key is mandatory");
        }
        String dateString = DATE_FORMATTER.format(date);
        URL apiUrl = new URL("https://api.m3o.com/v1/currency/Rates");
        HttpsURLConnection con = (HttpsURLConnection)apiUrl.openConnection();
        con.setRequestMethod("GET");
        con.setRequestProperty("Content-Type", "application/json");
        con.setRequestProperty("Authorization", "Bearer " + this.apiKey);
        String parameters = "{\"code\": \"USD\"}";
        con.setDoOutput(true);
        DataOutputStream wr = new DataOutputStream(con.getOutputStream());
        wr.writeBytes(parameters);
        wr.flush();
        wr.close();
        int responseCode = con.getResponseCode();
        if (responseCode != 200) return null;
        InputStream inputStream = con.getInputStream();
        try {
            string = IOUtils.toString((InputStream)con.getInputStream(), (Charset)StandardCharsets.UTF_8);
            if (inputStream == null) return string;
        }
        catch (Throwable throwable) {
            try {
                if (inputStream == null) throw throwable;
                try {
                    inputStream.close();
                    throw throwable;
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                LOG.warn("An error occurred while retrieving EURO exchange rate of date {}", (Object)dateString, (Object)e);
                return null;
            }
        }
        inputStream.close();
        return string;
    }
}

