/*
 * This file is part of the Meeds project (https://meeds.io/).
 * Copyright (C) 2020 - 2022 Meeds Association contact@meeds.io
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */
package io.meeds.tenant.provisioning.listener;

import static io.meeds.deeds.constant.CommonConstants.DEED_EVENT_TENANT_EMAIL_UPDATED;
import static io.meeds.deeds.constant.CommonConstants.TENANT_COMMAND_START_EVENT;

import java.util.Arrays;
import java.util.List;

import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

import io.meeds.deeds.elasticsearch.model.DeedTenant;
import io.meeds.deeds.listener.EventListener;
import io.meeds.deeds.model.UserProfileDTO;
import io.meeds.deeds.service.UserProfileService;

public class TenantStartCommandCreatedListener implements EventListener<DeedTenant> {

  public static final String        LISTENER_NAME    = "TenantStartCommandCreatedListener";

  private static final List<String> SUPPORTED_EVENTS = Arrays.asList(TENANT_COMMAND_START_EVENT,
                                                                     DEED_EVENT_TENANT_EMAIL_UPDATED);

  @Autowired
  private UserProfileService        userProfileService;

  @Override
  public String getName() {
    return LISTENER_NAME;
  }

  @Override
  public List<String> getSupportedEvents() {
    return SUPPORTED_EVENTS;
  }

  @Override
  public void onEvent(String eventName, DeedTenant deedTenant) {
    if (StringUtils.isNotBlank(deedTenant.getManagerEmail())) {
      UserProfileDTO userProfileDTO = new UserProfileDTO(deedTenant.getManagerAddress(), deedTenant.getManagerEmail());
      userProfileService.saveUserProfile(userProfileDTO);
    }
  }

}
