/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.tenant.provisioning;

import io.meeds.tenant.provisioning.listener.TenantTaskCompletedListener;
import io.meeds.tenant.provisioning.service.TenantProvisioningService;
import javax.annotation.PostConstruct;
import javax.servlet.ServletContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.RootContainer;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.services.listener.ListenerService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class KernelIntegrationService {
    @Autowired
    private TenantProvisioningService tenantProvisioningService;
    @Autowired
    private ServletContext servletContext;

    @PostConstruct
    public TenantTaskCompletedListener init() {
        final TenantTaskCompletedListener taskSavedListener = new TenantTaskCompletedListener(this.tenantProvisioningService, this.servletContext.getClassLoader());
        PortalContainer.addInitTask((ServletContext)this.servletContext, (RootContainer.PortalContainerInitTask)new RootContainer.PortalContainerPostInitTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void execute(ServletContext context, PortalContainer portalContainer) {
                ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
                Thread.currentThread().setContextClassLoader(KernelIntegrationService.this.servletContext.getClassLoader());
                try {
                    ListenerService listenerService = (ListenerService)portalContainer.getComponentInstanceOfType(ListenerService.class);
                    listenerService.addListener("exo.task.taskUpdate", (Listener)taskSavedListener);
                }
                finally {
                    Thread.currentThread().setContextClassLoader(contextClassLoader);
                }
            }
        });
        return taskSavedListener;
    }
}

