/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.tenant.provisioning.listener;

import io.meeds.deeds.constant.ObjectNotFoundException;
import io.meeds.deeds.elasticsearch.model.DeedTenant;
import io.meeds.deeds.listener.EventListener;
import io.meeds.tenant.provisioning.model.AutomaticStatus;
import io.meeds.tenant.provisioning.service.DeedEmailService;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.codec.binary.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TenantStatusChangeListener
implements EventListener<DeedTenant> {
    private static final Logger LOG = LoggerFactory.getLogger(TenantStatusChangeListener.class);
    public static final String LISTENER_NAME = "TenantStatusChangeListener";
    private static final List<String> SUPPORTED_EVENTS = Arrays.asList("deed.event.tenantCancelCommand", "deed.event.tenantStartCommandCreated", "deed.event.tenantStopCommandCreated");
    @Autowired
    private DeedEmailService deedEmailService;

    public String getName() {
        return LISTENER_NAME;
    }

    public List<String> getSupportedEvents() {
        return SUPPORTED_EVENTS;
    }

    public void onEvent(String eventName, DeedTenant deedTenant) {
        AutomaticStatus tenantStatus = null;
        if (StringUtils.equals((CharSequence)eventName, (CharSequence)"deed.event.tenantStartCommandCreated")) {
            tenantStatus = deedTenant.getTenantProvisioningStatus().isPending() ? AutomaticStatus.START_IN_PROGRESS : AutomaticStatus.START_CONFIRMED;
        } else if (StringUtils.equals((CharSequence)eventName, (CharSequence)"deed.event.tenantStopCommandCreated")) {
            tenantStatus = deedTenant.getTenantProvisioningStatus().isPending() ? AutomaticStatus.STOP_IN_PROGRESS : AutomaticStatus.STOP_CONFIRMED;
        } else if (StringUtils.equals((CharSequence)eventName, (CharSequence)"deed.event.tenantCancelCommand")) {
            tenantStatus = AutomaticStatus.TRANSACTION_ERROR;
        }
        try {
            if (tenantStatus != null) {
                this.deedEmailService.sendEmail(deedTenant.getNftId(), tenantStatus);
            }
        }
        catch (ObjectNotFoundException e) {
            LOG.warn("Can't send automatic mail, reason: {}", (Object)e.getMessage());
        }
        catch (Exception e) {
            LOG.warn("Error sending automatic mail for event [{}] for Deed Tenant [{}]", new Object[]{eventName, deedTenant.getNftId(), e});
        }
    }
}

