/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.tenant.provisioning.listener;

import io.meeds.tenant.provisioning.service.TenantProvisioningService;
import java.util.concurrent.CompletableFuture;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.task.dto.TaskDto;
import org.exoplatform.task.service.TaskPayload;
import org.exoplatform.task.service.TaskService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TenantTaskCompletedListener
extends Listener<TaskService, TaskPayload> {
    private static final Logger LOG = LoggerFactory.getLogger(TenantTaskCompletedListener.class);
    private TenantProvisioningService tenantProvisioningService;
    private ClassLoader classLoader;

    public TenantTaskCompletedListener(TenantProvisioningService tenantProvisioningService, ClassLoader classLoader) {
        this.tenantProvisioningService = tenantProvisioningService;
        this.classLoader = classLoader;
    }

    public void onEvent(Event<TaskService, TaskPayload> event) throws Exception {
        TaskPayload data = (TaskPayload)event.getData();
        TaskDto oldTask = data.before();
        TaskDto newTask = data.after();
        CompletableFuture.runAsync(() -> {
            boolean completeStatusChanged;
            ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(this.classLoader);
            boolean bl = completeStatusChanged = oldTask != null && newTask != null && newTask.isCompleted() != oldTask.isCompleted();
            if (completeStatusChanged) {
                long taskId = newTask.getId();
                boolean completed = newTask.isCompleted();
                try {
                    this.tenantProvisioningService.changeDeedTenantCompletedStatus(taskId, completed);
                }
                catch (Exception e) {
                    LOG.warn("Error while broadcasting Task {} as completed={} for its deed", new Object[]{taskId, completed, e});
                }
                finally {
                    Thread.currentThread().setContextClassLoader(contextClassLoader);
                }
            }
        });
    }
}

