/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.tenant.provisioning.scheduling.task;

import io.meeds.deeds.service.BlockchainService;
import io.meeds.deeds.service.ListenerService;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections.CollectionUtils;
import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.commons.api.settings.SettingValue;
import org.exoplatform.commons.api.settings.data.Context;
import org.exoplatform.commons.api.settings.data.Scope;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
public class DeedOwnershipBlockchainMinedEventsCheckTask {
    private static final String SETTING_LAST_TIME_CHECK_KEY = "minedDeedOwnershipsTransactionsCheck";
    private static final Scope SETTING_SCOPE = Scope.APPLICATION.id("DEED_TENANT_PROVISIONING");
    private static final Context SETTING_CONTEXT = Context.GLOBAL.id("DEED_TENANT_PROVISIONING");
    @Autowired
    private ListenerService listenerService;
    @Autowired
    private BlockchainService blockchainService;
    private SettingService settingService;

    @Scheduled(fixedDelay=5L, timeUnit=TimeUnit.MINUTES, initialDelay=3L)
    public synchronized void checkTransferredDeeds() {
        long lastBlock = this.blockchainService.getLastBlock();
        long lastCheckedBlock = this.getLastCheckedBlock();
        if (lastCheckedBlock == 0L) {
            this.saveLastCheckedBlock(lastBlock);
            return;
        }
        Set events = this.blockchainService.getMinedTransferOwnershipDeedTransactions(lastCheckedBlock, lastBlock);
        if (!CollectionUtils.isEmpty((Collection)events)) {
            events.forEach(event -> this.listenerService.publishEvent("deed.event.transferOwnershipFromBlockchain", event));
        }
        this.saveLastCheckedBlock(lastBlock);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getLastCheckedBlock() {
        ExoContainerContext.setCurrentContainer((ExoContainer)PortalContainer.getInstance());
        try {
            long lastCheckedBlock = 0L;
            SettingValue settingValue = this.getSettingService().get(SETTING_CONTEXT, SETTING_SCOPE, SETTING_LAST_TIME_CHECK_KEY);
            if (settingValue != null && settingValue.getValue() != null) {
                lastCheckedBlock = Long.parseLong(settingValue.getValue().toString());
            }
            long l = lastCheckedBlock;
            return l;
        }
        finally {
            ExoContainerContext.setCurrentContainer(null);
        }
    }

    private void saveLastCheckedBlock(long lastBlock) {
        ExoContainerContext.setCurrentContainer((ExoContainer)PortalContainer.getInstance());
        try {
            this.getSettingService().set(SETTING_CONTEXT, SETTING_SCOPE, SETTING_LAST_TIME_CHECK_KEY, SettingValue.create((Long)lastBlock));
        }
        finally {
            ExoContainerContext.setCurrentContainer(null);
        }
    }

    private SettingService getSettingService() {
        if (this.settingService == null) {
            this.settingService = (SettingService)PortalContainer.getInstance().getComponentInstanceOfType(SettingService.class);
        }
        return this.settingService;
    }
}

