/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.tenant.provisioning.service;

import io.meeds.deeds.constant.ObjectNotFoundException;
import io.meeds.deeds.listerner.model.EmailSendingCommand;
import io.meeds.tenant.provisioning.model.AutomaticStatus;
import io.meeds.tenant.provisioning.model.EmailTemplate;
import io.meeds.tenant.provisioning.service.TenantProvisioningService;
import io.meeds.tenant.provisioning.service.TenantProvisioningSettingsService;
import io.meeds.tenant.provisioning.storage.EmailTemplateRepository;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.mail.internet.MimeMessage;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.ObjectAlreadyExistsException;
import org.exoplatform.commons.utils.HTMLSanitizer;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.services.mail.MailService;
import org.exoplatform.wiki.WikiException;
import org.exoplatform.wiki.model.Page;
import org.exoplatform.wiki.service.NoteService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.mail.javamail.MimeMessageHelper;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class DeedEmailService {
    private static final Logger LOG = LoggerFactory.getLogger(DeedEmailService.class);
    protected NoteService noteService;
    protected MailService mailService;
    @Autowired
    private TenantProvisioningSettingsService tenantProvisioningSettingsService;
    @Autowired
    private TenantProvisioningService tenantProvisioningService;
    @Autowired
    private EmailTemplateRepository emailTemplateRepository;

    public List<EmailTemplate> getEmailTemplates() {
        return this.emailTemplateRepository.findAll(Pageable.unpaged()).getContent();
    }

    public EmailTemplate createTemplate(EmailTemplate emailTemplate) throws ObjectAlreadyExistsException {
        if (emailTemplate.getId() != null) {
            throw new ObjectAlreadyExistsException((Object)("Email Template already exists with id " + emailTemplate.getId()));
        }
        return (EmailTemplate)this.emailTemplateRepository.save(emailTemplate);
    }

    public EmailTemplate updateTemplate(EmailTemplate emailTemplate) throws ObjectNotFoundException {
        String id = emailTemplate.getId();
        EmailTemplate storedTemplate = this.emailTemplateRepository.findById(id).orElse(null);
        if (storedTemplate == null) {
            throw new ObjectNotFoundException("Email Template with id " + id + " doesn't exists");
        }
        return (EmailTemplate)this.emailTemplateRepository.save(emailTemplate);
    }

    public void deleteTemplate(String id) throws ObjectNotFoundException {
        EmailTemplate storedTemplate = this.emailTemplateRepository.findById(id).orElse(null);
        if (storedTemplate == null) {
            throw new ObjectNotFoundException("Email Template with id " + id + " doesn't exist");
        }
        this.emailTemplateRepository.deleteById(id);
    }

    public void sendEmail(EmailSendingCommand emailSendingCommand) throws Exception {
        AutomaticStatus status = AutomaticStatus.valueOf(emailSendingCommand.getTemplate());
        EmailTemplate emailTemplate = this.emailTemplateRepository.findByAutomaticStatus(status).orElseThrow(() -> new ObjectNotFoundException("Associated email template for automatic status " + status + " not found"));
        Page notePage = this.getNotePage(emailTemplate);
        if (notePage == null) {
            throw new ObjectNotFoundException("Email Note Page with id " + emailTemplate.getNotePageId() + " wasn't found");
        }
        String subject = emailTemplate.getMailSubject();
        String content = notePage.getContent();
        if (!CollectionUtils.isEmpty((Map)emailSendingCommand.getParameters())) {
            Set parameterEntries = emailSendingCommand.getParameters().entrySet();
            for (Map.Entry entry : parameterEntries) {
                content = content.replace("## " + (String)entry.getKey() + " ##", (CharSequence)entry.getValue());
                subject = subject.replace("## " + (String)entry.getKey() + " ##", (CharSequence)entry.getValue());
            }
        }
        this.sendEmail(emailSendingCommand.getEmail(), subject, content, true);
    }

    public void sendEmail(long nftId, AutomaticStatus status) throws Exception {
        EmailTemplate emailTemplate = this.emailTemplateRepository.findByAutomaticStatus(status).orElseThrow(() -> new ObjectNotFoundException("Associated email template for automatic status " + status + " not found"));
        if (emailTemplate != null && emailTemplate.getNotePageId() > 0L) {
            Page notePage = this.getNotePage(emailTemplate);
            if (notePage == null) {
                throw new ObjectNotFoundException("Email Note Page with id " + emailTemplate.getNotePageId() + " wasn't found");
            }
            String subject = emailTemplate.getMailSubject();
            String content = notePage.getContent();
            this.sendEmail(nftId, subject, content, true);
        }
    }

    public void sendEmail(long nftId, String emailSubject, String emailContent, boolean async) throws Exception {
        String to = this.tenantProvisioningService.getManagerEmail(nftId);
        this.sendEmail(to, emailSubject, emailContent, async);
    }

    public void sendEmail(String to, String emailSubject, String emailContent, boolean async) throws Exception {
        if (StringUtils.isBlank((CharSequence)to)) {
            LOG.warn("Can't send mail to empty email");
            return;
        }
        String from = this.tenantProvisioningSettingsService.getSenderFullEmail();
        String[] bcc = this.tenantProvisioningSettingsService.getEmailBcc();
        String signature = this.tenantProvisioningSettingsService.getEmailSignature();
        byte[] emailLogoBytes = this.tenantProvisioningSettingsService.getEmailLogoData();
        String emailLogoBase64 = emailLogoBytes == null || emailLogoBytes.length > 0 ? Base64.getEncoder().encodeToString(emailLogoBytes) : "";
        MimeMessage mimeMessage = new MimeMessage(this.getMailService().getMailSession());
        MimeMessageHelper messageHelper = new MimeMessageHelper(mimeMessage, true, StandardCharsets.UTF_8.name());
        messageHelper.setFrom(from);
        messageHelper.setTo(to);
        if (bcc != null && bcc.length > 0) {
            messageHelper.setBcc(bcc);
        }
        messageHelper.setSubject(StringEscapeUtils.unescapeHtml((String)HTMLSanitizer.sanitize((String)emailSubject)));
        String htmlContent = HTMLSanitizer.sanitize((String)(emailContent + "<br/><p>" + signature + "</p>"));
        Object imgFooter = StringUtils.isBlank((CharSequence)emailLogoBase64) ? "" : "<br/><img src=\"data:image/png;base64," + emailLogoBase64 + "\" style=\"max-width: 200px; min-width: 100px;\">";
        messageHelper.setText(htmlContent + (String)imgFooter, true);
        if (async) {
            this.getMailService().sendMessageInFuture(messageHelper.getMimeMessage());
        } else {
            this.getMailService().sendMessage(messageHelper.getMimeMessage());
        }
    }

    private Page getNotePage(EmailTemplate emailTemplate) throws WikiException {
        this.startKernelTransaction();
        try {
            Page page = this.getNoteService().getNoteById(String.valueOf(emailTemplate.getNotePageId()));
            return page;
        }
        finally {
            this.commitKernelTransaction();
        }
    }

    private MailService getMailService() {
        if (this.mailService == null) {
            this.mailService = (MailService)this.getContainer().getComponentInstanceOfType(MailService.class);
        }
        return this.mailService;
    }

    private NoteService getNoteService() {
        if (this.noteService == null) {
            this.noteService = (NoteService)this.getContainer().getComponentInstanceOfType(NoteService.class);
        }
        return this.noteService;
    }

    private PortalContainer getContainer() {
        return PortalContainer.getInstance();
    }

    private void startKernelTransaction() {
        try {
            PortalContainer container = this.getContainer();
            ExoContainerContext.setCurrentContainer((ExoContainer)container);
            RequestLifeCycle.begin((ExoContainer)container);
        }
        catch (Throwable e) {
            LOG.warn("Error starting Kernel transaction", e);
        }
    }

    private void commitKernelTransaction() {
        try {
            RequestLifeCycle.end();
        }
        catch (Throwable e) {
            LOG.warn("Error committing Kernel transaction", e);
        }
    }
}

