/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.tenant.provisioning.web.rest;

import io.meeds.deeds.blockchain.BlockchainConfigurationProperties;
import io.meeds.deeds.constant.ObjectNotFoundException;
import io.meeds.deeds.constant.TenantProvisioningStatus;
import io.meeds.deeds.constant.TenantStatus;
import io.meeds.deeds.elasticsearch.model.DeedTenant;
import io.meeds.tenant.provisioning.TenantProvisioningConfiguration;
import io.meeds.tenant.provisioning.service.TenantProvisioningService;
import io.meeds.tenant.provisioning.web.model.DeedTenantProvisioningList;
import io.meeds.tenant.provisioning.web.rest.utils.EntityMapper;
import java.security.Principal;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.CacheControl;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;

@RestController
@RequestMapping(value={"/api/provisioning/tenants"})
public class TenantProvisioningController {
    @Autowired
    private TenantProvisioningConfiguration provisioningConfiguration;
    @Autowired
    private BlockchainConfigurationProperties blockchainProperties;
    @Autowired
    private TenantProvisioningService tenantProvisioningService;

    @GetMapping
    public ResponseEntity<DeedTenantProvisioningList> getTenants(Principal principal, @RequestParam(name="tenantProvisioningStatus", required=false) TenantProvisioningStatus provisioningStatus, @RequestParam(name="includeCompleted", required=false) boolean includeCompleted, @RequestParam(name="limit", required=false) int limit) {
        if (principal == null || StringUtils.isBlank((CharSequence)principal.getName()) || !this.tenantProvisioningService.isManager(principal.getName())) {
            throw new ResponseStatusException(HttpStatus.UNAUTHORIZED);
        }
        if (limit <= 0) {
            limit = 10;
        }
        DeedTenantProvisioningList tenantProvisioningList = this.getDeedTenantProvisioningList(provisioningStatus, includeCompleted, limit);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().cacheControl(CacheControl.noStore())).body((Object)tenantProvisioningList);
    }

    @PatchMapping(value={"/{nftId}"})
    public void saveTenantStatus(Principal principal, @PathVariable(value="nftId") long nftId, @RequestParam(value="tenantStatus") TenantStatus tenantStatus) {
        if (principal == null || StringUtils.isBlank((CharSequence)principal.getName()) || !this.tenantProvisioningService.isManager(principal.getName())) {
            throw new ResponseStatusException(HttpStatus.UNAUTHORIZED);
        }
        if (tenantStatus == null) {
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "Empty Tenant Status field");
        }
        try {
            this.tenantProvisioningService.saveDeedTenantStatus(nftId, tenantStatus);
        }
        catch (ObjectNotFoundException e) {
            throw new ResponseStatusException(HttpStatus.NOT_FOUND, "Can't find NFT with id " + nftId);
        }
    }

    private DeedTenantProvisioningList getDeedTenantProvisioningList(TenantProvisioningStatus provisioningStatus, boolean includeCompleted, int limit) {
        DeedTenantProvisioningList tenantProvisioningList = new DeedTenantProvisioningList(limit);
        if (provisioningStatus == null) {
            this.addAllDeedTenants(tenantProvisioningList, includeCompleted, limit);
        } else {
            this.addDeedTenantsByProvisioningStatus(tenantProvisioningList, provisioningStatus, includeCompleted, limit);
        }
        return tenantProvisioningList;
    }

    private void addAllDeedTenants(DeedTenantProvisioningList tenantProvisioningList, boolean includeCompleted, int limit) {
        Arrays.stream(TenantProvisioningStatus.values()).forEach(tenantProvisioningStatus -> this.addDeedTenantsByProvisioningStatus(tenantProvisioningList, (TenantProvisioningStatus)tenantProvisioningStatus, includeCompleted, limit));
    }

    private void addDeedTenantsByProvisioningStatus(DeedTenantProvisioningList tenantProvisioningList, TenantProvisioningStatus tenantProvisioningStatus, boolean includeCompleted, int limit) {
        List<DeedTenant> deedTenants = this.tenantProvisioningService.getTenants(tenantProvisioningStatus, includeCompleted, limit);
        long count = this.tenantProvisioningService.getTenantsCount(tenantProvisioningStatus, includeCompleted);
        tenantProvisioningList.addTenantProvisioningStatus(tenantProvisioningStatus, EntityMapper.toRestDTOs(deedTenants, this.provisioningConfiguration.getEtherscanPrefix(), this.blockchainProperties.getDeedAddress()), count);
    }
}

