/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.tenant.provisioning.web.rest.utils;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import io.meeds.deeds.elasticsearch.model.DeedTenant;
import io.meeds.tenant.provisioning.model.EmailTemplate;
import io.meeds.tenant.provisioning.model.EmailTemplateDTO;
import io.meeds.tenant.provisioning.web.model.DeedTenantProvisioning;
import io.meeds.tenant.provisioning.web.model.DeedTenantProvisioningWebSocket;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.json.JSONObject;

public class EntityMapper {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    private EntityMapper() {
    }

    public static List<DeedTenantProvisioning> toRestDTOs(List<DeedTenant> deedTenants, String etherscanPrefix, String deedAddress) {
        return deedTenants.stream().map(deedTenant -> EntityMapper.toRestDTO(deedTenant, etherscanPrefix, deedAddress)).collect(Collectors.toList());
    }

    public static DeedTenantProvisioning toRestDTO(DeedTenant deedTenant, String etherscanPrefix, String deedAddress) {
        LocalDateTime date = deedTenant.getDate();
        String etherscanLink = etherscanPrefix + ("/nft/" + deedAddress + "/" + deedTenant.getNftId()).replace("//", "/");
        return new DeedTenantProvisioning(deedTenant.getNftId(), deedTenant.getCityIndex(), deedTenant.getCardType(), deedTenant.getManagerAddress(), deedTenant.getManagerEmail(), deedTenant.getStartupTransactionHash(), deedTenant.getShutdownTransactionHash(), deedTenant.getTenantProvisioningStatus(), deedTenant.getTenantStatus(), date == null ? null : ZonedDateTime.of(date, ZoneOffset.UTC), deedTenant.getProperties(), deedTenant.isCompleted(), etherscanLink);
    }

    public static DeedTenantProvisioningWebSocket toWebSocketDTO(String eventName, DeedTenant deedTenant, String etherscanPrefix, String deedAddress) {
        return new DeedTenantProvisioningWebSocket(EntityMapper.toRestDTO(deedTenant, etherscanPrefix, deedAddress), eventName);
    }

    public static String toJsonString(Object object) {
        try {
            return OBJECT_MAPPER.writeValueAsString(object);
        }
        catch (JsonProcessingException e) {
            throw new IllegalStateException("Error parsing object to JSON string", e);
        }
    }

    public static <T> T toObject(Map<?, ?> properties, Class<T> clazz) {
        try {
            return (T)OBJECT_MAPPER.readValue(new JSONObject(properties).toString(), clazz);
        }
        catch (JsonProcessingException e) {
            throw new IllegalStateException("Error parsing JSON string to object", e);
        }
    }

    public static Map<String, Object> toMap(Object object) {
        try {
            String objectString = OBJECT_MAPPER.writeValueAsString(object);
            JSONObject jsonObject = new JSONObject(objectString);
            return jsonObject.toMap();
        }
        catch (JsonProcessingException e) {
            throw new IllegalStateException("Error generating Map from object fields", e);
        }
    }

    public static <T> T mergeObjects(T source, T newValues) {
        try {
            String obj1String = OBJECT_MAPPER.writeValueAsString(source);
            JSONObject object1 = new JSONObject(obj1String);
            String obj2String = OBJECT_MAPPER.writeValueAsString(newValues);
            JSONObject object2 = new JSONObject(obj2String);
            Set newKeys = object2.keySet();
            for (String key : newKeys) {
                object1.put(key, object2.get(key));
            }
            return (T)OBJECT_MAPPER.readValue(obj2String, source.getClass());
        }
        catch (JsonProcessingException e) {
            throw new IllegalStateException("Error merging JSON objects", e);
        }
    }

    public static EmailTemplateDTO toDTO(EmailTemplate emailTemplate) {
        return new EmailTemplateDTO(emailTemplate);
    }

    public static EmailTemplate fromDTO(EmailTemplateDTO emailTemplateDto) {
        return new EmailTemplate(emailTemplateDto.getId(), emailTemplateDto.getName(), emailTemplateDto.getDescription(), emailTemplateDto.getMailSubject(), emailTemplateDto.getAutomaticStatus(), emailTemplateDto.getNotePageId());
    }

    public static List<EmailTemplateDTO> toDTO(List<EmailTemplate> emailTemplates) {
        return emailTemplates == null ? Collections.emptyList() : emailTemplates.stream().map(EntityMapper::toDTO).collect(Collectors.toList());
    }

    static {
        OBJECT_MAPPER.registerModule((Module)new JavaTimeModule());
    }
}

