/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.tenant.provisioning.web.websocket;

import io.meeds.deeds.blockchain.BlockchainConfigurationProperties;
import io.meeds.deeds.elasticsearch.model.DeedTenant;
import io.meeds.deeds.listener.EventListener;
import io.meeds.tenant.provisioning.TenantProvisioningConfiguration;
import io.meeds.tenant.provisioning.service.TenantProvisioningService;
import io.meeds.tenant.provisioning.web.model.DeedTenantProvisioningWebSocket;
import io.meeds.tenant.provisioning.web.rest.utils.EntityMapper;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.apache.commons.collections.CollectionUtils;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.ws.frameworks.cometd.ContinuationService;
import org.mortbay.cometd.continuation.EXoContinuationBayeux;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TenantProvisioningWebSocketService
implements EventListener<DeedTenant> {
    public static final String COMETD_CHANNEL = "/Application/TenantProvisioning";
    public static final String LISTENER_NAME = "TenantProvisioningWebSocket";
    private static final List<String> SUPPORTED_EVENTS = Arrays.asList("deed.event.tenantCancelCommand", "deed.event.tenantCompletedCommand", "deed.event.tenantStartCommandCreated", "deed.event.tenantStopCommandCreated");
    private static final Log LOG = ExoLogger.getLogger(TenantProvisioningWebSocketService.class);
    @Autowired
    private TenantProvisioningConfiguration provisioningConfiguration;
    @Autowired
    private BlockchainConfigurationProperties blockchainProperties;
    @Autowired
    private TenantProvisioningService tenantProvisioningService;
    private EXoContinuationBayeux continuationBayeux;
    private ContinuationService continuationService;

    public void onEvent(String eventName, DeedTenant deedTenant) {
        DeedTenantProvisioningWebSocket deedTenantProvisioning = EntityMapper.toWebSocketDTO(eventName, deedTenant, this.provisioningConfiguration.getEtherscanPrefix(), this.blockchainProperties.getDeedAddress());
        Set connectedUserIds = this.getContinuationBayeux().getConnectedUserIds();
        Set<String> managers = this.tenantProvisioningService.getManagers();
        Collection usersToSendTo = CollectionUtils.intersection(managers, (Collection)connectedUserIds);
        if (CollectionUtils.isNotEmpty((Collection)usersToSendTo)) {
            String message = EntityMapper.toJsonString(deedTenantProvisioning);
            CompletableFuture.runAsync(() -> usersToSendTo.forEach(manager -> {
                try {
                    this.getContinuationService().sendMessage(manager, COMETD_CHANNEL, (Object)message);
                }
                catch (Exception e) {
                    LOG.warn("Error sending WebSocket message for user {} with message {}", new Object[]{manager, message, e});
                }
            }));
        }
    }

    public String getName() {
        return LISTENER_NAME;
    }

    public List<String> getSupportedEvents() {
        return SUPPORTED_EVENTS;
    }

    private EXoContinuationBayeux getContinuationBayeux() {
        if (this.continuationBayeux == null) {
            this.continuationBayeux = (EXoContinuationBayeux)PortalContainer.getInstance().getComponentInstanceOfType(EXoContinuationBayeux.class);
        }
        return this.continuationBayeux;
    }

    private ContinuationService getContinuationService() {
        if (this.continuationService == null) {
            this.continuationService = (ContinuationService)PortalContainer.getInstance().getComponentInstanceOfType(ContinuationService.class);
        }
        return this.continuationService;
    }
}

