/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.tenant.integration;

import javax.servlet.ServletContext;

public class SpringContext {
    private static ServletContext servletContext;

    private SpringContext() {
    }

    public static void setServletContext(ServletContext servletContext) {
        SpringContext.servletContext = servletContext;
    }

    public static ServletContext getServletContext() {
        return servletContext;
    }

    public static ClassLoader getClassLoader() {
        return servletContext == null ? null : servletContext.getClassLoader();
    }

    public static <T> T getSpringBean(Class<T> clazz) {
        if (SpringContext.getClassLoader() != Thread.currentThread().getContextClassLoader()) {
            throw new IllegalStateException("You should add @SpringIntegration in top of the method to make this integration works");
        }
        ClassLoader classLoader = SpringContext.getClassLoader();
        if (classLoader != null) {
            try {
                Object springContext = classLoader.loadClass("org.springframework.web.context.support.WebApplicationContextUtils").getMethod("getRequiredWebApplicationContext", ServletContext.class).invoke(null, servletContext);
                Object serviceInstance = springContext.getClass().getMethod("getBean", Class.class).invoke(springContext, clazz);
                return (T)serviceInstance;
            }
            catch (Exception e) {
                throw new IllegalStateException("Error loading Bean with name " + clazz, e);
            }
        }
        return null;
    }
}

