/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.tenant.metamask.web;

import io.meeds.tenant.metamask.service.MetamaskLoginService;
import io.meeds.tenant.metamask.web.MetamaskLoginExtension;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.web.ControllerContext;

public class MetamaskRegisterExtension
extends MetamaskLoginExtension {
    public static final String METAMASK_REGISTRATION_ENABLED = "metamaskRegistrationEnabled";
    private static final List<String> EXTENSION_NAMES = Arrays.asList("RegisterExtension", "LoginExtension");

    public MetamaskRegisterExtension(MetamaskLoginService metamaskLoginService) {
        super(metamaskLoginService);
    }

    @Override
    public List<String> getExtensionNames() {
        return EXTENSION_NAMES;
    }

    @Override
    public Map<String, Object> extendParameters(ControllerContext controllerContext, String extensionName) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (this.metamaskLoginService.isAllowUserRegistration()) {
            if (StringUtils.equals((CharSequence)"LoginExtension", (CharSequence)extensionName)) {
                params.put("registerEnabled", true);
            } else if (StringUtils.equals((CharSequence)"RegisterExtension", (CharSequence)extensionName)) {
                params.put(METAMASK_REGISTRATION_ENABLED, true);
                HttpSession httpSession = controllerContext.getRequest().getSession(true);
                params.put("rawMessage", this.metamaskLoginService.generateLoginMessage(httpSession));
                this.addDeedTenantParameters(httpSession, params, true);
            }
        }
        return params;
    }
}

