/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.tenant.service;

import io.meeds.tenant.integration.SpringContext;
import io.meeds.tenant.integration.SpringIntegration;
import io.meeds.tenant.integration.SpringIntegrationAspect;
import io.meeds.tenant.integration.service.TenantServiceFacade;
import io.meeds.tenant.model.DeedTenantHost;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.exoplatform.container.xml.InitParams;
import org.picocontainer.Startable;

public class TenantManagerService
implements Startable {
    public static final int MAX_START_TENTATIVES = 5;
    public static final String MANAGER_DEFAULT_ROLES_PARAM = "managerDefaultRoles";
    public static final String NFT_ID_PARAM = "nftId";
    protected TenantServiceFacade tenantServiceFacade;
    private String nftId;
    private List<String> tenantManagerDefaultRoles = new ArrayList<String>();
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;

    public TenantManagerService(InitParams params) {
        this.tenantManagerDefaultRoles = this.getParamValues(params, MANAGER_DEFAULT_ROLES_PARAM);
        this.nftId = this.getParamValue(params, NFT_ID_PARAM);
    }

    public void start() {
        if (this.isTenant()) {
            DeedTenantHost deedTenantHost = this.retrieveDeedTenant();
            if (deedTenantHost == null) {
                throw this.unreadyConfigurationException(null);
            }
            this.initMetaverseIntegration();
        }
    }

    public void stop() {
    }

    public List<String> getTenantManagerDefaultRoles() {
        return Collections.unmodifiableList(this.tenantManagerDefaultRoles);
    }

    @SpringIntegration
    public boolean isTenantManager(String address) {
        String string = address;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)string);
        return Conversions.booleanValue((Object)TenantManagerService.isTenantManager_aroundBody1$advice(this, string, joinPoint, SpringIntegrationAspect.aspectOf(), (ProceedingJoinPoint)joinPoint));
    }

    public boolean isTenant() {
        return this.getNftId() > -1L;
    }

    public long getNftId() {
        return StringUtils.isBlank((CharSequence)this.nftId) ? -1L : Long.parseLong(this.nftId);
    }

    protected TenantServiceFacade getTenantServiceFacade() {
        if (this.tenantServiceFacade == null) {
            try {
                this.tenantServiceFacade = SpringContext.getSpringBean(TenantServiceFacade.class);
            }
            catch (Exception e) {
                throw this.unreadyConfigurationException(e);
            }
        }
        if (this.tenantServiceFacade == null) {
            throw this.unreadyConfigurationException(null);
        }
        return this.tenantServiceFacade;
    }

    @SpringIntegration
    private DeedTenantHost retrieveDeedTenant() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this);
        return (DeedTenantHost)TenantManagerService.retrieveDeedTenant_aroundBody3$advice(this, joinPoint, SpringIntegrationAspect.aspectOf(), (ProceedingJoinPoint)joinPoint);
    }

    @SpringIntegration
    private void initMetaverseIntegration() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this);
        TenantManagerService.initMetaverseIntegration_aroundBody5$advice(this, joinPoint, SpringIntegrationAspect.aspectOf(), (ProceedingJoinPoint)joinPoint);
    }

    private String getParamValue(InitParams params, String paramName) {
        if (params != null && params.containsKey((Object)paramName)) {
            return params.getValueParam(paramName).getValue();
        }
        return null;
    }

    private List<String> getParamValues(InitParams params, String paramName) {
        if (params != null && params.containsKey((Object)paramName)) {
            return params.getValuesParam(paramName).getValues();
        }
        return Collections.emptyList();
    }

    private IllegalStateException unreadyConfigurationException(Exception e) {
        return new IllegalStateException("Can't Reach TenantService from Spring context, the Deed Tenant must shutdown until the correct configuration is set. (Deed Tenants ES configuration)", e);
    }

    static {
        TenantManagerService.ajc$preClinit();
    }

    private static /* synthetic */ boolean isTenantManager_aroundBody0(TenantManagerService ajc$this, String address, JoinPoint joinPoint) {
        if (ajc$this.isTenant() && StringUtils.isNotBlank((CharSequence)address)) {
            DeedTenantHost deedTenantHost = DeedTenantHost.getInstance();
            if (deedTenantHost == null || StringUtils.isBlank((CharSequence)deedTenantHost.getManagerAddress())) {
                boolean isTenantManager = ajc$this.getTenantServiceFacade().isTenantManager(address, ajc$this.getNftId());
                if (isTenantManager && deedTenantHost != null) {
                    deedTenantHost.setManagerAddress(address);
                }
                return isTenantManager;
            }
            return StringUtils.equalsIgnoreCase((CharSequence)address, (CharSequence)deedTenantHost.getManagerAddress());
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static /* synthetic */ Object isTenantManager_aroundBody1$advice(TenantManagerService ajc$this, String address, JoinPoint thisJoinPoint, SpringIntegrationAspect ajc$aspectInstance, ProceedingJoinPoint point) {
        ClassLoader springClassLoader = SpringContext.getClassLoader();
        if (springClassLoader != null) {
            ClassLoader originalContextClassLoader = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(springClassLoader);
                ProceedingJoinPoint proceedingJoinPoint = point;
                Object object = Conversions.booleanObject((boolean)TenantManagerService.isTenantManager_aroundBody0(ajc$this, address, (JoinPoint)proceedingJoinPoint));
                return object;
            }
            finally {
                Thread.currentThread().setContextClassLoader(originalContextClassLoader);
            }
        }
        SpringIntegrationAspect.ajc$inlineAccessFieldGet$io_meeds_tenant_integration_SpringIntegrationAspect$io_meeds_tenant_integration_SpringIntegrationAspect$LOG().warn((Object)"Can't find spring context, class loader is null");
        ProceedingJoinPoint proceedingJoinPoint = point;
        return Conversions.booleanObject((boolean)TenantManagerService.isTenantManager_aroundBody0(ajc$this, address, (JoinPoint)proceedingJoinPoint));
    }

    private static /* synthetic */ DeedTenantHost retrieveDeedTenant_aroundBody2(TenantManagerService ajc$this, JoinPoint joinPoint) {
        return ajc$this.getTenantServiceFacade().getDeedTenant(ajc$this.getNftId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static /* synthetic */ Object retrieveDeedTenant_aroundBody3$advice(TenantManagerService ajc$this, JoinPoint thisJoinPoint, SpringIntegrationAspect ajc$aspectInstance, ProceedingJoinPoint point) {
        ClassLoader springClassLoader = SpringContext.getClassLoader();
        if (springClassLoader != null) {
            ClassLoader originalContextClassLoader = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(springClassLoader);
                ProceedingJoinPoint proceedingJoinPoint = point;
                DeedTenantHost deedTenantHost = TenantManagerService.retrieveDeedTenant_aroundBody2(ajc$this, (JoinPoint)proceedingJoinPoint);
                return deedTenantHost;
            }
            finally {
                Thread.currentThread().setContextClassLoader(originalContextClassLoader);
            }
        }
        SpringIntegrationAspect.ajc$inlineAccessFieldGet$io_meeds_tenant_integration_SpringIntegrationAspect$io_meeds_tenant_integration_SpringIntegrationAspect$LOG().warn((Object)"Can't find spring context, class loader is null");
        ProceedingJoinPoint proceedingJoinPoint = point;
        return TenantManagerService.retrieveDeedTenant_aroundBody2(ajc$this, (JoinPoint)proceedingJoinPoint);
    }

    private static /* synthetic */ void initMetaverseIntegration_aroundBody4(TenantManagerService ajc$this, JoinPoint joinPoint) {
        ajc$this.getTenantServiceFacade().initMetaverseIntegration();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static /* synthetic */ Object initMetaverseIntegration_aroundBody5$advice(TenantManagerService ajc$this, JoinPoint thisJoinPoint, SpringIntegrationAspect ajc$aspectInstance, ProceedingJoinPoint point) {
        ClassLoader springClassLoader = SpringContext.getClassLoader();
        if (springClassLoader != null) {
            ClassLoader originalContextClassLoader = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(springClassLoader);
                ProceedingJoinPoint proceedingJoinPoint = point;
                TenantManagerService.initMetaverseIntegration_aroundBody4(ajc$this, (JoinPoint)proceedingJoinPoint);
                Object var6_7 = null;
                return var6_7;
            }
            finally {
                Thread.currentThread().setContextClassLoader(originalContextClassLoader);
            }
        }
        SpringIntegrationAspect.ajc$inlineAccessFieldGet$io_meeds_tenant_integration_SpringIntegrationAspect$io_meeds_tenant_integration_SpringIntegrationAspect$LOG().warn((Object)"Can't find spring context, class loader is null");
        ProceedingJoinPoint proceedingJoinPoint = point;
        TenantManagerService.initMetaverseIntegration_aroundBody4(ajc$this, (JoinPoint)proceedingJoinPoint);
        return null;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("TenantManagerService.java", TenantManagerService.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "isTenantManager", "io.meeds.tenant.service.TenantManagerService", "java.lang.String", "address", "", "boolean"), 78);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "retrieveDeedTenant", "io.meeds.tenant.service.TenantManagerService", "", "", "", "io.meeds.tenant.model.DeedTenantHost"), 118);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "initMetaverseIntegration", "io.meeds.tenant.service.TenantManagerService", "", "", "", "void"), 123);
    }
}

