/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.tenant.hub.listener;

import io.meeds.tenant.hub.listener.HubConnectedAutoSendReportListener;
import io.meeds.tenant.hub.service.HubReportService;
import io.meeds.wom.api.model.Hub;
import java.time.Instant;
import java.time.LocalDate;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.wallet.model.reward.RewardPeriod;
import org.exoplatform.wallet.model.reward.RewardReport;
import org.exoplatform.wallet.reward.service.RewardReportService;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.verification.VerificationMode;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.mock.mockito.MockBean;

@SpringBootTest(classes={HubConnectedAutoSendReportListener.class})
@ExtendWith(value={MockitoExtension.class})
public class HubConnectedAutoSendReportListenerTest {
    @MockBean
    private RewardReportService rewardReportService;
    @MockBean
    private HubReportService hubReportService;
    @MockBean
    private ListenerService listenerService;
    @Mock
    private Hub hub;
    @Mock
    private RewardReport rewardReport;
    @Mock
    private RewardPeriod period;
    @Mock
    private Event<Hub, Object> event;
    @Autowired
    private HubConnectedAutoSendReportListener listener;
    private long periodId = 3L;

    @Test
    public void autoSendLastReportOnEvent() throws Exception {
        Mockito.when((Object)((Hub)this.event.getSource())).thenReturn((Object)this.hub);
        Mockito.when((Object)this.hub.isConnected()).thenReturn((Object)true);
        Mockito.when((Object)this.hub.getJoinDate()).thenReturn((Object)Instant.now());
        Mockito.when((Object)this.rewardReportService.getRewardReport((LocalDate)ArgumentMatchers.any())).thenReturn((Object)this.rewardReport);
        Mockito.when((Object)this.rewardReport.isCompletelyProceeded()).thenReturn((Object)true);
        Mockito.when((Object)this.rewardReport.getPeriod()).thenReturn((Object)this.period);
        Mockito.when((Object)this.period.getId()).thenReturn((Object)this.periodId);
        Mockito.when((Object)this.hubReportService.getReportId(this.periodId)).thenReturn((Object)0L);
        this.listener.onEvent(this.event);
        ((HubReportService)Mockito.verify((Object)this.hubReportService)).sendReport(this.periodId);
    }

    @Test
    public void avoidAutoSendWhenNoLastReport() throws Exception {
        Mockito.when((Object)((Hub)this.event.getSource())).thenReturn((Object)this.hub);
        Mockito.when((Object)this.hub.isConnected()).thenReturn((Object)true);
        Mockito.when((Object)this.hub.getJoinDate()).thenReturn((Object)Instant.now());
        this.listener.onEvent(this.event);
        Mockito.verifyNoInteractions((Object[])new Object[]{this.hubReportService});
    }

    @Test
    public void avoidAutoSendLastReportWhenNotCompleted() throws Exception {
        Mockito.when((Object)((Hub)this.event.getSource())).thenReturn((Object)this.hub);
        Mockito.when((Object)this.hub.isConnected()).thenReturn((Object)true);
        Mockito.when((Object)this.hub.getJoinDate()).thenReturn((Object)Instant.now());
        Mockito.when((Object)this.rewardReportService.getRewardReport((LocalDate)ArgumentMatchers.any())).thenReturn((Object)this.rewardReport);
        this.listener.onEvent(this.event);
        Mockito.verifyNoInteractions((Object[])new Object[]{this.hubReportService});
    }

    @Test
    public void avoidAutoSendLastReportWhenAlreadySent() throws Exception {
        Mockito.when((Object)((Hub)this.event.getSource())).thenReturn((Object)this.hub);
        Mockito.when((Object)this.hub.isConnected()).thenReturn((Object)true);
        Mockito.when((Object)this.hub.getJoinDate()).thenReturn((Object)Instant.now());
        Mockito.when((Object)this.rewardReportService.getRewardReport((LocalDate)ArgumentMatchers.any())).thenReturn((Object)this.rewardReport);
        Mockito.when((Object)this.rewardReport.isCompletelyProceeded()).thenReturn((Object)true);
        Mockito.when((Object)this.rewardReport.getPeriod()).thenReturn((Object)this.period);
        Mockito.when((Object)this.period.getId()).thenReturn((Object)this.periodId);
        Mockito.when((Object)this.hubReportService.getReportId(this.periodId)).thenReturn((Object)2L);
        this.listener.onEvent(this.event);
        ((HubReportService)Mockito.verify((Object)this.hubReportService, (VerificationMode)Mockito.never())).sendReport(Mockito.anyLong());
    }

    @Test
    public void avoidAutoSendLastReportWhenJoinDateIsBeforeOneHour() throws Exception {
        Mockito.when((Object)((Hub)this.event.getSource())).thenReturn((Object)this.hub);
        Mockito.when((Object)this.hub.isConnected()).thenReturn((Object)true);
        Mockito.when((Object)this.hub.getJoinDate()).thenReturn((Object)Instant.now().minusSeconds(7200L));
        this.listener.onEvent(this.event);
        Mockito.verifyNoInteractions((Object[])new Object[]{this.hubReportService});
        Mockito.verifyNoInteractions((Object[])new Object[]{this.rewardReportService});
    }

    @Test
    public void avoidAutoSendLastReportWhenJoinDateIsNull() throws Exception {
        Mockito.when((Object)((Hub)this.event.getSource())).thenReturn((Object)this.hub);
        Mockito.when((Object)this.hub.isConnected()).thenReturn((Object)true);
        this.listener.onEvent(this.event);
        ((Hub)Mockito.verify((Object)this.hub)).isConnected();
        Mockito.verifyNoInteractions((Object[])new Object[]{this.hubReportService});
    }

    @Test
    public void avoidAutoSendLastReportWhenNotConnected() throws Exception {
        Mockito.when((Object)((Hub)this.event.getSource())).thenReturn((Object)this.hub);
        this.listener.onEvent(this.event);
        ((Hub)Mockito.verify((Object)this.hub, (VerificationMode)Mockito.never())).getJoinDate();
        Mockito.verifyNoInteractions((Object[])new Object[]{this.hubReportService});
    }
}

