/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.tenant.hub.service;

import io.meeds.gamification.constant.DateFilterType;
import io.meeds.gamification.constant.EntityStatusType;
import io.meeds.gamification.constant.IdentityType;
import io.meeds.gamification.constant.RealizationStatus;
import io.meeds.gamification.model.filter.RealizationFilter;
import io.meeds.gamification.model.filter.RuleFilter;
import io.meeds.gamification.service.RealizationService;
import io.meeds.gamification.service.RuleService;
import io.meeds.tenant.hub.constant.HubReportStatusType;
import io.meeds.tenant.hub.model.HubReportLocalStatus;
import io.meeds.tenant.hub.model.HubTenant;
import io.meeds.tenant.hub.rest.client.WomClientService;
import io.meeds.tenant.hub.service.HubService;
import io.meeds.tenant.hub.storage.HubReportStorage;
import io.meeds.tenant.hub.storage.HubWalletStorage;
import io.meeds.tenant.hub.utils.EntityMapper;
import io.meeds.wom.api.constant.WomException;
import io.meeds.wom.api.constant.WomParsingException;
import io.meeds.wom.api.model.HubReport;
import io.meeds.wom.api.model.HubReportPayload;
import io.meeds.wom.api.model.HubReportVerifiableData;
import io.meeds.wom.api.utils.JsonUtils;
import java.time.Instant;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.UserStatus;
import org.exoplatform.wallet.model.reward.RewardPeriod;
import org.exoplatform.wallet.model.reward.RewardReport;
import org.exoplatform.wallet.reward.service.RewardReportService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.web3j.crypto.Hash;

@Service
public class HubReportService {
    public static final String REPORT_SENT_EVENT = "deed.tenant.report.sent";
    public static final String REPORT_SENDING_IN_PROGRESS_EVENT = "deed.tenant.report.sending";
    public static final String REPORT_SENDING_ERROR_EVENT = "deed.tenant.report.error";
    public static final String REPORT_PERSISTED_EVENT = "deed.tenant.report.persistedInServer";
    public static final String REPORT_PERSIST_ERROR_EVENT = "deed.tenant.report.persistError";
    private static final String DEFAULT_LOG_LANG = Locale.ENGLISH.toLanguageTag();
    private static final Log LOG = ExoLogger.getLogger(HubReportService.class);
    @Autowired
    private OrganizationService organizationService;
    @Autowired
    private RewardReportService rewardReportService;
    @Autowired
    private RealizationService realizationService;
    @Autowired
    private RuleService ruleService;
    @Autowired
    private HubService hubService;
    @Autowired
    private WomClientService womServiceClient;
    @Autowired
    private HubWalletStorage hubWalletStorage;
    @Autowired
    private HubReportStorage hubReportStorage;
    @Autowired
    private ListenerService listenerService;

    public HubReportLocalStatus sendReport(long periodId) throws WomException {
        RewardReport rewardReport = this.rewardReportService.getRewardReportByPeriodId(periodId);
        if (rewardReport == null) {
            return null;
        }
        return this.sendReport(rewardReport);
    }

    public HubReportLocalStatus sendReport(RewardReport rewardReport) throws WomException {
        if (!this.hubService.isConnected()) {
            return null;
        }
        RewardPeriod rewardPeriod = rewardReport.getPeriod();
        if (!rewardReport.isCompletelyProceeded()) {
            return null;
        }
        HubReportPayload reportData = this.toReport(rewardReport);
        HubTenant hub = this.hubService.getHub(true);
        long start = System.currentTimeMillis();
        LOG.info("Sending: Hub Report of Reward date '{}' to '{}' to UEM", new Object[]{rewardPeriod.getStartDateFormatted(DEFAULT_LOG_LANG), rewardPeriod.getEndDateFormatted(DEFAULT_LOG_LANG)});
        long reportId = this.sendTransaction(rewardPeriod, reportData, hub);
        reportData.setReportId(reportId);
        LOG.info("Sent: Hub Report with id '{}' of Reward date '{}' to '{}' to UEM within {}ms", new Object[]{rewardPeriod.getStartDateFormatted(DEFAULT_LOG_LANG), rewardPeriod.getEndDateFormatted(DEFAULT_LOG_LANG), reportId, System.currentTimeMillis() - start});
        HubReport report = this.persistReport(reportData);
        return EntityMapper.toHubLocalReport(report, this.hubReportStorage.getPeriodKey(rewardPeriod), HubReportStatusType.SENT.isCanRefresh(), HubReportStatusType.SENT.isCanSend(), HubReportStatusType.SENT, null);
    }

    public List<HubReportLocalStatus> getReports(int offset, int limit) {
        List rewardPeriods = this.rewardReportService.findRewardReportPeriods(offset, limit);
        if (CollectionUtils.isEmpty((Collection)rewardPeriods)) {
            return Collections.emptyList();
        }
        return rewardPeriods.stream().map(p -> this.rewardReportService.getRewardReport(p.getPeriodMedianDate())).filter(Objects::nonNull).map(this::generateNewReport).toList();
    }

    public HubReportLocalStatus getReport(long periodId, boolean refresh) throws WomException {
        if (refresh) {
            return this.retrieveReport(periodId);
        }
        RewardReport rewardReport = this.rewardReportService.getRewardReportByPeriodId(periodId);
        if (rewardReport == null) {
            throw new WomException("wom.unableToRetrieveReward");
        }
        return this.generateNewReport(rewardReport);
    }

    public long getReportId(long periodId) {
        return this.hubReportStorage.getReportId(periodId);
    }

    public long getPeriodId(long reportId) {
        return this.hubReportStorage.getPeriodId(reportId);
    }

    private HubReportLocalStatus retrieveReport(long periodId) throws WomException {
        long reportId = this.hubReportStorage.getReportId(periodId);
        if (reportId == 0L) {
            throw new WomException("wom.notSentReward");
        }
        HubReport report = this.womServiceClient.retrieveReport(reportId);
        if (report == null) {
            throw new WomException("wom.rewardNotFoundInWom");
        }
        return EntityMapper.toHubLocalReport(report, periodId, HubReportStatusType.SENT.isCanRefresh(), HubReportStatusType.SENT.isCanSend(), HubReportStatusType.SENT, null);
    }

    private long sendTransaction(RewardPeriod rewardPeriod, HubReportPayload reportData, HubTenant hub) throws WomException {
        long reportId;
        try {
            this.markReportAsSending(rewardPeriod);
            reportId = this.hubWalletStorage.sendReportTransaction(reportData, hub.getUemAddress(), hub.getNetworkId());
            this.markReportAsSent(rewardPeriod, reportId);
        }
        catch (WomException e) {
            this.markReportAsError(rewardPeriod, e);
            throw e;
        }
        catch (RuntimeException e) {
            this.markReportAsError(rewardPeriod, new WomException("wom.unknownError", true));
            throw e;
        }
        finally {
            String status = this.hubReportStorage.getStatus(rewardPeriod);
            HubReportStatusType statusType = this.computeReportStatusType(status);
            if (statusType == HubReportStatusType.SENDING) {
                this.markReportAsError(rewardPeriod, new WomException("wom.unknownError", true));
            }
        }
        return reportId;
    }

    private HubReport persistReport(HubReportPayload reportData) throws WomException {
        String signature = this.signHubMessage(reportData);
        String hash = StringUtils.lowerCase((String)Hash.sha3((String)signature));
        HubReportVerifiableData reportRequest = new HubReportVerifiableData(hash, signature, reportData);
        HubReport report = this.womServiceClient.saveReport(reportRequest);
        this.listenerService.broadcast(REPORT_PERSISTED_EVENT, (Object)reportRequest.getReportId(), null);
        return report;
    }

    private String signHubMessage(HubReportPayload reportData) throws WomException {
        String rawRequest = JsonUtils.toJsonString((Object)reportData);
        return this.hubWalletStorage.signHubMessage(rawRequest);
    }

    private HubReportPayload toReport(RewardReport rewardReport) {
        RewardPeriod rewardPeriod = rewardReport.getPeriod();
        Date fromDate = Date.from(Instant.ofEpochSecond(rewardPeriod.getStartDateInSeconds()));
        Date toDate = Date.from(Instant.ofEpochSecond(rewardPeriod.getEndDateInSeconds()));
        return EntityMapper.toHubReport(rewardReport, this.hubService.getHubAddress(), this.hubService.getDeedId(), this.computeUsersCount(), this.countParticipants(fromDate, toDate), this.countAchievements(fromDate, toDate), this.countActions(), this.hubReportStorage.getSentDate(rewardPeriod));
    }

    private void markReportAsSent(RewardPeriod rewardPeriod, long reportId) {
        this.hubReportStorage.saveReportPeriodId(rewardPeriod, reportId);
        this.hubReportStorage.saveStatus(rewardPeriod, HubReportStatusType.SENT.name());
        this.hubReportStorage.saveSentDate(rewardPeriod, Instant.now());
        this.listenerService.broadcast(REPORT_SENT_EVENT, (Object)rewardPeriod.getId(), (Object)reportId);
    }

    private void markReportAsSending(RewardPeriod rewardPeriod) {
        this.hubReportStorage.saveStatus(rewardPeriod, HubReportStatusType.SENDING.name());
        this.listenerService.broadcast(REPORT_SENDING_IN_PROGRESS_EVENT, (Object)rewardPeriod.getId(), null);
    }

    private void markReportAsError(RewardPeriod rewardPeriod, String error) {
        this.hubReportStorage.saveStatus(rewardPeriod, error);
        this.listenerService.broadcast(REPORT_SENDING_ERROR_EVENT, (Object)rewardPeriod.getId(), null);
    }

    private void markReportAsError(RewardPeriod rewardPeriod, WomException e) throws WomParsingException {
        String error = JsonUtils.toJsonString((Object)e.getErrorCode());
        this.markReportAsError(rewardPeriod, error);
    }

    private HubReportStatusType computeReportStatusType(String status) {
        if (StringUtils.isBlank((CharSequence)status)) {
            if (!this.hubService.isConnected()) {
                return HubReportStatusType.NONE;
            }
            return HubReportStatusType.INVALID;
        }
        return switch (status) {
            case "SENT" -> HubReportStatusType.SENT;
            case "PENDING_REWARD" -> HubReportStatusType.PENDING_REWARD;
            case "REWARDED" -> HubReportStatusType.REWARDED;
            case "REJECTED" -> HubReportStatusType.REJECTED;
            case "SENDING" -> HubReportStatusType.SENDING;
            case "INVALID" -> HubReportStatusType.INVALID;
            default -> HubReportStatusType.ERROR_SENDING;
        };
    }

    public long computeUsersCount() {
        return this.organizationService.getUserHandler().findAllUsers(UserStatus.ENABLED).getSize();
    }

    private long countParticipants(Date fromDate, Date toDate) {
        return this.realizationService.countParticipantsBetweenDates(fromDate, toDate);
    }

    private int countAchievements(Date fromDate, Date toDate) {
        RealizationFilter realizationFilter = new RealizationFilter();
        realizationFilter.setFromDate(fromDate);
        realizationFilter.setToDate(toDate);
        realizationFilter.setEarnerType(IdentityType.USER);
        realizationFilter.setStatus(RealizationStatus.ACCEPTED);
        return this.realizationService.countRealizationsByFilter(realizationFilter);
    }

    private int countActions() {
        RuleFilter ruleFilter = new RuleFilter();
        ruleFilter.setAllSpaces(true);
        ruleFilter.setStatus(EntityStatusType.ENABLED);
        ruleFilter.setProgramStatus(EntityStatusType.ENABLED);
        ruleFilter.setDateFilterType(DateFilterType.STARTED);
        return this.ruleService.countRules(ruleFilter);
    }

    private HubReportLocalStatus generateNewReport(RewardReport rewardReport) {
        RewardPeriod rewardPeriod = rewardReport.getPeriod();
        String status = this.hubReportStorage.getStatus(rewardPeriod);
        HubReportStatusType statusType = this.computeReportStatusType(status);
        String errorMessageKey = statusType == HubReportStatusType.ERROR_SENDING ? status : null;
        HubReportPayload reportData = this.toReport(rewardReport);
        long reportId = this.hubReportStorage.getReportId(rewardPeriod);
        long periodId = this.hubReportStorage.getPeriodKey(rewardPeriod);
        boolean canRefresh = statusType.isCanRefresh() && reportId == 0L;
        boolean canSend = statusType.isCanSend();
        HubReportLocalStatus reportLocalStatus = EntityMapper.toHubLocalReport(reportData, periodId, reportId, canRefresh, canSend, statusType, errorMessageKey);
        if (reportId == 0L && !canSend) {
            reportLocalStatus.setDeedId(-1L);
        }
        return reportLocalStatus;
    }
}

