package org.exoplatform.social.service.malwareDetection;

import org.mockito.Mockito;

import org.exoplatform.social.service.malwareDetection.connector.MalwareDetectionItemConnector;
import org.exoplatform.social.service.test.AbstractResourceTest;

public class MalwareDetectionServiceTest extends AbstractResourceTest {
  
  private MalwareDetectionService malwareDetectionService;

  public void setUp() throws Exception {
    super.setUp();
    malwareDetectionService = getContainer().getComponentInstanceOfType(MalwareDetectionService.class);
  }

  public void testProcessInfectedItem() {
    String infectedItemPath = "/gatein/data/files/d/e/4/c/e/2/d/7/dedeerere673r777";
    MalwareDetectionItemConnector malwareDetectionItemConnector = Mockito.mock(MalwareDetectionItemConnector.class);
    Mockito.when(malwareDetectionItemConnector.getType()).thenReturn("files");
    malwareDetectionService.addMalwareDetectionItemConnector(malwareDetectionItemConnector);
    Mockito.when(malwareDetectionItemConnector.canProcessInfectedItem(Mockito.anyString())).thenReturn(true);
    malwareDetectionService.processInfectedItem(infectedItemPath);
    Mockito.verify(malwareDetectionItemConnector, Mockito.times(1)).processInfectedItem(infectedItemPath);
  }
}