package org.exoplatform.social.notification.web.template;

import java.util.List;

import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.channel.AbstractChannel;
import org.exoplatform.commons.api.notification.channel.ChannelManager;
import org.exoplatform.commons.api.notification.channel.template.AbstractTemplateBuilder;
import org.exoplatform.commons.api.notification.model.ArgumentLiteral;
import org.exoplatform.commons.api.notification.model.ChannelKey;
import org.exoplatform.commons.api.notification.model.MessageInfo;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.api.notification.model.PluginKey;
import org.exoplatform.commons.api.notification.plugin.BaseNotificationPlugin;
import org.exoplatform.commons.notification.channel.WebChannel;
import org.exoplatform.commons.notification.impl.NotificationContextImpl;
import org.exoplatform.social.notification.AbstractPluginTest;
import org.exoplatform.social.notification.plugin.MalwareDetectionPlugin;

public class MalwareDetectionWebBuilderTest extends AbstractPluginTest {
  public static final String INFECTED_ITEM_NAME = "infectedItemName";
  public static final ArgumentLiteral<String> INFECTED_ITEM_NAME_ARGUMENT = new ArgumentLiteral<String>(String.class, INFECTED_ITEM_NAME);
  public static final String INFECTED_ITEM_LAST_MODIFIER = "infectedItemLastModifier";
  public static final ArgumentLiteral<String> INFECTED_ITEM_LAST_MODIFIER_ARGUMENT = new ArgumentLiteral<String>(String.class, INFECTED_ITEM_LAST_MODIFIER);

  private ChannelManager manager;
  
  @Override
  protected void setUp() throws Exception {
    super.setUp();
    manager = getService(ChannelManager.class);
  }

  @Override
  public void tearDown() throws Exception {
    super.tearDown();
  }

  @Override
  public AbstractTemplateBuilder getTemplateBuilder() {
    AbstractChannel channel = manager.getChannel(ChannelKey.key(WebChannel.ID));
    assertNotNull(channel);
    assertTrue(channel.hasTemplateBuilder(PluginKey.key(MalwareDetectionPlugin.ID)));
    return channel.getTemplateBuilder(PluginKey.key(MalwareDetectionPlugin.ID));
  }

  @Override
  public BaseNotificationPlugin getPlugin() {
    return pluginService.getPlugin(PluginKey.key(MalwareDetectionPlugin.ID));
  }

  public void testSimpleCase() {
    // When

    NotificationContext ctx = NotificationContextImpl.cloneInstance();
    ctx.append(INFECTED_ITEM_NAME_ARGUMENT, "test.docx");
    ctx.append(INFECTED_ITEM_LAST_MODIFIER_ARGUMENT, maryIdentity.getRemoteId());
    ctx.getNotificationExecutor().with(ctx.makeCommand(PluginKey.key(MalwareDetectionPlugin.ID))).execute(ctx);

    // then
    List<NotificationInfo> list = assertMadeWebNotifications(maryIdentity.getRemoteId(), 1);

    // assert Message Info
    ctx.setNotificationInfo(list.get(0).setTo(rootIdentity.getRemoteId()));
    MessageInfo message = buildMessageInfo(ctx);

    assertBody(message, "has been detected as a malware. So the file is no longer available.");
    notificationService.clearAll();
  }
}
