/**
 * This file is part of the Meeds project (https://meeds.io/).
 *
 * Copyright (C) 2020 - 2025 Meeds Association contact@meeds.io
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */
package org.exoplatform.commons.notification.impl.jpa.email.entity;

import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.NamedQuery;
import jakarta.persistence.SequenceGenerator;
import jakarta.persistence.Table;

@Entity(name = "NotificationsMailParamsEntity")
@Table(name = "NTF_EMAIL_NOTIFS_PARAMS")
@NamedQuery(name = "NotificationsMailParamsEntity.deleteParamsOfNotifications", query = "DELETE FROM NotificationsMailParamsEntity m " +
    "WHERE m.notification.id IN ( :notifications ) ")
public class MailParamEntity {
  @Id
  @Column(name = "EMAIL_NOTIF_PARAMS_ID")
  @SequenceGenerator(name="SEQ_NTF_EMAIL_PARAMS", sequenceName="SEQ_NTF_EMAIL_PARAMS", allocationSize = 1)
  @GeneratedValue(strategy=GenerationType.AUTO, generator="SEQ_NTF_EMAIL_PARAMS")
  private long id;

  @Column(name = "PARAM_NAME")
  private String name;

  @Column(name = "PARAM_VALUE")
  private String value;

  @ManyToOne
  @JoinColumn(name = "EMAIL_NOTIF_ID")
  private MailNotifEntity notification;

  public long getId() {
    return id;
  }

  public String getName() {
    return name;
  }

  public MailParamEntity setName(String name) {
    this.name = name;
    return this;
  }

  public String getValue() {
    return value;
  }

  public MailParamEntity setValue(String value) {
    this.value = value;
    return this;
  }

  public MailNotifEntity getNotification() {
    return notification;
  }

  public MailParamEntity setNotification(MailNotifEntity notification) {
    this.notification = notification;
    return this;
  }
}
