/**
 * This file is part of the Meeds project (https://meeds.io/).
 *
 * Copyright (C) 2020 - 2025 Meeds Association contact@meeds.io
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */
package org.exoplatform.commons.notification;

import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.notification.impl.NotificationContextImpl;
import org.exoplatform.commons.notification.job.NotificationJob;

public class NotificationContextImplTest extends BaseNotificationTestCase {
  
  @Override
  public void setUp() throws Exception {
    super.setUp();
  }
  
  @Override
  public void tearDown() throws Exception {
    super.tearDown();
  }
  
  public void testDailyContext() throws Exception {
    NotificationContext context = NotificationContextImpl.cloneInstance();
    context.append(NotificationJob.JOB_DAILY, true);
    Boolean value = context.value(NotificationJob.JOB_DAILY);
    assertNotNull(value);
    assertTrue(value);
    value = context.value(NotificationJob.JOB_WEEKLY);
    assertNotNull(value);
    assertFalse(value);
  }
  
  public void testWeeklyContext() throws Exception {
    NotificationContext context = NotificationContextImpl.cloneInstance();
    context.append(NotificationJob.JOB_WEEKLY, true);
    Boolean value = context.value(NotificationJob.JOB_WEEKLY);
    assertNotNull(value);
    assertTrue(value);
    value = context.value(NotificationJob.JOB_DAILY);
    assertNotNull(value);
    assertFalse(value);
  }
}
