/**
 * This file is part of the Meeds project (https://meeds.io/).
 *
 * Copyright (C) 2020 - 2025 Meeds Association contact@meeds.io
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */
package io.meeds.social.space.listener;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.space.spi.SpaceLifeCycleEvent;
import org.exoplatform.social.core.space.spi.SpaceLifeCycleListener;
import org.exoplatform.social.core.space.spi.SpaceService;

import io.meeds.social.space.service.SpaceLayoutService;

import jakarta.annotation.PostConstruct;

@Service
public class SpaceLayoutHandlerPlugin implements SpaceLifeCycleListener {

  private static final Log   LOG = ExoLogger.getLogger(SpaceLayoutHandlerPlugin.class);

  @Autowired
  private SpaceService       spaceService;

  @Autowired
  private SpaceLayoutService spaceLayoutService;

  @PostConstruct
  public void init() {
    spaceService.registerSpaceLifeCycleListener(this);
  }

  @Override
  public void spaceCreated(SpaceLifeCycleEvent event) {
    try {
      spaceLayoutService.createSpaceSite(event.getPayload());
    } catch (Exception e) {
      LOG.error("Can't create Site for Space {} width id", event.getPayload().getDisplayName(), event.getPayload().getId(), e);
    }
  }

}
