/**
 * This file is part of the Meeds project (https://meeds.io/).
 *
 * Copyright (C) 2020 - 2025 Meeds Association contact@meeds.io
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */
package org.exoplatform.services.organization;

import java.io.Serializable;

/**
 * This is the interface for the membership data model.
 */
public interface Membership extends Serializable
{
   /**
    * the type of Membership allows distinction between 'hierarchical' and
    * 'supportive' Memberships.
    * @return the name of the MembershipType
    */
   public String getMembershipType();

   /**
    * @param type the name of the MembershipType.
    */
   public void setMembershipType(String type);

   /**
    * @return the id of the MembershipType.
    */
   public String getId();

   /**
    * @return the id of the Group.
    */
   public String getGroupId();

   /**
    * @return the name of the user.
    */
   public String getUserName();
}
