/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.rest.impl.spacemembership;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.SpaceFilter;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.rest.api.EntityBuilder;
import org.exoplatform.social.rest.api.RestUtils;
import org.exoplatform.social.rest.api.SpaceMembershipRestResources;
import org.exoplatform.social.rest.entity.CollectionEntity;
import org.exoplatform.social.rest.entity.DataEntity;
import org.exoplatform.social.rest.entity.SpaceMembershipEntity;
import org.exoplatform.social.service.rest.RestChecker;
import org.exoplatform.social.service.utils.LogUtils;

@Path(value="v1/social/spacesMemberships")
@Api(tags={"v1/social/spacesMemberships"}, value="v1/social/spacesMemberships", description="Managing memberships of users in a space")
public class SpaceMembershipRestResourcesV1
implements SpaceMembershipRestResources {
    private static final String SPACE_PREFIX = "/spaces/";
    private SpaceService spaceService;
    private IdentityManager identityManager;

    public SpaceMembershipRestResourcesV1(SpaceService spaceService, IdentityManager identityManager) {
        this.spaceService = spaceService;
        this.identityManager = identityManager;
    }

    @Override
    @GET
    @RolesAllowed(value={"users"})
    @ApiOperation(value="Gets space memberships", httpMethod="GET", response=Response.class, notes="This returns space memberships in the following cases: <br/><ul><li>the sender of the space membership is the authenticated user</li><li>the authenticated user is a manager of the space</li><li>the authenticated user is the super user</li></ul>")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=404, message="Resource not found"), @ApiResponse(code=500, message="Internal server error"), @ApiResponse(code=400, message="Invalid query input")})
    public Response getSpacesMemberships(@Context UriInfo uriInfo, @ApiParam(value="Space display name to get membership, ex: my space", required=false) @QueryParam(value="space") String spaceDisplayName, @ApiParam(value="User name to filter only memberships of the given user", required=false) @QueryParam(value="user") String user, @ApiParam(value="Type of membership to get (All, Pending, Approved, Invited)", required=false) @QueryParam(value="status") String status, @ApiParam(value="Offset", required=false, defaultValue="0") @QueryParam(value="offset") int offset, @ApiParam(value="Limit", required=false, defaultValue="20") @QueryParam(value="limit") int limit, @ApiParam(value="Asking for a full representation of a specific subresource if any", required=false) @QueryParam(value="expand") String expand, @ApiParam(value="Returning the number of memberships or not", defaultValue="false") @QueryParam(value="returnSize") boolean returnSize) throws Exception {
        MembershipType membershipType;
        Space space;
        String authenticatedUser = ConversationState.getCurrent().getIdentity().getUserId();
        if (user == null) {
            user = authenticatedUser;
        }
        if (!this.spaceService.isSuperManager(authenticatedUser) && (StringUtils.isNotEmpty((String)spaceDisplayName) ? (space = this.spaceService.getSpaceByDisplayName(spaceDisplayName)) == null || !this.spaceService.isManager(space, authenticatedUser) : !user.equals(authenticatedUser))) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        offset = offset > 0 ? offset : RestUtils.getOffset(uriInfo);
        limit = limit > 0 ? limit : RestUtils.getLimit(uriInfo);
        try {
            membershipType = MembershipType.valueOf(status.toUpperCase());
        }
        catch (Exception e) {
            membershipType = MembershipType.ALL;
        }
        ListAccess listAccess = null;
        switch (membershipType) {
            case PENDING: {
                listAccess = spaceDisplayName != null ? this.spaceService.getPendingSpacesByFilter(user, new SpaceFilter(spaceDisplayName)) : this.spaceService.getPendingSpacesWithListAccess(user);
                break;
            }
            case APPROVED: {
                listAccess = spaceDisplayName != null ? this.spaceService.getAccessibleSpacesByFilter(user, new SpaceFilter(spaceDisplayName)) : this.spaceService.getAccessibleSpacesWithListAccess(user);
                break;
            }
            case INVITED: {
                listAccess = spaceDisplayName != null ? this.spaceService.getInvitedSpacesByFilter(user, new SpaceFilter(spaceDisplayName)) : this.spaceService.getInvitedSpacesWithListAccess(user);
                break;
            }
            default: {
                SpaceFilter spaceFilter = new SpaceFilter();
                if (spaceDisplayName != null) {
                    spaceFilter.setSpaceNameSearchCondition(spaceDisplayName);
                }
                spaceFilter.setRemoteId(user);
                listAccess = this.spaceService.getAllSpacesByFilter(spaceFilter);
            }
        }
        List<DataEntity> spaceMemberships = this.getSpaceMemberships(Arrays.asList(listAccess.load(offset, limit)), user, uriInfo.getPath(), expand);
        CollectionEntity spacesMemberships = new CollectionEntity(spaceMemberships, "spacesMemberships", offset, limit);
        if (returnSize) {
            spacesMemberships.setSize(listAccess.getSize());
        }
        Response.ResponseBuilder builder = EntityBuilder.getResponseBuilder(spacesMemberships, uriInfo, RestUtils.getJsonMediaType(), Response.Status.OK);
        CacheControl cc = new CacheControl();
        cc.setNoStore(true);
        builder.cacheControl(cc);
        return builder.build();
    }

    @Override
    @POST
    @RolesAllowed(value={"users"})
    @ApiOperation(value="Creates a space membership for a specific user", httpMethod="POST", response=Response.class, notes="This creates the space membership in the following cases: <br/><ul><li>the sender of the space membership is the authenticated user and the space subscription is open</li><li>the authenticated user is a manager of the space</li><li>the authenticated user is a spaces super manager</li></ul>")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=500, message="Internal server error"), @ApiResponse(code=400, message="Invalid query input")})
    public Response addSpacesMemberships(@Context UriInfo uriInfo, @ApiParam(value="Asking for a full representation of a specific subresource if any", required=false) @QueryParam(value="expand") String expand, @ApiParam(value="Space membership object to be created, ex:<br />{<br />\"role\": \"manager\",<br />\"user\": \"john\",<br />\"space\": \"my space\"<br />}", required=true) SpaceMembershipEntity model) throws Exception {
        Response response;
        if (model == null || model.getUser() == null || model.getSpace() == null) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        String user = model.getUser();
        String space = model.getSpace();
        String authenticatedUser = ConversationState.getCurrent().getIdentity().getUserId();
        if (space == null || this.spaceService.getSpaceByDisplayName(space) == null) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        Space givenSpace = this.spaceService.getSpaceByDisplayName(space);
        if (!MembershipType.IGNORED.name().equals(model.getStatus())) {
            if (user == null || this.identityManager.getOrCreateIdentity("organization", user, true) == null) {
                throw new WebApplicationException(Response.Status.UNAUTHORIZED);
            }
            if (this.spaceService.isSuperManager(authenticatedUser) || this.spaceService.isManager(givenSpace, authenticatedUser) || authenticatedUser.equals(user) && givenSpace.getRegistration().equals("open")) {
                this.spaceService.addMember(givenSpace, user);
                if ("manager".equalsIgnoreCase(model.getRole())) {
                    this.spaceService.setManager(givenSpace, user, true);
                }
            } else {
                throw new WebApplicationException(Response.Status.UNAUTHORIZED);
            }
            SpaceMembershipEntity membershipEntity = EntityBuilder.buildEntityFromSpaceMembership(givenSpace, user, "", uriInfo.getPath(), expand);
            response = EntityBuilder.getResponse(membershipEntity, uriInfo, RestUtils.getJsonMediaType(), Response.Status.OK);
        } else {
            SpaceMembershipEntity membershipEntity = EntityBuilder.createSpaceMembershipForIgnoredStatus(givenSpace, user, "", uriInfo.getPath(), expand);
            this.spaceService.setIgnored(givenSpace.getId(), user);
            response = EntityBuilder.getResponse(membershipEntity, uriInfo, RestUtils.getJsonMediaType(), Response.Status.OK);
        }
        return response;
    }

    @Override
    @GET
    @Path(value="{id}")
    @RolesAllowed(value={"users"})
    @ApiOperation(value="Gets a specific space membership by id", httpMethod="GET", response=Response.class, notes="This returns the space membership in the following cases: <br/><ul><li>the user of the space membership is the authenticated user</li><li>the authenticated user is a manager of the space</li><li>the authenticated user is a spaces super manager</li></ul>")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=404, message="Resource not found"), @ApiResponse(code=500, message="Internal server error due to data encoding")})
    public Response getSpaceMembershipById(@Context UriInfo uriInfo, @ApiParam(value="Space membership id which is in format spaceName:userName:role, ex: my_space:root:manager", required=true) @PathParam(value="id") String id, @ApiParam(value="Asking for a full representation of a specific subresource if any", required=false) @QueryParam(value="expand") String expand) throws Exception {
        String[] idParams = RestUtils.getPathParam(uriInfo, "id").split(":");
        if (idParams.length != 3) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        if (this.identityManager.getOrCreateIdentity("organization", idParams[1], true) == null) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        String spaceGroupId = SPACE_PREFIX + idParams[0];
        Space space = this.spaceService.getSpaceByGroupId(spaceGroupId);
        if (space == null) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        String authenticatedUser = ConversationState.getCurrent().getIdentity().getUserId();
        if (!(authenticatedUser.equals(idParams[1]) || this.spaceService.isSuperManager(authenticatedUser) || this.spaceService.isManager(space, authenticatedUser))) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        SpaceMembershipEntity membershipEntity = EntityBuilder.buildEntityFromSpaceMembership(space, idParams[1], idParams[2], uriInfo.getPath(), expand);
        return EntityBuilder.getResponse(membershipEntity, uriInfo, RestUtils.getJsonMediaType(), Response.Status.OK);
    }

    @Override
    @PUT
    @Path(value="{id}")
    @RolesAllowed(value={"users"})
    @ApiOperation(value="Updates a specific space membership by id", httpMethod="PUT", response=Response.class, notes="This updates the space membership in the following cases: <br/><ul><li>the user of the space membership is the authenticated user but he cannot update his own membership to \"approved\" for a space with a \"validation\" subscription</li><li>the authenticated user is a manager of the space</li><li>the authenticated user is a spaces super manager</li><li>the user of the space membership is the authenticated user, he can update his own membership to \"approved\" or \"ignored\" for a space with a \"closed\" subscription</li></ul>")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=500, message="Internal server error due to data encoding")})
    public Response updateSpaceMembershipById(@Context UriInfo uriInfo, @ApiParam(value="Space membership id which is in format spaceName:userName:role, ex: my_space:root:manager", required=true) @PathParam(value="id") String id, @ApiParam(value="Asking for a full representation of a specific subresource if any", required=false) @QueryParam(value="expand") String expand, @ApiParam(value="Space membership object to be updated", required=true) SpaceMembershipEntity model) throws Exception {
        String role;
        String[] idParams = RestUtils.getPathParam(uriInfo, "id").split(":");
        if (idParams.length != 3) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        String targetUser = idParams[1];
        if (this.identityManager.getOrCreateIdentity("organization", targetUser, true) == null) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        String spacePrettyName = idParams[0];
        Space space = this.spaceService.getSpaceByPrettyName(spacePrettyName);
        if (space == null) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        String authenticatedUser = ConversationState.getCurrent().getIdentity().getUserId();
        if (model.getRole() != null) {
            if (!this.spaceService.isSuperManager(authenticatedUser) && !this.spaceService.isManager(space, authenticatedUser)) {
                throw new WebApplicationException(Response.Status.UNAUTHORIZED);
            }
            space.setEditor(authenticatedUser);
            if (model.getRole().equalsIgnoreCase("manager") && !this.spaceService.isManager(space, targetUser)) {
                this.spaceService.setManager(space, targetUser, true);
            }
            if (model.getRole().equalsIgnoreCase("member") && this.spaceService.isManager(space, targetUser)) {
                this.spaceService.setManager(space, targetUser, false);
            }
        }
        if ((role = idParams[2]).equalsIgnoreCase(MembershipType.INVITED.name())) {
            RestChecker.checkAuthenticatedUserPermission(targetUser);
            if (!this.spaceService.isInvitedUser(space, targetUser)) {
                throw new WebApplicationException(Response.Status.FORBIDDEN);
            }
            if (model.getStatus() != null) {
                if (model.getStatus().equalsIgnoreCase(MembershipType.APPROVED.name())) {
                    this.spaceService.addMember(space, targetUser);
                    role = MembershipType.APPROVED.name();
                    LogUtils.logInfo("spaceMembership", "approve-space-invitation", "space_name:" + spacePrettyName + ",receiver:" + targetUser, this.getClass());
                } else if (model.getStatus().equalsIgnoreCase(MembershipType.IGNORED.name())) {
                    this.spaceService.removeInvitedUser(space, targetUser);
                    role = MembershipType.IGNORED.name();
                    LogUtils.logInfo("spaceMembership", "ignore-space-invitation", "space_name:" + spacePrettyName + ",receiver:" + targetUser, this.getClass());
                }
            }
        }
        SpaceMembershipEntity membershipEntity = EntityBuilder.buildEntityFromSpaceMembership(space, targetUser, role, uriInfo.getPath(), expand);
        return EntityBuilder.getResponse(membershipEntity, uriInfo, RestUtils.getJsonMediaType(), Response.Status.OK);
    }

    @Override
    @DELETE
    @Path(value="{id}")
    @RolesAllowed(value={"users"})
    @ApiOperation(value="Deletes a specific space membership by id", httpMethod="DELETE", response=Response.class, notes="This deletes the space membership in the following cases: <br/><ul><li>the user of the space membership is the authenticated user</li><li>the authenticated user is a manager of the space</li><li>the authenticated user is a spaces super manager</li></ul>")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=404, message="Resource not found"), @ApiResponse(code=412, message="Precondition is not acceptable. For instance, the last manager membership could not be removed."), @ApiResponse(code=500, message="Internal server error due to data encoding")})
    public Response deleteSpaceMembershipById(@Context UriInfo uriInfo, @ApiParam(value="Space membership id which is in format spaceName:userName:role, ex: my_space:root:manager", required=true) @PathParam(value="id") String id, @ApiParam(value="Asking for a full representation of a specific subresource if any", required=false) @QueryParam(value="expand") String expand) throws Exception {
        String[] idParams = RestUtils.getPathParam(uriInfo, "id").split(":");
        if (idParams.length != 3) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        String targetUser = idParams[1];
        if (this.identityManager.getOrCreateIdentity("organization", targetUser, true) == null) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        String spacePrettyName = idParams[0];
        Space space = this.spaceService.getSpaceByPrettyName(spacePrettyName);
        if (space == null) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        String authenticatedUser = ConversationState.getCurrent().getIdentity().getUserId();
        if (!(authenticatedUser.equals(targetUser) || this.spaceService.isSuperManager(authenticatedUser) || this.spaceService.isManager(space, authenticatedUser))) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        if (this.spaceService.isOnlyManager(space, targetUser)) {
            throw new WebApplicationException(Response.Status.PRECONDITION_FAILED);
        }
        String role = idParams[2];
        space.setEditor(authenticatedUser);
        if (role != null && role.equals("manager")) {
            this.spaceService.setManager(space, targetUser, false);
        }
        if (role != null && role.equals("member")) {
            if (this.spaceService.isManager(space, targetUser)) {
                this.spaceService.setManager(space, targetUser, false);
            }
            this.spaceService.removeMember(space, targetUser);
        }
        SpaceMembershipEntity membershipEntity = EntityBuilder.buildEntityFromSpaceMembership(space, targetUser, role, uriInfo.getPath(), expand);
        return EntityBuilder.getResponse(membershipEntity, uriInfo, RestUtils.getJsonMediaType(), Response.Status.OK);
    }

    private List<DataEntity> getSpaceMemberships(List<Space> spaces, String userId, String path, String expand) {
        ArrayList<DataEntity> spaceMemberships = new ArrayList<DataEntity>();
        SpaceMembershipEntity membershipEntity = null;
        for (Space space : spaces) {
            if (userId != null) {
                if (ArrayUtils.contains((Object[])space.getMembers(), (Object)userId)) {
                    membershipEntity = EntityBuilder.buildEntityFromSpaceMembership(space, userId, "member", path, expand);
                    spaceMemberships.add(membershipEntity.getDataEntity());
                }
                if (ArrayUtils.contains((Object[])space.getManagers(), (Object)userId)) {
                    membershipEntity = EntityBuilder.buildEntityFromSpaceMembership(space, userId, "manager", path, expand);
                    spaceMemberships.add(membershipEntity.getDataEntity());
                }
                if (ArrayUtils.contains((Object[])space.getInvitedUsers(), (Object)userId)) {
                    membershipEntity = EntityBuilder.buildEntityFromSpaceMembership(space, userId, "invited", path, expand);
                    spaceMemberships.add(membershipEntity.getDataEntity());
                }
                if (!ArrayUtils.contains((Object[])space.getPendingUsers(), (Object)userId)) continue;
                membershipEntity = EntityBuilder.buildEntityFromSpaceMembership(space, userId, "pending", path, expand);
                spaceMemberships.add(membershipEntity.getDataEntity());
                continue;
            }
            for (String user : space.getMembers()) {
                membershipEntity = EntityBuilder.buildEntityFromSpaceMembership(space, user, "member", path, expand);
                spaceMemberships.add(membershipEntity.getDataEntity());
            }
            for (String user : space.getManagers()) {
                membershipEntity = EntityBuilder.buildEntityFromSpaceMembership(space, user, "manager", path, expand);
                spaceMemberships.add(membershipEntity.getDataEntity());
            }
        }
        return spaceMemberships;
    }

    private static enum MembershipType {
        ALL,
        PENDING,
        APPROVED,
        IGNORED,
        INVITED;

    }
}

