/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.space;

import com.ibm.icu.text.Transliterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.regex.Pattern;
import javax.portlet.RenderRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.application.registry.ApplicationCategory;
import org.exoplatform.application.registry.ApplicationRegistryService;
import org.exoplatform.commons.utils.ExpressionUtil;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.application.RequestNavigationData;
import org.exoplatform.portal.config.DataStorage;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.portal.config.UserPortalConfig;
import org.exoplatform.portal.config.UserPortalConfigService;
import org.exoplatform.portal.config.model.Application;
import org.exoplatform.portal.config.model.ApplicationState;
import org.exoplatform.portal.config.model.ApplicationType;
import org.exoplatform.portal.config.model.Container;
import org.exoplatform.portal.config.model.ModelObject;
import org.exoplatform.portal.config.model.Page;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.portal.mop.SiteType;
import org.exoplatform.portal.mop.State;
import org.exoplatform.portal.mop.Visibility;
import org.exoplatform.portal.mop.description.DescriptionService;
import org.exoplatform.portal.mop.navigation.GenericScope;
import org.exoplatform.portal.mop.navigation.NavigationContext;
import org.exoplatform.portal.mop.navigation.NavigationService;
import org.exoplatform.portal.mop.navigation.NavigationServiceException;
import org.exoplatform.portal.mop.navigation.NavigationState;
import org.exoplatform.portal.mop.navigation.NodeContext;
import org.exoplatform.portal.mop.navigation.NodeModel;
import org.exoplatform.portal.mop.navigation.Scope;
import org.exoplatform.portal.mop.page.PageContext;
import org.exoplatform.portal.mop.page.PageKey;
import org.exoplatform.portal.mop.page.PageService;
import org.exoplatform.portal.mop.user.UserNavigation;
import org.exoplatform.portal.mop.user.UserNode;
import org.exoplatform.portal.mop.user.UserNodeFilterConfig;
import org.exoplatform.portal.mop.user.UserPortal;
import org.exoplatform.portal.mop.user.UserPortalContext;
import org.exoplatform.portal.webui.portal.UIPortal;
import org.exoplatform.portal.webui.util.NavigationURLUtils;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.portal.webui.workspace.UIPortalApplication;
import org.exoplatform.portal.webui.workspace.UIWorkingWorkspace;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.GroupHandler;
import org.exoplatform.services.organization.Membership;
import org.exoplatform.services.organization.MembershipHandler;
import org.exoplatform.services.organization.MembershipType;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserHandler;
import org.exoplatform.services.organization.UserStatus;
import org.exoplatform.services.resources.ResourceBundleService;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.social.common.router.ExoRouter;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.SpaceException;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.web.application.RequestContext;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.core.UIComponent;
import org.gatein.common.i18n.LocalizedString;
import org.gatein.common.util.Tools;
import org.gatein.pc.api.Portlet;
import org.gatein.pc.api.PortletInvoker;
import org.gatein.pc.api.info.PortletInfo;

public class SpaceUtils {
    private static final Log LOG = ExoLogger.getLogger(SpaceUtils.class);
    public static final String SPACE_GROUP = "/spaces";
    public static final String PLATFORM_USERS_GROUP = "/platform/users";
    @Deprecated
    public static final String MANAGER = "manager";
    public static final String MEMBER = "member";
    public static final String REDACTOR = "redactor";
    public static final String MENU_CONTAINER = "Menu";
    public static final String APPLICATION_CONTAINER = "Application";
    public static final String SPACE_URL = "SPACE_URL";
    public static final String SPACE_SETTINGS_PAGE = "settings";
    private static final String SPACE_MENU = "SpaceMenu";
    private static final String SPACE_APPLICATIONS = "SpaceApplications";
    private static final ConcurrentHashMap<String, org.exoplatform.application.registry.Application> appListCache = new ConcurrentHashMap();
    private static final String REMOTE_CATEGORY_NAME = "remote";
    private static final Pattern SPACE_NAME_PATTERN = Pattern.compile("^([\\p{L}\\s\\d'_&/-]+[\\s]?)+$");
    private static final String PORTAL_PAGE_TITLE = "portal:requestTitle";
    private static final Transliterator ACCENTS_CONVERTER = Transliterator.getInstance((String)"Latin; NFD; [:Nonspacing Mark:] Remove; NFC;");
    private static String NUMBER_REG_PATTERN = "[0-9]";
    private static String UNDER_SCORE_STR = "_";
    private static String SPACE_STR = " ";
    private static String CURRENT_SPACE = "CurrentSpace";

    public static boolean isValidSpaceName(String name) {
        return SPACE_NAME_PATTERN.matcher(name).matches();
    }

    public static Group createGroupFromExistingGroup(Group parentGroup, Group existingGroup, String name) throws Exception {
        OrganizationService orgSrc = SpaceUtils.getOrganizationService();
        GroupHandler groupHandler = orgSrc.getGroupHandler();
        MembershipHandler memberShipHandler = orgSrc.getMembershipHandler();
        Group newGroup = groupHandler.createGroupInstance();
        newGroup.setGroupName(name);
        newGroup.setLabel(name);
        newGroup.setDescription(existingGroup.getDescription());
        groupHandler.addChild(parentGroup, newGroup, true);
        Collection memberShips = memberShipHandler.findMembershipsByGroup(existingGroup);
        for (Membership membership : memberShips) {
            User user = orgSrc.getUserHandler().findUserByName(membership.getUserName());
            MembershipType memberShipType = orgSrc.getMembershipTypeHandler().findMembershipType(membership.getMembershipType());
            memberShipHandler.linkMembership(user, newGroup, memberShipType, true);
        }
        return newGroup;
    }

    public static List<org.exoplatform.application.registry.Application> getApplications(String groupId) throws Exception {
        CopyOnWriteArrayList<org.exoplatform.application.registry.Application> list = new CopyOnWriteArrayList<org.exoplatform.application.registry.Application>();
        ApplicationRegistryService appRegistrySrc = SpaceUtils.getApplicationRegistryService();
        List listCategory = appRegistrySrc.getApplicationCategories();
        Iterator cateItr = listCategory.iterator();
        while (cateItr.hasNext()) {
            ApplicationCategory cate = (ApplicationCategory)cateItr.next();
            if (!SpaceUtils.hasAccessPermission(cate, groupId)) {
                cateItr.remove();
                continue;
            }
            ApplicationType portletType = ApplicationType.PORTLET;
            List applications = appRegistrySrc.getApplications(cate, new ApplicationType[]{portletType});
            Iterator appIterator = applications.iterator();
            while (appIterator.hasNext()) {
                org.exoplatform.application.registry.Application app = (org.exoplatform.application.registry.Application)appIterator.next();
                if (!SpaceUtils.hasAccessPermission(app, groupId)) {
                    appIterator.remove();
                    continue;
                }
                list.add(app);
            }
        }
        return list;
    }

    public static Map<ApplicationCategory, List<org.exoplatform.application.registry.Application>> getAppStore(Space space) throws Exception {
        LinkedHashMap<ApplicationCategory, List<org.exoplatform.application.registry.Application>> appStore = new LinkedHashMap<ApplicationCategory, List<org.exoplatform.application.registry.Application>>();
        ApplicationRegistryService appRegistryService = SpaceUtils.getApplicationRegistryService();
        String groupId = space.getGroupId();
        List categoryList = appRegistryService.getApplicationCategories();
        Collections.sort(categoryList, new PortletCategoryComparator());
        for (ApplicationCategory appCategory : categoryList) {
            if (!SpaceUtils.hasAccessPermission(appCategory, groupId)) continue;
            ArrayList<org.exoplatform.application.registry.Application> tempAppList = new ArrayList<org.exoplatform.application.registry.Application>();
            List appList = appCategory.getApplications();
            Collections.sort(appList, new PortletComparator());
            for (org.exoplatform.application.registry.Application application : appList) {
                if (!SpaceUtils.hasAccessPermission(application, groupId)) continue;
                tempAppList.add(application);
            }
            if (tempAppList.size() <= 0) continue;
            appStore.put(appCategory, tempAppList);
        }
        return appStore;
    }

    public static org.exoplatform.application.registry.Application getAppFromPortalContainer(String appId) throws Exception {
        if (appListCache.containsKey(appId)) {
            return appListCache.get(appId);
        }
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        PortletInvoker portletInvoker = (PortletInvoker)container.getComponentInstance(PortletInvoker.class);
        Set portlets = portletInvoker.getPortlets();
        ApplicationRegistryService appRegistryService = SpaceUtils.getApplicationRegistryService();
        for (Portlet portlet : portlets) {
            org.exoplatform.application.registry.Application app;
            Object[] objectArray;
            int n;
            int n2;
            String keywords;
            PortletInfo info = portlet.getInfo();
            String portletApplicationName = info.getApplicationName();
            String portletName = info.getName();
            portletApplicationName = portletApplicationName.replace('/', '_');
            if (!(portletName = portletName.replace('/', '_')).equals(appId)) continue;
            LocalizedString keywordsLS = info.getMeta().getMetaValue("keywords");
            Object[] categoryNames = null;
            if (keywordsLS != null && (keywords = keywordsLS.getDefaultString()) != null && keywords.length() != 0) {
                categoryNames = keywords.split(",");
            }
            if (categoryNames == null || categoryNames.length == 0) {
                categoryNames = new String[]{portletApplicationName};
            }
            if (portlet.isRemote()) {
                categoryNames = (String[])Tools.appendTo((Object[])categoryNames, (Object)REMOTE_CATEGORY_NAME);
            }
            if ((n2 = 0) >= (n = (objectArray = categoryNames).length)) continue;
            Object categoryName = objectArray[n2];
            ApplicationCategory category = appRegistryService.getApplicationCategory((String)(categoryName = ((String)categoryName).trim()));
            if (category == null) {
                category = new ApplicationCategory();
                category.setName((String)categoryName);
                category.setDisplayName((String)categoryName);
            }
            if ((app = appRegistryService.getApplication((String)categoryName + "/" + portletName)) != null) {
                return app;
            }
            LocalizedString descriptionLS = portlet.getInfo().getMeta().getMetaValue("description");
            LocalizedString displayNameLS = portlet.getInfo().getMeta().getMetaValue("display-name");
            app = new org.exoplatform.application.registry.Application();
            String contentId = portlet.isRemote() ? portlet.getContext().getId() : info.getApplicationName() + "/" + info.getName();
            app.setType(ApplicationType.PORTLET);
            app.setContentId(contentId);
            app.setApplicationName(portletName);
            app.setCategoryName((String)categoryName);
            app.setDisplayName(SpaceUtils.getLocalizedStringValue(displayNameLS, portletName));
            app.setDescription(SpaceUtils.getLocalizedStringValue(descriptionLS, portletName));
            org.exoplatform.application.registry.Application oldApp = appListCache.putIfAbsent(app.getApplicationName(), app);
            return oldApp == null ? app : oldApp;
        }
        return null;
    }

    public static String cleanString(String str) {
        if (str == null) {
            throw new IllegalArgumentException("String argument must not be null.");
        }
        str = ACCENTS_CONVERTER.transliterate(str);
        StringBuilder cleanedStr = new StringBuilder(str.trim());
        for (int i = 0; i < cleanedStr.length(); ++i) {
            char c = cleanedStr.charAt(i);
            if (c == ' ') {
                if (i > 0 && cleanedStr.charAt(i - 1) == '_') {
                    cleanedStr.deleteCharAt(i--);
                    continue;
                }
                c = '_';
                cleanedStr.setCharAt(i, c);
                continue;
            }
            if (!Character.isLetterOrDigit(c) && c != '_') {
                cleanedStr.deleteCharAt(i--);
                continue;
            }
            if (i <= 0 || c != 95 || cleanedStr.charAt(i - 1) != '_') continue;
            cleanedStr.deleteCharAt(i--);
        }
        return cleanedStr.toString().toLowerCase();
    }

    public static String getSpaceUrl() {
        PortalRequestContext pcontext = Util.getPortalRequestContext();
        String requestPath = pcontext.getControllerContext().getParameter(RequestNavigationData.REQUEST_PATH);
        ExoRouter.Route route = ExoRouter.route((String)requestPath);
        if (route == null) {
            return null;
        }
        String spacePrettyName = (String)route.localArgs.get("spacePrettyName");
        SpaceService spaceService = (SpaceService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(SpaceService.class);
        Space space = spaceService.getSpaceByPrettyName(spacePrettyName);
        return space != null ? space.getUrl() : null;
    }

    public static boolean isSpaceContext() {
        return SpaceUtils.getSpaceByContext() != null;
    }

    public static String getSpaceUrlByContext() {
        Space space = SpaceUtils.getSpaceByContext();
        return space != null ? space.getUrl() : null;
    }

    public static Space getSpaceByContext() {
        PortalRequestContext pcontext = Util.getPortalRequestContext();
        Object currentSpaceObject = pcontext.getAttribute(CURRENT_SPACE);
        if (currentSpaceObject != null) {
            if (Objects.equals(currentSpaceObject, "")) {
                return null;
            }
            return (Space)currentSpaceObject;
        }
        if (!pcontext.getSiteType().equals((Object)SiteType.GROUP) || !pcontext.getSiteName().startsWith(SPACE_GROUP)) {
            return null;
        }
        SpaceService spaceService = (SpaceService)ExoContainerContext.getService(SpaceService.class);
        Space currentSpace = spaceService.getSpaceByGroupId(pcontext.getSiteName());
        pcontext.setAttribute(CURRENT_SPACE, (Object)currentSpace);
        return currentSpace;
    }

    public static void removePagesAndGroupNavigation(Space space) throws Exception {
        DataStorage dataStorage = SpaceUtils.getDataStorage();
        String groupId = space.getGroupId();
        NavigationContext spaceNavCtx = SpaceUtils.getGroupNavigationContext(groupId);
        if (spaceNavCtx == null) {
            return;
        }
        NodeContext<NodeContext<?>> homeNodeCtx = SpaceUtils.getHomeNodeWithChildren(spaceNavCtx, groupId);
        Iterator iterator = homeNodeCtx.getNodes().iterator();
        while (iterator.hasNext()) {
            NodeContext child;
            NodeContext childNode = child = (NodeContext)iterator.next();
            Page page = dataStorage.getPage(childNode.getState().getPageRef().format());
            dataStorage.remove(page);
        }
        SpaceUtils.removeGroupNavigation(groupId);
    }

    public static void changeSpaceUrlPreference(UserNode spacePageNode, Space space, String newSpaceName) throws Exception {
        Container applicationContainer;
        DataStorage dataStorage = SpaceUtils.getDataStorage();
        Page page = dataStorage.getPage(spacePageNode.getPageRef().format());
        ArrayList pageChildren = page.getChildren();
        Container menuContainer = SpaceUtils.findContainerById(pageChildren, MENU_CONTAINER);
        if (menuContainer == null) {
            menuContainer = SpaceUtils.findContainerById(pageChildren, SPACE_MENU);
        }
        if ((applicationContainer = SpaceUtils.findContainerById(pageChildren, APPLICATION_CONTAINER)) == null) {
            applicationContainer = SpaceUtils.findContainerById(pageChildren, SPACE_APPLICATIONS);
        }
    }

    public static void changeAppPageTitle(UserNode spacePageNode, String newSpaceName) throws Exception {
        String dispalyname;
        DataStorage dataStorage = SpaceUtils.getDataStorage();
        Page page = dataStorage.getPage(spacePageNode.getPageRef().format());
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        PageService pageService = (PageService)container.getComponentInstanceOfType(PageService.class);
        PageContext pageContext = pageService.loadPage(page.getPageKey());
        if (pageContext != null && pageContext.getState() != null && (dispalyname = pageContext.getState().getDisplayName()) != null && !dispalyname.isEmpty() && dispalyname.indexOf("-") != -1) {
            String newPageTitle = newSpaceName + " -" + dispalyname.split("-")[1];
            pageContext.setState(pageContext.getState().builder().displayName(newPageTitle).build());
            pageService.savePage(pageContext);
        }
    }

    public static void changeMenuPortletPreference(Container menuContainer, DataStorage dataStorage, Space space) {
        Application menuPortlet = (Application)menuContainer.getChildren().get(0);
        ApplicationState menuState = menuPortlet.getState();
        try {
            org.exoplatform.portal.pom.spi.portlet.Portlet menuPortletPreference = (org.exoplatform.portal.pom.spi.portlet.Portlet)dataStorage.load(menuState, ApplicationType.PORTLET);
            menuPortletPreference.setValue(SPACE_URL, space.getUrl());
            dataStorage.save(menuState, (Object)menuPortletPreference);
        }
        catch (Exception e) {
            LOG.warn((Object)"Can not save menu portlet preference!", (Throwable)e);
        }
    }

    public static void changeAppPortletPreference(Container applicationContainer, DataStorage dataStorage, Space space) {
        try {
            Application applicationPortlet = (Application)applicationContainer.getChildren().get(0);
            ApplicationState appState = applicationPortlet.getState();
            try {
                org.exoplatform.portal.pom.spi.portlet.Portlet appPortletPreference = (org.exoplatform.portal.pom.spi.portlet.Portlet)dataStorage.load(appState, ApplicationType.PORTLET);
                if (appPortletPreference == null || appPortletPreference.getPreference(SPACE_URL) == null) {
                    return;
                }
                appPortletPreference.setValue(SPACE_URL, space.getUrl());
                dataStorage.save(appState, (Object)appPortletPreference);
            }
            catch (Exception e) {
                LOG.warn((Object)"Can not save application portlet preference!", (Throwable)e);
            }
        }
        catch (Exception e) {
            LOG.warn((Object)"Error when change application porltet preference!", (Throwable)e);
        }
    }

    public static void restartRequest() {
        RequestLifeCycle.end();
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        RequestLifeCycle.begin((ExoContainer)container);
    }

    public static Container findContainerById(ArrayList<ModelObject> children, String id) {
        Container found = null;
        for (ModelObject obj : children) {
            if (Application.class.isInstance(obj)) continue;
            Container child = (Container)obj;
            if (child.getId() == null) {
                found = SpaceUtils.findContainerById(child.getChildren(), id);
                if (found == null) continue;
                return found;
            }
            if (child.getId().equals(id)) {
                return child;
            }
            found = SpaceUtils.findContainerById(child.getChildren(), id);
            if (found == null) continue;
            return found;
        }
        return found;
    }

    public static void setNavigation(UserNavigation nav) {
        if (nav == null) {
            return;
        }
        WebuiRequestContext context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        if (context == null) {
            return;
        }
        try {
            UserNode selectedNav = Util.getUIPortal().getSelectedUserNode();
            if (selectedNav.getId() == nav.getKey().getName()) {
                Util.getUIPortal().setNavPath(selectedNav);
            }
        }
        catch (Exception e) {
            LOG.warn((Object)e.getMessage(), (Throwable)e);
        }
    }

    public static void removeNavigation(UserNavigation nav) throws Exception {
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        NavigationService navService = (NavigationService)container.getComponentInstanceOfType(NavigationService.class);
        try {
            navService.destroyNavigation(new NavigationContext(nav.getKey(), new NavigationState(Integer.valueOf(1))));
        }
        catch (NavigationServiceException nex) {
            LOG.warn((Object)"Failed to remove navigations", (Throwable)nex);
        }
        catch (Exception e) {
            LOG.warn((Object)"Failed to remove navigations", (Throwable)e);
        }
    }

    public static void updateWorkingWorkSpace() {
        UIPortalApplication uiPortalApplication = Util.getUIPortalApplication();
        UIWorkingWorkspace uiWorkingWS = (UIWorkingWorkspace)uiPortalApplication.getChildById("UIWorkingWorkspace");
        PortalRequestContext pContext = Util.getPortalRequestContext();
        pContext.addUIComponentToUpdateByAjax((UIComponent)uiWorkingWS);
        pContext.setFullRender(true);
    }

    public static String createGroup(String spaceName, String creator) throws SpaceException {
        return SpaceUtils.createGroup(spaceName, spaceName, creator);
    }

    public static String createGroup(String groupLabel, String spaceName, String creator) throws SpaceException {
        String groupId;
        OrganizationService organizationService = SpaceUtils.getOrganizationService();
        GroupHandler groupHandler = organizationService.getGroupHandler();
        try {
            Group parentGroup = groupHandler.findGroupById(SPACE_GROUP);
            Group newGroup = groupHandler.createGroupInstance();
            String shortName = SpaceUtils.cleanString(spaceName);
            groupId = parentGroup.getId() + "/" + shortName;
            PortalContainer portalContainer = PortalContainer.getInstance();
            SpaceService spaceService = (SpaceService)portalContainer.getComponentInstanceOfType(SpaceService.class);
            if (spaceService.getSpaceByGroupId(groupId) != null) {
                shortName = SpaceUtils.buildGroupId(shortName, parentGroup.getId());
                groupId = parentGroup.getId() + "/" + shortName;
            }
            if (SpaceUtils.isSpaceNameExisted(spaceName)) {
                throw new SpaceException(SpaceException.Code.SPACE_ALREADY_EXIST);
            }
            newGroup.setGroupName(shortName);
            newGroup.setLabel(groupLabel);
            newGroup.setDescription("the " + parentGroup.getId() + "/" + shortName + " group");
            groupHandler.addChild(parentGroup, newGroup, true);
        }
        catch (Exception e) {
            if (e instanceof SpaceException) {
                throw (SpaceException)e;
            }
            throw new SpaceException(SpaceException.Code.UNABLE_TO_CREATE_GROUP, (Throwable)e);
        }
        try {
            SpaceUtils.addCreatorToGroup(creator, groupId);
        }
        catch (Exception e) {
            throw new SpaceException(SpaceException.Code.UNABLE_TO_ADD_CREATOR, (Throwable)e);
        }
        return groupId;
    }

    public static void removeGroup(Space space) throws SpaceException {
        try {
            OrganizationService organizationService = SpaceUtils.getOrganizationService();
            GroupHandler groupHandler = organizationService.getGroupHandler();
            Group group = groupHandler.findGroupById(space.getGroupId());
            groupHandler.removeGroup(group, true);
        }
        catch (Exception e) {
            throw new SpaceException(SpaceException.Code.UNABLE_TO_REMOVE_GROUP, (Throwable)e);
        }
    }

    public static void removeMembershipFromGroup(Space space) {
        if (space == null) {
            return;
        }
        if (space.getMembers() != null) {
            for (String userId : space.getMembers()) {
                SpaceUtils.removeUserFromGroupWithMemberMembership(userId, space.getGroupId());
            }
        }
        if (space.getManagers() != null) {
            for (String userId : space.getManagers()) {
                SpaceUtils.removeUserFromGroupWithManagerMembership(userId, space.getGroupId());
            }
        }
        if (space.getRedactors() != null) {
            for (String userId : space.getRedactors()) {
                SpaceUtils.removeUserFromGroupWithRedactorMembership(userId, space.getGroupId());
            }
        }
    }

    public static boolean isSpaceNameExisted(String spaceName) throws SpaceException {
        PortalContainer portalContainer = PortalContainer.getInstance();
        SpaceService spaceService = (SpaceService)portalContainer.getComponentInstanceOfType(SpaceService.class);
        return spaceService.getSpaceByPrettyName(SpaceUtils.cleanString(spaceName)) != null;
    }

    public static void addCreatorToGroup(String creator, String groupId) {
        SpaceUtils.addUserToGroupWithMemberMembership(creator, groupId);
        SpaceUtils.addUserToGroupWithManagerMembership(creator, groupId);
    }

    private static void addUserToGroupWithMembership(String remoteId, String groupId, String membership) {
        OrganizationService organizationService = SpaceUtils.getOrganizationService();
        try {
            MembershipHandler membershipHandler = organizationService.getMembershipHandler();
            Membership found = membershipHandler.findMembershipByUserGroupAndType(remoteId, groupId, membership);
            if (found == null && !"*".equalsIgnoreCase(membership)) {
                found = membershipHandler.findMembershipByUserGroupAndType(remoteId, groupId, "*");
            }
            if (found != null) {
                LOG.info((Object)("user: " + remoteId + " was already added to group: " + groupId + " with membership * or : " + membership));
                return;
            }
            User user = organizationService.getUserHandler().findUserByName(remoteId);
            MembershipType membershipType = organizationService.getMembershipTypeHandler().findMembershipType(membership);
            GroupHandler groupHandler = organizationService.getGroupHandler();
            Group existingGroup = groupHandler.findGroupById(groupId);
            membershipHandler.linkMembership(user, existingGroup, membershipType, true);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to add user: " + remoteId + " to group: " + groupId + " with membership: " + membership, e);
        }
    }

    public static void addUserToGroupWithMemberMembership(String remoteId, String groupId) {
        SpaceUtils.addUserToGroupWithMembership(remoteId, groupId, MEMBER);
    }

    public static void addUserToGroupWithRedactorMembership(String remoteId, String groupId) {
        SpaceUtils.addUserToGroupWithMembership(remoteId, groupId, REDACTOR);
    }

    public static void addUserToGroupWithManagerMembership(String remoteId, String groupId) {
        SpaceUtils.addUserToGroupWithMembership(remoteId, groupId, SpaceUtils.getUserACL().getAdminMSType());
    }

    private static void removeUserFromGroupWithMembership(String remoteId, String groupId, String membership) {
        try {
            OrganizationService organizationService = SpaceUtils.getOrganizationService();
            MembershipHandler memberShipHandler = organizationService.getMembershipHandler();
            if (MEMBER.equals(membership)) {
                Collection memberships = memberShipHandler.findMembershipsByUserAndGroup(remoteId, groupId);
                if (memberships.size() == 0) {
                    LOG.info((Object)("User: " + remoteId + " is not a member of group: " + groupId));
                    return;
                }
                for (Membership mbShip : memberships) {
                    memberShipHandler.removeMembership(mbShip.getId(), true);
                }
            } else {
                Membership memberShip = memberShipHandler.findMembershipByUserGroupAndType(remoteId, groupId, membership);
                Membership any = memberShipHandler.findMembershipByUserGroupAndType(remoteId, groupId, "*");
                if (any != null) {
                    memberShipHandler.removeMembership(any.getId(), true);
                }
                if (memberShip == null) {
                    LOG.info((Object)("User: " + remoteId + " is not a " + membership + " of group: " + groupId));
                    return;
                }
                UserHandler userHandler = organizationService.getUserHandler();
                User user = userHandler.findUserByName(remoteId);
                memberShipHandler.removeMembership(memberShip.getId(), true);
                MembershipType mbShipTypeMember = organizationService.getMembershipTypeHandler().findMembershipType(MEMBER);
                GroupHandler groupHandler = organizationService.getGroupHandler();
                memberShipHandler.linkMembership(user, groupHandler.findGroupById(groupId), mbShipTypeMember, true);
            }
        }
        catch (Exception e) {
            LOG.warn((Object)("Failed to remove user: " + remoteId + " to group: " + groupId + " with membership: " + membership), (Throwable)e);
        }
    }

    public static void removeUserFromGroupWithMemberMembership(String remoteId, String groupId) {
        SpaceUtils.removeUserFromGroupWithMembership(remoteId, groupId, MEMBER);
    }

    public static void removeUserFromGroupWithRedactorMembership(String remoteId, String groupId) {
        SpaceUtils.removeUserFromGroupWithMembership(remoteId, groupId, REDACTOR);
    }

    public static void removeUserFromGroupWithManagerMembership(String remoteId, String groupId) {
        SpaceUtils.removeUserFromGroupWithMembership(remoteId, groupId, SpaceUtils.getUserACL().getAdminMSType());
    }

    public static NavigationContext createGroupNavigation(String groupId) throws SpaceException {
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        NavigationService navService = (NavigationService)container.getComponentInstance(NavigationService.class);
        NavigationContext navContext = navService.loadNavigation(SiteKey.group((String)groupId));
        try {
            if (navContext == null) {
                navContext = new NavigationContext(SiteKey.group((String)groupId), new NavigationState(Integer.valueOf(1)));
                navService.saveNavigation(navContext);
            }
            return navContext;
        }
        catch (Exception e) {
            throw new SpaceException(SpaceException.Code.UNABLE_TO_CREAT_NAV, (Throwable)e);
        }
    }

    public static void refreshNavigation() {
        UserPortal userPortal = SpaceUtils.getUserPortal();
        if (userPortal != null) {
            userPortal.refresh();
        }
    }

    public static UserPortal getUserPortal() {
        try {
            PortalRequestContext prc = Util.getPortalRequestContext();
            return prc.getUserPortalConfig().getUserPortal();
        }
        catch (Exception e) {
            try {
                return SpaceUtils.getUserPortalForRest();
            }
            catch (Exception e1) {
                return null;
            }
        }
    }

    public static UserNode getParentNode() throws Exception {
        UIPortal uiPortal = Util.getUIPortal();
        UserPortal userPortal = SpaceUtils.getUserPortal();
        UserNode selectedNode = uiPortal.getSelectedUserNode();
        UserNode currParent = selectedNode.getParent();
        if (currParent != null) {
            try {
                userPortal.updateNode(currParent, Scope.CHILDREN, null);
            }
            catch (NavigationServiceException e) {
                currParent = null;
            }
        }
        return currParent;
    }

    public static UserPortal getUserPortalForRest() throws Exception {
        return SpaceUtils.getUserPortalConfig().getUserPortal();
    }

    public static UserPortalConfig getUserPortalConfig() throws Exception {
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        UserPortalConfigService userPortalConfigSer = (UserPortalConfigService)container.getComponentInstanceOfType(UserPortalConfigService.class);
        UserPortalContext NULL_CONTEXT = new UserPortalContext(){

            public ResourceBundle getBundle(UserNavigation navigation) {
                return null;
            }

            public Locale getUserLocale() {
                return Locale.ENGLISH;
            }
        };
        String remoteId = ConversationState.getCurrent().getIdentity().getUserId();
        UserPortalConfig userPortalCfg = userPortalConfigSer.getUserPortalConfig(userPortalConfigSer.getDefaultPortal(), remoteId, NULL_CONTEXT);
        return userPortalCfg;
    }

    public static void removeGroupNavigation(String groupId) throws SpaceException {
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        NavigationService navService = (NavigationService)container.getComponentInstanceOfType(NavigationService.class);
        try {
            NavigationContext nav = navService.loadNavigation(SiteKey.group((String)groupId));
            if (nav == null) {
                throw new Exception("spaceNav is null");
            }
            navService.destroyNavigation(nav);
        }
        catch (Exception e) {
            throw new SpaceException(SpaceException.Code.UNABLE_TO_REMOVE_NAV, (Throwable)e);
        }
    }

    public static NavigationContext getGroupNavigationContext(String groupId) throws Exception {
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        NavigationService navService = (NavigationService)container.getComponentInstance(NavigationService.class);
        return navService.loadNavigation(SiteKey.group((String)groupId));
    }

    public static UserNavigation getGroupNavigation(String groupId) throws Exception {
        UserPortal userPortal = SpaceUtils.getUserPortal();
        if (userPortal != null) {
            return SpaceUtils.getUserPortal().getNavigation(SiteKey.group((String)groupId));
        }
        return null;
    }

    public static UserNode getHomeNode(UserNavigation userNavigation, String spaceUrl) {
        return SpaceUtils.getUserPortal().resolvePath(userNavigation, null, spaceUrl);
    }

    public static UserNode getHomeNode(UserNavigation userNavigation) {
        return SpaceUtils.getUserPortal().getNode(userNavigation, Scope.SINGLE, null, null);
    }

    public static NodeContext<NodeContext<?>> getHomeNodeWithChildren(NavigationContext spaceNavCtx, String spaceUrl) {
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        NavigationService navService = (NavigationService)container.getComponentInstance(NavigationService.class);
        return SpaceUtils.loadNode(navService, spaceNavCtx, spaceUrl);
    }

    public static UserNode getHomeNodeWithChildren(UserNavigation userNavigation, String spaceUrl) {
        UserNode homeNode = SpaceUtils.getUserPortal().resolvePath(userNavigation, null, spaceUrl);
        SpaceUtils.getUserPortal().updateNode(homeNode, Scope.CHILDREN, null);
        return homeNode;
    }

    public static UserNode getSpaceUserNode(Space space) throws Exception {
        return SpaceUtils.getSpaceUserNode(space, null);
    }

    public static UserNode getSpaceUserNode(Space space, UserNodeFilterConfig filter) throws Exception {
        UserNode spaceUserNode;
        NavigationContext spaceNavCtx = SpaceUtils.getGroupNavigationContext(space.getGroupId());
        UserNavigation userNav = SpaceUtils.getUserPortal().getNavigation(spaceNavCtx.getKey());
        UserNode parentUserNode = SpaceUtils.getUserPortal().getNode(userNav, Scope.CHILDREN, filter, null);
        UserNode userNode = spaceUserNode = parentUserNode.getChildrenSize() > 0 ? parentUserNode.getChild(0) : null;
        if (spaceUserNode != null) {
            SpaceUtils.getUserPortal().updateNode(spaceUserNode, Scope.CHILDREN, null);
        } else {
            LOG.warn((Object)"Failed to get because of spaceUserNode is NULL");
        }
        return spaceUserNode;
    }

    public static List<UserNode> getSpaceUserNodeChildren(Space space) throws Exception {
        return new ArrayList<UserNode>(SpaceUtils.getSpaceUserNode(space).getChildren());
    }

    public static List<Space> getOrderedSpaces(List<Space> spaces) {
        Iterator<Space> itr = spaces.iterator();
        ArrayList<Space> orderedSpaces = new ArrayList<Space>();
        ArrayList<Space> middleSpaces = new ArrayList<Space>();
        ArrayList<Space> lowSpaces = new ArrayList<Space>();
        Space space = null;
        while (itr.hasNext()) {
            space = itr.next();
            String priority = space.getPriority();
            if (priority.equals("1")) {
                orderedSpaces.add(space);
                continue;
            }
            if (priority.equals("2")) {
                middleSpaces.add(space);
                continue;
            }
            if (!priority.equals("3")) continue;
            lowSpaces.add(space);
        }
        for (Space sp : middleSpaces) {
            orderedSpaces.add(sp);
        }
        for (Space sp : lowSpaces) {
            orderedSpaces.add(sp);
        }
        return orderedSpaces;
    }

    public static int countMembers(Space space) throws SpaceException {
        if (space.getMembers() != null) {
            return space.getMembers().length;
        }
        return 0;
    }

    public static String getAppStatus(Space space, String appId) {
        String installedApps = space.getApp();
        if (installedApps == null) {
            return null;
        }
        if (installedApps.contains(appId)) {
            String appStatusPattern = SpaceUtils.getAppStatusPattern(installedApps, appId);
            return appStatusPattern.split(":")[3];
        }
        return null;
    }

    public static String getAppNodeName(Space space, String appId) {
        String installedApps = space.getApp();
        if (installedApps == null) {
            return null;
        }
        if (installedApps.contains(appId)) {
            String appStatusPatern = SpaceUtils.getAppStatusPattern(installedApps, appId);
            return appStatusPatern.split(":")[1];
        }
        return null;
    }

    public static boolean isRemovableApp(Space space, String appId) {
        String appStatus;
        String[] spliter;
        String installedApps = space.getApp();
        return !installedApps.contains(appId) || !(spliter = (appStatus = SpaceUtils.getAppStatusPattern(installedApps, appId)).split(":"))[2].equals("false");
    }

    public static List<String> getAppIdList(Space space) {
        ArrayList<String> appIdList = new ArrayList<String>();
        String installedApps = space.getApp();
        if (installedApps != null) {
            if (installedApps.contains(",")) {
                String[] appStatuses;
                for (String appStatus : appStatuses = installedApps.split(",")) {
                    appIdList.add(appStatus.split(":")[0]);
                }
            } else {
                appIdList.add(installedApps.split(":")[0]);
            }
        }
        return appIdList;
    }

    public static String getAbsoluteUrl() throws SpaceException {
        PortalRequestContext portalRequestContext = Util.getPortalRequestContext();
        HttpServletRequest request = portalRequestContext.getRequest();
        String str = request.getRequestURL().toString();
        return str.substring(0, str.indexOf(portalRequestContext.getRequestContextPath()));
    }

    public static void checkUserExisting(String userName) throws SpaceException {
        OrganizationService orgService = SpaceUtils.getOrganizationService();
        User user = null;
        try {
            user = orgService.getUserHandler().findUserByName(userName);
        }
        catch (Exception e) {
            throw new SpaceException(SpaceException.Code.ERROR_RETRIEVING_USER, (Throwable)e);
        }
        if (user == null) {
            throw new SpaceException(SpaceException.Code.ERROR_RETRIEVING_USER);
        }
    }

    public static boolean isInstalledApp(Space space, String appId) {
        String installedApps = space.getApp();
        if (installedApps == null) {
            return false;
        }
        String[] apps = installedApps.split(",");
        for (int idx = 0; idx < apps.length; ++idx) {
            String[] appPart = apps[idx].split(":");
            if (!appPart[0].equals(appId) && (appPart.length <= 1 || !appPart[1].equals(appId))) continue;
            return true;
        }
        return false;
    }

    public static String getDisplayAppName(String appDisplayName) {
        int length = appDisplayName.length();
        if (appDisplayName.toLowerCase().endsWith("portlet")) {
            return appDisplayName.substring(0, length - 7).trim();
        }
        return appDisplayName;
    }

    private static String getAppStatusPattern(String installedApps, String appId) {
        if (installedApps == null) {
            return null;
        }
        if (installedApps.contains(appId)) {
            String[] apps;
            for (String app : apps = installedApps.split(",")) {
                if (!app.contains(appId)) continue;
                String[] splited = app.split(":");
                if (splited.length != 4) {
                    LOG.warn((Object)("appStatus is not in correct form of [appId:appNodeName:isRemovableString:status] : " + app));
                    return null;
                }
                return app;
            }
        }
        return null;
    }

    private static boolean hasAccessPermission(org.exoplatform.application.registry.Application app, String groupId) throws Exception {
        ArrayList permissions = app.getAccessPermissions();
        if (permissions == null) {
            return false;
        }
        for (String ele : permissions) {
            if (!SpaceUtils.hasViewPermission(ele, groupId)) continue;
            return true;
        }
        return false;
    }

    public static OrganizationService getOrganizationService() {
        PortalContainer portalContainer = PortalContainer.getInstance();
        return (OrganizationService)portalContainer.getComponentInstanceOfType(OrganizationService.class);
    }

    public static DataStorage getDataStorage() {
        PortalContainer portalContainer = PortalContainer.getInstance();
        return (DataStorage)portalContainer.getComponentInstanceOfType(DataStorage.class);
    }

    private static boolean hasAccessPermission(ApplicationCategory app, String groupId) throws Exception {
        List permissions = app.getAccessPermissions();
        if (permissions == null) {
            return false;
        }
        for (String ele : permissions) {
            if (!SpaceUtils.hasViewPermission(ele, groupId)) continue;
            return true;
        }
        return false;
    }

    private static boolean hasViewPermission(String expPerm, String groupId) throws Exception {
        if ("Everyone".equals(expPerm)) {
            return true;
        }
        String[] temp = expPerm.split(":");
        if (temp.length < 2) {
            return false;
        }
        String tempExp = temp[1].trim();
        return tempExp.equals(groupId) || tempExp.equals(PLATFORM_USERS_GROUP);
    }

    private static String getLocalizedStringValue(LocalizedString localizedString, String portletName) {
        if (localizedString == null || localizedString.getDefaultString() == null) {
            return portletName;
        }
        return localizedString.getDefaultString();
    }

    private static ApplicationRegistryService getApplicationRegistryService() {
        PortalContainer portalContainer = PortalContainer.getInstance();
        return (ApplicationRegistryService)portalContainer.getComponentInstanceOfType(ApplicationRegistryService.class);
    }

    public static String removeSpecialCharacterInSpaceFilter(String input) {
        String result = input.replaceAll("[^\\pL\\pM\\p{Nd}\\p{Nl}\\p{Pc}[\\p{InEnclosedAlphanumerics}&&\\p{So}]\\?\\*%0-9\\']", " ");
        result = result.replaceAll("\\s+", " ");
        return result.trim();
    }

    public static String processUnifiedSearchCondition(String input) {
        String[] tab;
        if (StringUtils.isEmpty((String)input)) {
            return input;
        }
        if (input.indexOf("~") < 0 || input.indexOf("\\~") > 0) {
            return input.trim();
        }
        StringBuilder builder = new StringBuilder();
        for (String s : tab = input.split(" ")) {
            if (s.isEmpty()) continue;
            if (s.indexOf("~") > -1) {
                String searchTerm = s.substring(0, s.lastIndexOf("~"));
                builder.append(searchTerm).append(" ");
                continue;
            }
            builder.append(s).append(" ");
        }
        return builder.toString().trim();
    }

    public static String buildGroupId(String prettyName, String parentGroupId) {
        String checkedGroupId = prettyName;
        String mainPatternGroupId = null;
        String numberPattern = NUMBER_REG_PATTERN;
        mainPatternGroupId = checkedGroupId.substring(checkedGroupId.lastIndexOf(UNDER_SCORE_STR) + 1).matches(numberPattern) ? checkedGroupId.substring(0, checkedGroupId.lastIndexOf(UNDER_SCORE_STR)) : checkedGroupId;
        boolean hasNext = true;
        int extendPattern = 0;
        while (hasNext) {
            IdentityManager idm;
            Identity identity;
            checkedGroupId = SpaceUtils.cleanString(mainPatternGroupId + SPACE_STR + ++extendPattern);
            ExoContainer container = ExoContainerContext.getCurrentContainer();
            SpaceService spaceService = (SpaceService)container.getComponentInstanceOfType(SpaceService.class);
            if (spaceService.getSpaceByGroupId(parentGroupId + "/" + checkedGroupId) != null || (identity = (idm = (IdentityManager)container.getComponentInstanceOfType(IdentityManager.class)).getOrCreateIdentity("space", checkedGroupId, true)) != null) continue;
            hasNext = false;
        }
        return checkedGroupId;
    }

    public static String buildPrettyName(Space space) {
        String checkedPrettyName = space.getPrettyName();
        String mainPatternPrettyName = null;
        String numberPattern = NUMBER_REG_PATTERN;
        mainPatternPrettyName = checkedPrettyName.substring(checkedPrettyName.lastIndexOf(UNDER_SCORE_STR) + 1).matches(numberPattern) ? checkedPrettyName.substring(0, checkedPrettyName.lastIndexOf(UNDER_SCORE_STR)) : checkedPrettyName;
        boolean hasNext = true;
        int extendPattern = 0;
        while (hasNext) {
            checkedPrettyName = SpaceUtils.cleanString(mainPatternPrettyName + SPACE_STR + ++extendPattern);
            ExoContainer container = ExoContainerContext.getCurrentContainer();
            IdentityManager idm = (IdentityManager)container.getComponentInstanceOfType(IdentityManager.class);
            Identity identity = idm.getOrCreateIdentity("space", checkedPrettyName, true);
            if (identity != null) continue;
            hasNext = false;
        }
        return checkedPrettyName;
    }

    public static UserACL getUserACL() {
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        return (UserACL)container.getComponentInstanceOfType(UserACL.class);
    }

    public static boolean isUserHasMembershipTypesInGroup(String remoteId, String groupId, String membershipType) {
        if (remoteId == null || groupId == null || membershipType == null) {
            return false;
        }
        ConversationState conversationState = ConversationState.getCurrent();
        if (conversationState != null && conversationState.getIdentity() != null && remoteId.equals(conversationState.getIdentity().getUserId())) {
            UserACL.Permission permission = new UserACL.Permission();
            permission.setGroupId(groupId);
            permission.setMembership(membershipType);
            return SpaceUtils.getUserACL().hasPermission(conversationState.getIdentity(), permission.getValue());
        }
        try {
            Collection membershipsList = SpaceUtils.getOrganizationService().getMembershipHandler().findMembershipsByUserAndGroup(remoteId, groupId);
            for (Membership membership : membershipsList) {
                if (!membershipType.equals(membership.getMembershipType())) continue;
                return true;
            }
        }
        catch (Exception e) {
            return false;
        }
        return false;
    }

    public static List<String> findMembershipUsersByGroupAndTypes(String groupId, String ... membershipTypes) {
        if (groupId == null || membershipTypes == null) {
            return Collections.emptyList();
        }
        HashSet<String> userNames = new HashSet<String>();
        try {
            Group group = SpaceUtils.getOrganizationService().getGroupHandler().findGroupById(groupId);
            ListAccess membershipsListAccess = SpaceUtils.getOrganizationService().getMembershipHandler().findAllMembershipsByGroup(group);
            Membership[] memberships = (Membership[])membershipsListAccess.load(0, membershipsListAccess.getSize());
            List<String> types = Arrays.asList(membershipTypes);
            for (Membership membership : memberships) {
                if (!types.contains(membership.getMembershipType())) continue;
                String userName = membership.getUserName();
                User user = SpaceUtils.getOrganizationService().getUserHandler().findUserByName(userName, UserStatus.ENABLED);
                if (user == null) continue;
                userNames.add(userName);
            }
        }
        catch (Exception e) {
            LOG.warn((Object)("Failed to get space members, groupId = " + groupId + " and roles = " + String.join((CharSequence)",", membershipTypes)), (Throwable)e);
            return new ArrayList<String>();
        }
        return new ArrayList<String>(userNames);
    }

    public static boolean isRedactor(String userName, String spaceGroupId) throws Exception {
        String REDACTOR_MEMBERSHIP_NAME = REDACTOR;
        List membershipTypes = SpaceUtils.getOrganizationService().getMembershipHandler().findMembershipTypesByGroup(spaceGroupId);
        for (MembershipType membershipType : membershipTypes) {
            if (!REDACTOR_MEMBERSHIP_NAME.equals(membershipType.getName())) continue;
            return SpaceUtils.getOrganizationService().getMembershipHandler().findMembershipByUserGroupAndType(userName, spaceGroupId, REDACTOR_MEMBERSHIP_NAME) != null;
        }
        return true;
    }

    public static NodeContext<NodeContext<?>> loadNode(NavigationService navigationService, NavigationContext navigation, String navUri) {
        if (navigation == null) {
            return null;
        }
        if (navUri != null) {
            String name;
            String[] path = SpaceUtils.trim(navUri.split("/"));
            NodeContext node = navigationService.loadNode(NodeModel.SELF_MODEL, navigation, GenericScope.branchShape((String[])path, (Scope)Scope.ALL), null);
            String[] stringArray = path;
            int n = stringArray.length;
            for (int i = 0; i < n && (node = node.get(name = stringArray[i])) != null; ++i) {
            }
            return node;
        }
        return navigationService.loadNode(NodeModel.SELF_MODEL, navigation, Scope.ALL, null);
    }

    public static List<UserNode> getSpaceNavigations(Space space, Locale locale, String currentuser) {
        ArrayList<UserNode> navigations = new ArrayList<UserNode>();
        try {
            UserNodeFilterConfig.Builder filterConfigBuilder = UserNodeFilterConfig.builder();
            filterConfigBuilder.withVisibility(Visibility.DISPLAYED, new Visibility[]{Visibility.TEMPORAL});
            filterConfigBuilder.withTemporalCheck();
            UserNodeFilterConfig filter = filterConfigBuilder.build();
            UserNode parentNavigation = SpaceUtils.getSpaceUserNode(space, filter);
            UserNode settingNavigation = parentNavigation.getChild(SPACE_SETTINGS_PAGE);
            if (!SpaceUtils.hasSettingPermission(space, currentuser) && settingNavigation != null) {
                parentNavigation.removeChild(settingNavigation.getName());
            }
            navigations.add(parentNavigation);
            navigations.addAll(parentNavigation.getChildren());
            SpaceUtils.filterUnreachablePages(navigations);
            SpaceUtils.computeNavigationLabels(navigations, locale);
            SpaceUtils.computeNavigationIcons(navigations);
        }
        catch (Exception e) {
            LOG.warn((Object)"Get UserNode of Space failed.");
        }
        return navigations;
    }

    public static String getUri(UserNode userNode) {
        String uri = userNode.getURI();
        if (!uri.startsWith("/" + PortalContainer.getCurrentPortalContainerName())) {
            uri = NavigationURLUtils.getURL((UserNode)userNode);
        }
        return uri;
    }

    public static void computeNavigationLabels(List<UserNode> navigations, Locale locale) {
        ResourceBundle resourceBundle = SpaceUtils.getSharedResourceBundle(locale);
        for (UserNode node : navigations) {
            if (node == null) continue;
            String nodeTitle = SpaceUtils.getResolvedAppLabel(node, resourceBundle, locale);
            node.setLabel(null);
            node.setResolvedLabel(nodeTitle);
        }
    }

    public static void computeNavigationIcons(List<UserNode> navigations) {
        for (UserNode node : navigations) {
            if (node == null) continue;
            String nodeIcon = SpaceUtils.getIconClass(node);
            node.setIcon(nodeIcon);
        }
    }

    public static boolean hasSettingPermission(Space space, String username) {
        return SpaceUtils.getSpaceService().hasSettingPermission(space, username);
    }

    public static String getIconClass(UserNode node) {
        if (node == null) {
            return null;
        }
        if (SpaceUtils.isHomeNavigation(node)) {
            return "uiIconAppSpaceHomePage uiIconDefaultApp";
        }
        String appName = node.getPageRef().getName();
        return "uiIconApp" + node.getName() + " uiIconApp" + appName + " uiIconDefaultApp";
    }

    public static boolean isHomeNavigation(UserNode node) {
        return node.getParent() == null || StringUtils.equals((String)node.getParent().getName(), (String)"default") || node.getParent().getParent() == null;
    }

    public static String getResolvedAppLabel(UserNode userNode, ResourceBundle resourceBundle, Locale locale) {
        DescriptionService descriptionService;
        State description;
        if (userNode == null) {
            return null;
        }
        if (SpaceUtils.isHomeNavigation(userNode)) {
            return resourceBundle.getString("UISpaceMenu.label.SpaceHomePage");
        }
        String id = userNode.getId();
        String nodeLabel = userNode.getLabel();
        if (nodeLabel != null) {
            return ExpressionUtil.getExpressionValue((ResourceBundle)resourceBundle, (String)nodeLabel);
        }
        if (id != null && (description = (descriptionService = SpaceUtils.getUserPortalConfigService().getDescriptionService()).resolveDescription(id, locale)) != null && !StringUtils.equals((String)description.getName(), (String)userNode.getName())) {
            return description.getName();
        }
        String labelKey = userNode.getPageRef().getName() + ".label.name";
        if (resourceBundle.containsKey(labelKey)) {
            return resourceBundle.getString(labelKey);
        }
        return userNode.getName();
    }

    public static void filterUnreachablePages(List<UserNode> nodes) {
        ArrayList<UserNode> nonePageNodes = new ArrayList<UserNode>();
        UserACL userACL = SpaceUtils.getUserACL();
        for (UserNode node : nodes) {
            PageKey currentPage = node.getPageRef();
            if (currentPage == null) {
                nonePageNodes.add(node);
                continue;
            }
            PageContext currentPageContext = SpaceUtils.getPageService().loadPage(currentPage);
            if (currentPageContext != null && userACL.hasPermission(currentPageContext)) continue;
            nonePageNodes.add(node);
        }
        nodes.removeAll(nonePageNodes);
    }

    public static void setPageTitle(List<UserNode> navigations, RenderRequest request, Space space, Locale locale) throws Exception {
        UserNode selectedUserNode = Util.getUIPortal().getSelectedUserNode();
        String selectedUserNodeId = selectedUserNode.getId();
        String selectedUserNodeLabel = navigations.stream().filter(node -> StringUtils.equals((String)node.getId(), (String)selectedUserNodeId)).map(UserNode::getResolvedLabel).findFirst().orElse(null);
        if (selectedUserNodeLabel == null) {
            ResourceBundle resourceBundle = SpaceUtils.getSharedResourceBundle(locale);
            selectedUserNodeLabel = SpaceUtils.getResolvedAppLabel(selectedUserNode, resourceBundle, locale);
        }
        ((PortalRequestContext)RequestContext.getCurrentInstance()).getRequest().setAttribute(PORTAL_PAGE_TITLE, (Object)(space.getDisplayName() + " - " + selectedUserNodeLabel));
    }

    public static UserPortalConfigService getUserPortalConfigService() {
        return (UserPortalConfigService)ExoContainerContext.getService(UserPortalConfigService.class);
    }

    public static PageService getPageService() {
        return (PageService)ExoContainerContext.getService(PageService.class);
    }

    public static SpaceService getSpaceService() {
        return (SpaceService)ExoContainerContext.getService(SpaceService.class);
    }

    public static ResourceBundle getSharedResourceBundle(Locale locale) {
        return SpaceUtils.getResourceBundleService().getResourceBundle(SpaceUtils.getSharedResources(), locale);
    }

    public static ResourceBundleService getResourceBundleService() {
        return (ResourceBundleService)ExoContainerContext.getService(ResourceBundleService.class);
    }

    public static String[] getSharedResources() {
        return SpaceUtils.getResourceBundleService().getSharedResourceBundleNames();
    }

    private static String[] trim(String[] array) {
        ArrayList<String> trimmed = new ArrayList<String>(array.length);
        for (String s : array) {
            if (s == null || "".equals(s)) continue;
            trimmed.add(s);
        }
        return trimmed.toArray(new String[trimmed.size()]);
    }

    static class PortletComparator
    implements Comparator<org.exoplatform.application.registry.Application> {
        PortletComparator() {
        }

        @Override
        public int compare(org.exoplatform.application.registry.Application p1, org.exoplatform.application.registry.Application p2) {
            return p1.getDisplayName().compareTo(p2.getDisplayName());
        }
    }

    static class PortletCategoryComparator
    implements Comparator<ApplicationCategory> {
        PortletCategoryComparator() {
        }

        @Override
        public int compare(ApplicationCategory cat1, ApplicationCategory cat2) {
            return cat1.getDisplayName(true).compareTo(cat2.getDisplayName(true));
        }
    }
}

