/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.event.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.exoplatform.commons.api.event.EventManager;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.listener.Asynchronous;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.naming.InitialContextInitializer;

public class EventManagerImpl<S, D>
extends ListenerService
implements EventManager<S, D> {
    private Map<String, List<Listener<S, D>>> listenerMap = new HashMap<String, List<Listener<S, D>>>();
    private static final Log LOG = ExoLogger.getLogger(EventManagerImpl.class);

    public EventManagerImpl(ExoContainerContext ctx, InitialContextInitializer initializer, InitParams params) {
        super(ctx, initializer, params);
    }

    @Override
    public void addEventListener(Listener<S, D> listener) {
        this.addEventListener(listener.getName(), listener);
    }

    @Override
    public void addEventListener(String eventName, Listener<S, D> listener) {
        Class<?> listenerClass = listener.getClass();
        do {
            if (!listenerClass.isAnnotationPresent(Asynchronous.class)) continue;
            listener = new ListenerService.AsynchronousListener((ListenerService)this, listener);
            break;
        } while ((listenerClass = listenerClass.getSuperclass()) != null);
        List<Listener<S, D>> list = this.listenerMap.get(eventName);
        if (list == null) {
            list = new ArrayList<Listener<S, D>>();
        }
        list.add((Listener<S, D>)listener);
        this.listenerMap.put(eventName, list);
    }

    @Override
    public void removeEventListener(Listener<S, D> listener) {
        this.removeEventListener(listener.getName(), listener);
    }

    @Override
    public void removeEventListener(String eventName, Listener<S, D> listener) {
        List<Listener<S, D>> listeners = this.getEventListeners(eventName);
        listeners.remove(listener);
        if (listeners.size() == 0) {
            this.listenerMap.remove(eventName);
        }
        this.listenerMap.put(eventName, listeners);
    }

    @Override
    public void broadcastEvent(Event<S, D> event) {
        List<Listener<S, D>> listeners = this.getEventListeners(event.getEventName());
        if (listeners.size() == 0) {
            return;
        }
        for (Listener<S, D> listener : listeners) {
            try {
                listener.onEvent(event);
            }
            catch (Exception e) {
                LOG.error((Object)("Exception on broadcasting events occures: " + e.getMessage()), (Throwable)e);
            }
        }
    }

    @Override
    public List<Listener<S, D>> getEventListeners(String type) {
        if (!this.listenerMap.containsKey(type)) {
            return new ArrayList<Listener<S, D>>();
        }
        return this.listenerMap.get(type);
    }
}

