/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.graphics.color;

import java.awt.color.ColorSpace;
import java.awt.image.ColorModel;
import java.io.IOException;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSNull;
import org.apache.pdfbox.pdmodel.common.COSArrayList;
import org.apache.pdfbox.pdmodel.common.function.PDFunction;
import org.apache.pdfbox.pdmodel.graphics.color.PDColorSpace;
import org.apache.pdfbox.pdmodel.graphics.color.PDColorSpaceFactory;
import org.apache.pdfbox.pdmodel.graphics.color.PDDeviceNAttributes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PDDeviceN
extends PDColorSpace {
    private static final Log LOG = LogFactory.getLog(PDDeviceN.class);
    private static final int COLORANT_NAMES = 1;
    private static final int ALTERNATE_CS = 2;
    private static final int TINT_TRANSFORM = 3;
    private static final int DEVICEN_ATTRIBUTES = 4;
    private PDFunction tintTransform = null;
    private PDColorSpace alternateCS = null;
    private PDDeviceNAttributes deviceNAttributes = null;
    public static final String NAME = "DeviceN";

    public PDDeviceN() {
        this.array = new COSArray();
        this.array.add(COSName.DEVICEN);
        this.array.add(COSNull.NULL);
        this.array.add(COSNull.NULL);
        this.array.add(COSNull.NULL);
    }

    public PDDeviceN(COSArray csAttributes) {
        this.array = csAttributes;
    }

    @Override
    public COSBase getCOSObject() {
        return this.array;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public int getNumberOfComponents() throws IOException {
        return this.getColorantNames().size();
    }

    @Override
    protected ColorSpace createColorSpace() throws IOException {
        try {
            return this.getAlternateColorSpace().getJavaColorSpace();
        }
        catch (IOException ioexception) {
            LOG.error((Object)ioexception, (Throwable)ioexception);
            throw ioexception;
        }
        catch (Exception exception) {
            LOG.error((Object)exception, (Throwable)exception);
            throw new IOException("Failed to Create ColorSpace");
        }
    }

    @Override
    public ColorModel createColorModel(int bpc) throws IOException {
        LOG.info((Object)("About to create ColorModel for " + this.getAlternateColorSpace().toString()));
        return this.getAlternateColorSpace().createColorModel(bpc);
    }

    public List<String> getColorantNames() {
        COSArray names = (COSArray)this.array.getObject(1);
        return COSArrayList.convertCOSNameCOSArrayToList(names);
    }

    public void setColorantNames(List<String> names) {
        COSArray namesArray = COSArrayList.convertStringListToCOSNameCOSArray(names);
        this.array.set(1, namesArray);
    }

    public PDColorSpace getAlternateColorSpace() throws IOException {
        if (this.alternateCS == null) {
            COSBase alternate = this.array.getObject(2);
            this.alternateCS = PDColorSpaceFactory.createColorSpace(alternate);
        }
        return this.alternateCS;
    }

    public void setAlternateColorSpace(PDColorSpace cs) {
        this.alternateCS = cs;
        COSBase space = null;
        if (cs != null) {
            space = cs.getCOSObject();
        }
        this.array.set(2, space);
    }

    public PDFunction getTintTransform() throws IOException {
        if (this.tintTransform == null) {
            this.tintTransform = PDFunction.create(this.array.getObject(3));
        }
        return this.tintTransform;
    }

    public void setTintTransform(PDFunction tint) {
        this.tintTransform = tint;
        this.array.set(3, tint);
    }

    public PDDeviceNAttributes getAttributes() {
        if (this.deviceNAttributes == null && this.array.size() > 4) {
            this.deviceNAttributes = new PDDeviceNAttributes((COSDictionary)this.array.getObject(4));
        }
        return this.deviceNAttributes;
    }

    public void setAttributes(PDDeviceNAttributes attributes) {
        this.deviceNAttributes = attributes;
        if (attributes == null) {
            this.array.remove(4);
        } else {
            while (this.array.size() <= 4) {
                this.array.add(COSNull.NULL);
            }
            this.array.set(4, attributes.getCOSDictionary());
        }
    }

    public COSArray calculateColorValues(List<COSBase> tintValues) throws IOException {
        PDFunction tintTransform = this.getTintTransform();
        COSArray tint = new COSArray();
        tint.addAll(tintValues);
        return tintTransform.eval(tint);
    }
}

