/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.mop.jdbc.service;

import java.util.List;
import org.exoplatform.commons.api.persistence.DataInitializer;
import org.exoplatform.portal.mop.QueryResult;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.portal.mop.SiteType;
import org.exoplatform.portal.mop.jdbc.dao.ContainerDAO;
import org.exoplatform.portal.mop.jdbc.dao.PageDAO;
import org.exoplatform.portal.mop.jdbc.dao.PermissionDAO;
import org.exoplatform.portal.mop.jdbc.dao.SiteDAO;
import org.exoplatform.portal.mop.jdbc.dao.WindowDAO;
import org.exoplatform.portal.mop.jdbc.service.PageServiceImpl;
import org.exoplatform.portal.mop.page.PageContext;
import org.exoplatform.portal.mop.page.PageKey;
import org.exoplatform.portal.mop.page.PageService;
import org.exoplatform.portal.mop.page.PageServiceException;
import org.exoplatform.services.listener.ListenerService;
import org.gatein.common.logging.Logger;
import org.gatein.common.logging.LoggerFactory;

public class PageServiceWrapper
implements PageService {
    private static final Logger log = LoggerFactory.getLogger(PageServiceWrapper.class);
    private final PageServiceImpl service;
    private final ListenerService listenerService;

    public PageServiceWrapper(ListenerService listenerService, PageDAO pageDAO, ContainerDAO containerDAO, WindowDAO windowDAO, PermissionDAO permissionDAO, SiteDAO siteDAO, DataInitializer initializer) {
        this.service = new PageServiceImpl(pageDAO, containerDAO, windowDAO, permissionDAO, siteDAO);
        this.listenerService = listenerService;
    }

    @Override
    public PageContext loadPage(PageKey key) {
        return this.service.loadPage(key);
    }

    @Override
    public List<PageContext> loadPages(SiteKey siteKey) throws NullPointerException, PageServiceException {
        return this.service.loadPages(siteKey);
    }

    @Override
    public boolean savePage(PageContext page) {
        boolean created = this.service.savePage(page);
        if (created) {
            this.notify("org.exoplatform.portal.mop.page.page_created", page.getKey());
        } else {
            this.notify("org.exoplatform.portal.mop.page.page_updated", page.getKey());
        }
        return created;
    }

    @Override
    public boolean destroyPage(PageKey key) {
        boolean destroyed = this.service.destroyPage(key);
        if (destroyed) {
            this.notify("org.exoplatform.portal.mop.page.page_destroyed", key);
        }
        return destroyed;
    }

    @Override
    public PageContext clone(PageKey src, PageKey dst) {
        PageContext pageContext = this.service.clone(src, dst);
        this.notify("org.exoplatform.portal.mop.page.page_created", dst);
        return pageContext;
    }

    @Override
    public QueryResult<PageContext> findPages(int offset, int limit, SiteType siteType, String siteName, String pageName, String pageTitle) {
        return this.service.findPages(offset, limit, siteType, siteName, pageName, pageTitle);
    }

    private void notify(String name, PageKey key) {
        try {
            this.listenerService.broadcast(name, (Object)this, (Object)key);
        }
        catch (Exception e) {
            log.error((Object)("Error when delivering notification " + name + " for page " + key), (Throwable)e);
        }
    }
}

