/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.account;

import java.util.Locale;
import java.util.ResourceBundle;
import org.exoplatform.portal.account.UIAccountProfiles;
import org.exoplatform.portal.account.UIAccountSetting;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.mop.user.UserPortal;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserStatus;
import org.exoplatform.services.security.Authenticator;
import org.exoplatform.services.security.Credential;
import org.exoplatform.services.security.PasswordCredential;
import org.exoplatform.services.security.UsernameCredential;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.web.login.recovery.PasswordRecoveryService;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.webui.form.validator.MandatoryValidator;
import org.exoplatform.webui.form.validator.PasswordPolicyValidator;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="war:/groovy/portal/webui/portal/UIAccountChangePass.gtmpl", events={@EventConfig(listeners={SaveActionListener.class}), @EventConfig(listeners={ResetActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={ResetPassActionListener.class}, phase=Event.Phase.DECODE)})
public class UIAccountChangePass
extends UIForm {
    private String messageType = "info";
    private String messageKey = "UIAccountChangePass.msg.reset-password";

    public UIAccountChangePass() throws Exception {
        this.addUIFormInput((UIFormInput)new UIFormStringInput("currentpass", "password", null).setType((short)1).addValidator(MandatoryValidator.class, new Object[0]));
        this.addUIFormInput((UIFormInput)new UIFormStringInput("newpass", "password", null).setType((short)1).addValidator(PasswordPolicyValidator.class, new Object[0]).addValidator(MandatoryValidator.class, new Object[0]));
        this.addUIFormInput((UIFormInput)new UIFormStringInput("confirmnewpass", "password", null).setType((short)1).addValidator(PasswordPolicyValidator.class, new Object[0]).addValidator(MandatoryValidator.class, new Object[0]));
        this.setActions(new String[]{"Save", "Reset", "ResetPass"});
    }

    public String upperFirstChar(String s) {
        return Character.toUpperCase(s.charAt(0)) + s.substring(1);
    }

    public String getMessageType() {
        return this.messageType;
    }

    public String getMessage() {
        WebuiRequestContext context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        ResourceBundle res = context.getApplicationResourceBundle();
        try {
            String message = res.getString(this.messageKey);
            if (message.indexOf("<a href=\"#RESETPASSWORD\">") != -1) {
                String replace = "<a href=\"javascript:void(0);\" onclick=\"" + this.event("ResetPass") + "\">";
                message = message.replace("<a href=\"#RESETPASSWORD\">", replace);
            }
            return message;
        }
        catch (Exception ex) {
            return this.messageKey;
        }
    }

    public static class ResetPassActionListener
    extends EventListener<UIAccountChangePass> {
        public void execute(Event<UIAccountChangePass> event) throws Exception {
            Locale locale;
            WebuiRequestContext context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
            PortalRequestContext pContext = (PortalRequestContext)PortalRequestContext.getCurrentInstance();
            UIApplication uiApp = context.getUIApplication();
            UIAccountChangePass form = (UIAccountChangePass)((Object)event.getSource());
            OrganizationService orgService = (OrganizationService)form.getApplicationComponent(OrganizationService.class);
            PasswordRecoveryService service = (PasswordRecoveryService)form.getApplicationComponent(PasswordRecoveryService.class);
            String username = event.getRequestContext().getRemoteUser();
            User u = null;
            try {
                u = orgService.getUserHandler().findUserByName(username, UserStatus.ANY);
            }
            catch (Exception ex) {
                u = null;
            }
            UserPortal portal = pContext.getUserPortal();
            Locale locale2 = locale = portal != null ? portal.getLocale() : null;
            if (locale == null) {
                locale = Locale.ENGLISH;
            }
            if (u == null || !u.isEnabled()) {
                form.messageKey = "UIAccountChangePass.msg.account-not-exist";
                form.messageType = "error";
            } else if (service.sendRecoverPasswordEmail(u, locale, pContext.getRequest())) {
                form.messageKey = "UIAccountChangePass.msg.email-reset-password-sent";
                form.messageType = "success";
            } else {
                form.messageKey = "UIAccountChangePass.msg.email-reset-password-not-sent";
                form.messageType = "error";
            }
            context.addUIComponentToUpdateByAjax((UIComponent)form);
        }
    }

    public static class SaveActionListener
    extends EventListener<UIAccountChangePass> {
        public void execute(Event<UIAccountChangePass> event) throws Exception {
            boolean authenticated;
            UIAccountChangePass uiForm = (UIAccountChangePass)((Object)event.getSource());
            OrganizationService service = (OrganizationService)uiForm.getApplicationComponent(OrganizationService.class);
            WebuiRequestContext context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
            UIApplication uiApp = context.getUIApplication();
            String username = Util.getPortalRequestContext().getRemoteUser();
            User user = service.getUserHandler().findUserByName(username);
            String currentPass = (String)uiForm.getUIStringInput("currentpass").getValue();
            String newPass = (String)uiForm.getUIStringInput("newpass").getValue();
            String confirmnewPass = (String)uiForm.getUIStringInput("confirmnewpass").getValue();
            Authenticator authenticator = (Authenticator)uiForm.getApplicationComponent(Authenticator.class);
            try {
                UsernameCredential usernameCred = new UsernameCredential(username);
                PasswordCredential passwordCred = new PasswordCredential(currentPass);
                authenticator.validateUser(new Credential[]{usernameCred, passwordCred});
                authenticated = true;
            }
            catch (Exception ex) {
                authenticated = false;
            }
            if (!authenticated) {
                uiApp.addMessage(new ApplicationMessage("UIAccountChangePass.msg.currentpassword-is-not-match", null, 1));
                uiForm.reset();
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiForm);
                return;
            }
            if (!newPass.equals(confirmnewPass)) {
                uiApp.addMessage(new ApplicationMessage("UIAccountChangePass.msg.password-is-not-match", null, 1));
                uiForm.reset();
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiForm);
                return;
            }
            try {
                user.setPassword(newPass);
                service.getUserHandler().saveUser(user, true);
                uiApp.addMessage(new ApplicationMessage("UIAccountChangePass.msg.change.pass.success", null));
                UIAccountSetting ui = (UIAccountSetting)uiForm.getParent();
                ((UIAccountProfiles)ui.getChild(UIAccountProfiles.class)).setRendered(true);
                ((UIAccountChangePass)ui.getChild(UIAccountChangePass.class)).setRendered(false);
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)ui);
            }
            catch (Exception e) {
                uiApp.addMessage(new ApplicationMessage("UIAccountChangePass.msg.change.pass.fail", null, 0));
            }
            uiForm.reset();
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiForm);
        }
    }

    public static class ResetActionListener
    extends EventListener<UIAccountChangePass> {
        public void execute(Event<UIAccountChangePass> event) throws Exception {
            UIAccountChangePass uiForm = (UIAccountChangePass)((Object)event.getSource());
            uiForm.reset();
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiForm);
        }
    }
}

