/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.application.localization;

import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.application.localization.LocalizationFilter;

public class HttpRequestWrapper
extends HttpServletRequestWrapper {
    private static final List<Locale> EMPTY_LOCALE_LIST = Collections.emptyList();

    public HttpRequestWrapper(HttpServletRequest request) {
        super(request);
    }

    public Locale getLocale() {
        if (PortalRequestContext.getCurrentInstance() != null) {
            return this.getRequest().getLocale();
        }
        Locale current = LocalizationFilter.getCurrentLocale();
        if (current != null) {
            return current;
        }
        return this.getRequest().getLocale();
    }

    public Enumeration getLocales() {
        Locale current = LocalizationFilter.getCurrentLocale();
        if (PortalRequestContext.getCurrentInstance() != null || current == null) {
            return this.getRequest().getLocales();
        }
        Locale loc = this.getLocale();
        if (loc == null) {
            return Collections.enumeration(EMPTY_LOCALE_LIST);
        }
        LinkedList<Locale> locs = new LinkedList<Locale>();
        locs.add(loc);
        Enumeration clientLocs = this.getRequest().getLocales();
        while (clientLocs.hasMoreElements()) {
            current = (Locale)clientLocs.nextElement();
            if (current.getLanguage().equals(loc.getLanguage()) && current.getCountry().equals(loc.getCountry())) continue;
            locs.add(current);
        }
        return Collections.enumeration(locs);
    }
}

