/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.api.internal;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public class StringJoiner {
    private final String separator;
    private final int trimFlag;
    private final boolean ignoreNulls;
    private final boolean leading;
    private final boolean trailing;

    private StringJoiner(String separator) {
        this(separator, -1, false, false, false);
    }

    private StringJoiner(String separator, int trimFlag, boolean ignoreNulls, boolean leading, boolean trailing) {
        this.separator = separator;
        this.trimFlag = trimFlag;
        this.ignoreNulls = ignoreNulls;
        this.leading = leading;
        this.trailing = trailing;
    }

    public StringJoiner ignoreNulls() {
        return new StringJoiner(this.separator, this.trimFlag, true, this.leading, this.trailing);
    }

    public StringJoiner leading() {
        return new StringJoiner(this.separator, this.trimFlag, this.ignoreNulls, true, this.trailing);
    }

    public StringJoiner trailing() {
        return new StringJoiner(this.separator, this.trimFlag, this.ignoreNulls, this.leading, true);
    }

    public StringJoiner trim() {
        return new StringJoiner(this.separator, 0, this.ignoreNulls, this.leading, this.trailing);
    }

    public StringJoiner trimToNull() {
        return new StringJoiner(this.separator, 1, this.ignoreNulls, this.leading, this.trailing);
    }

    public String join(List<String> parts) {
        if (parts == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder(parts.size());
        Iterator<String> iter = parts.iterator();
        while (iter.hasNext()) {
            String part = iter.next();
            if (this.trimFlag > 0) {
                String string = part = this.trimFlag == 0 ? this.trim(part) : this.trimToNull(part);
            }
            if (this.ignoreNulls && part == null) continue;
            sb.append(part);
            if (!iter.hasNext()) {
                if (!this.trailing) continue;
                sb.append(this.separator);
                continue;
            }
            sb.append(this.separator);
        }
        if (sb.length() == 0 && this.trimFlag == 1) {
            return null;
        }
        if (this.leading) {
            sb.insert(0, this.separator);
        }
        return sb.toString();
    }

    public String join(String ... parts) {
        return this.join(Arrays.asList(parts));
    }

    private String trim(String string) {
        return string == null ? null : string.trim();
    }

    private String trimToNull(String string) {
        if (string == null) {
            return null;
        }
        return (string = string.trim()).length() == 0 ? null : string;
    }

    public static StringJoiner joiner(String separator) {
        return new StringJoiner(separator);
    }
}

