/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.common;

import java.io.IOException;
import java.io.Reader;
import java.util.Iterator;
import juzu.impl.common.Tools;

public class CompositeReader
extends Reader {
    private Iterator<Reader> compounds;
    private Reader current;

    public CompositeReader(Reader ... compounds) throws NullPointerException {
        this(Tools.iterator(compounds));
    }

    public CompositeReader(Iterable<Reader> compounds) throws NullPointerException {
        this(compounds.iterator());
    }

    public CompositeReader(Iterator<Reader> compounds) throws NullPointerException {
        this.compounds = compounds;
        this.current = null;
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        int read = 0;
        while (len > 0) {
            if (this.current == null) {
                if (this.compounds.hasNext()) {
                    this.current = this.compounds.next();
                    continue;
                }
                if (read != 0) break;
                read = -1;
                break;
            }
            int tmp = this.current.read(cbuf, off, len);
            if (tmp == -1) {
                Reader reader = this.current;
                this.current = null;
                reader.close();
                continue;
            }
            off += tmp;
            len -= tmp;
            read += tmp;
        }
        return read;
    }

    @Override
    public void close() throws IOException {
        if (this.current != null) {
            Tools.safeClose(this.current);
            this.current = null;
        }
        while (this.compounds.hasNext()) {
            Tools.safeClose(this.compounds.next());
        }
        this.compounds = null;
    }
}

