/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.io;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import juzu.io.OutputStream;

public abstract class CharStream
extends OutputStream {
    private final Charset charset;
    private CharsetDecoder decoder;
    private CharBuffer bb;

    protected CharStream(Charset charset) {
        this.charset = charset;
    }

    @Override
    public void append(byte[] data) throws IOException {
        this.append(data, 0, data.length);
    }

    @Override
    public void append(byte[] data, int off, int len) throws IOException {
        this.append(ByteBuffer.wrap(data, off, len));
    }

    @Override
    public void append(ByteBuffer buffer) throws IOException {
        block7: {
            if (buffer.hasRemaining()) {
                CoderResult result;
                if (this.decoder == null) {
                    this.decoder = this.charset.newDecoder().onUnmappableCharacter(CodingErrorAction.REPORT).onMalformedInput(CodingErrorAction.IGNORE);
                    this.bb = CharBuffer.allocate(512);
                } else {
                    this.decoder.reset();
                }
                while (true) {
                    CoderResult coderResult = result = buffer.hasRemaining() ? this.decoder.decode(buffer, this.bb, true) : this.decoder.flush(this.bb);
                    if (result.isUnderflow() || result.isOverflow()) {
                        this.bb.flip();
                        if (this.bb.hasRemaining()) {
                            this.append(this.bb);
                        }
                        this.bb.clear();
                        if (!result.isUnderflow()) continue;
                        if (buffer.remaining() > 0) {
                            throw new UnsupportedOperationException("We don't support this case yet");
                        }
                        break block7;
                    }
                    if (!result.isUnmappable()) break;
                    buffer.position(buffer.position() + result.length());
                }
                throw new UnsupportedOperationException("We don't support this case yet (2) " + result);
            }
        }
    }

    @Override
    public void append(CharBuffer buffer) throws IOException {
        this.append(buffer, buffer.arrayOffset() + buffer.position(), buffer.limit() - buffer.arrayOffset());
    }
}

