/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.plugin.asset;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import juzu.asset.AssetLocation;
import juzu.impl.common.JSON;
import juzu.impl.compiler.ElementHandle;
import juzu.impl.plugin.asset.AssetKey;
import juzu.plugin.asset.Minifier;

public class Asset
implements Serializable {
    public final String id;
    public final String type;
    public final Boolean header;
    public final List<String> depends;
    public final AssetKey key;
    public final String minified;
    public final Integer maxAge;
    public final List<ElementHandle.Type> minifiersTypes;

    public Asset(String type, Map<String, Serializable> asset) {
        String id = (String)((Object)asset.get("id"));
        String value = (String)((Object)asset.get("value"));
        List depends = (List)((Object)asset.get("depends"));
        AssetLocation location = AssetLocation.safeValueOf((String)((Object)asset.get("location")));
        Integer maxAge = (Integer)asset.get("maxAge");
        String minified = (String)((Object)asset.get("minified"));
        Boolean header = (Boolean)asset.get("header");
        List minifiersTypes = (List)((Object)asset.get("minifier"));
        if (type == null) {
            throw new NullPointerException("No null type accepted");
        }
        if (id == null) {
            throw new IllegalArgumentException("No null id accepted");
        }
        if (value == null) {
            throw new IllegalArgumentException("No null value accepted");
        }
        if (location == null) {
            throw new IllegalArgumentException("No null location accepted");
        }
        this.id = id;
        this.type = type;
        this.depends = depends != null ? depends : new ArrayList();
        this.key = new AssetKey(value, location);
        this.maxAge = maxAge;
        this.minified = minified;
        this.header = header;
        this.minifiersTypes = minifiersTypes != null ? minifiersTypes : Collections.emptyList();
    }

    public Asset(String id, String type, String value, String minified, List<String> depends, AssetLocation location, Integer maxAge, Boolean header) {
        if (type == null) {
            throw new NullPointerException("No null type accepted");
        }
        if (id == null) {
            throw new NullPointerException("No null id accepted");
        }
        if (value == null) {
            throw new NullPointerException("No null value accepted");
        }
        if (location == null) {
            throw new NullPointerException("No null location accepted");
        }
        this.id = id;
        this.type = type;
        this.depends = depends;
        this.key = new AssetKey(value, location);
        this.maxAge = maxAge;
        this.minified = minified;
        this.header = header;
        this.minifiersTypes = Collections.emptyList();
    }

    public boolean isApplication() {
        return this.key.location == AssetLocation.APPLICATION;
    }

    protected String getSource() {
        return this.key.value;
    }

    private String getMinifiedSource() {
        String source = this.getSource();
        int index = source.lastIndexOf(".");
        if (index == -1) {
            return source + "-min";
        }
        return source.substring(0, index) + "-min." + source.substring(index + 1);
    }

    public Map<String, String> getSources() {
        HashMap<String, String> sources = new HashMap<String, String>();
        String source = this.getSource();
        sources.put(this.key.value, source);
        if (this.minified != null) {
            sources.put(this.minified, this.minified);
        } else if (this.minifiersTypes.size() > 0) {
            sources.put(this.getMinifiedSource(), source);
        }
        return sources;
    }

    public JSON getJSON() {
        JSON json = new JSON().set("value", this.key.value).set("location", this.key.location.toString()).set("type", this.type);
        if (this.minified != null) {
            json.set("minified", this.minified);
        } else if (this.minifiersTypes.size() > 0) {
            json.set("minified", this.getMinifiedSource());
        }
        if (this.maxAge != null) {
            json.set("max-age", this.maxAge);
        }
        if (this.depends != null) {
            json.set("depends", this.depends);
        }
        if (this.header != null) {
            json.set("header", this.header);
        }
        return json;
    }

    public InputStream open(String source, URLConnection resource) throws IOException {
        InputStream in = resource.getInputStream();
        if (source.equals(this.key.value)) {
            return in;
        }
        if (this.minifiersTypes.size() > 0) {
            ArrayList<Minifier> minifiers = new ArrayList<Minifier>(this.minifiersTypes.size());
            for (ElementHandle.Type minifierType : this.minifiersTypes) {
                try {
                    Class<?> minifierClass = Asset.class.getClassLoader().loadClass(minifierType.getName().toString());
                    Minifier minifier = (Minifier)minifierClass.newInstance();
                    minifiers.add(minifier);
                }
                catch (InstantiationException e) {
                    throw new IOException(e.getMessage(), e.getCause());
                }
                catch (Exception e) {
                    throw new IOException(e);
                }
            }
            for (Minifier minifier : minifiers) {
                in = minifier.minify(source, this.type, in);
            }
        }
        return in;
    }
}

