/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.file.storage;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.exoplatform.commons.api.persistence.ExoTransactional;
import org.exoplatform.commons.file.model.FileInfo;
import org.exoplatform.commons.file.model.NameSpace;
import org.exoplatform.commons.file.model.OrphanFile;
import org.exoplatform.commons.file.storage.DataStorage$AjcClosure1;
import org.exoplatform.commons.file.storage.dao.FileInfoDAO;
import org.exoplatform.commons.file.storage.dao.NameSpaceDAO;
import org.exoplatform.commons.file.storage.dao.OrphanFileDAO;
import org.exoplatform.commons.file.storage.entity.FileInfoEntity;
import org.exoplatform.commons.file.storage.entity.NameSpaceEntity;
import org.exoplatform.commons.file.storage.entity.OrphanFileEntity;
import org.exoplatform.commons.persistence.impl.ExoTransactionalAspect;

public class DataStorage {
    private FileInfoDAO fileInfoDAO;
    private NameSpaceDAO nameSpaceDAO;
    private OrphanFileDAO orphanFileDAO;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    public DataStorage(FileInfoDAO fileInfoDAO, NameSpaceDAO nameSpaceDAO, OrphanFileDAO orphanFileDAO) {
        this.fileInfoDAO = fileInfoDAO;
        this.nameSpaceDAO = nameSpaceDAO;
        this.orphanFileDAO = orphanFileDAO;
    }

    public FileInfo getFileInfo(long id) {
        FileInfoEntity fileInfoEntity = (FileInfoEntity)this.fileInfoDAO.find(Long.valueOf(id));
        return this.convertFileEntityToFileInfo(fileInfoEntity);
    }

    public List<FileInfo> getAllFilesInfo(int offset, int limit) {
        List<FileInfoEntity> result = this.fileInfoDAO.findAllByPage(offset, limit);
        ArrayList<FileInfo> listFilesInfo = new ArrayList<FileInfo>();
        for (FileInfoEntity f : result) {
            listFilesInfo.add(this.convertFileEntityToFileInfo(f));
        }
        return listFilesInfo;
    }

    public int sharedChecksum(String checksum) {
        List<FileInfoEntity> result = this.fileInfoDAO.findFilesByChecksum(checksum);
        return result.size();
    }

    public NameSpace getNameSpace(long id) {
        NameSpaceEntity nameSpaceEntity = (NameSpaceEntity)this.nameSpaceDAO.find(Long.valueOf(id));
        return this.convertNameSpace(nameSpaceEntity);
    }

    @ExoTransactional
    public NameSpace getNameSpace(String name) {
        String string = name;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)string);
        Object[] objectArray = new Object[]{this, string, joinPoint};
        return (NameSpace)ExoTransactionalAspect.aspectOf().around(new DataStorage$AjcClosure1(objectArray).linkClosureAndJoinPoint(69648));
    }

    public void createNameSpaces(List<NameSpace> listNameSpace) {
        ArrayList<NameSpaceEntity> entityList = new ArrayList<NameSpaceEntity>();
        for (NameSpace s : listNameSpace) {
            NameSpaceEntity n = new NameSpaceEntity(s.getName(), s.getDescription());
            entityList.add(n);
        }
        this.nameSpaceDAO.createAll(entityList);
    }

    public NameSpace createNameSpace(NameSpace nameSpace) {
        NameSpaceEntity n = new NameSpaceEntity(nameSpace.getName(), nameSpace.getDescription());
        NameSpaceEntity createdNameSpace = (NameSpaceEntity)this.nameSpaceDAO.create(n);
        return this.convertNameSpace(createdNameSpace);
    }

    public FileInfo create(FileInfo fileInfo, NameSpace nameSpace) {
        if (fileInfo == null) {
            return null;
        }
        NameSpaceEntity nSpace = new NameSpaceEntity(nameSpace.getId(), nameSpace.getName(), nameSpace.getDescription());
        FileInfoEntity fileInfoEntity = new FileInfoEntity(fileInfo.getName(), fileInfo.getMimetype(), fileInfo.getSize(), fileInfo.getUpdatedDate(), fileInfo.getUpdater(), fileInfo.getChecksum(), fileInfo.isDeleted());
        fileInfoEntity.setNameSpaceEntity(nSpace);
        FileInfoEntity createdFile = (FileInfoEntity)this.fileInfoDAO.create(fileInfoEntity);
        return this.convertFileEntityToFileInfo(createdFile);
    }

    public FileInfo updateFileInfo(FileInfo fileInfo) {
        if (fileInfo == null) {
            return null;
        }
        FileInfoEntity fileInfoEntity = new FileInfoEntity(fileInfo.getId(), fileInfo.getName(), fileInfo.getMimetype(), fileInfo.getSize(), fileInfo.getUpdatedDate(), fileInfo.getUpdater(), fileInfo.getChecksum(), fileInfo.isDeleted());
        NameSpaceEntity nsEntity = this.nameSpaceDAO.getNameSpaceByName(fileInfo.getNameSpace());
        fileInfoEntity.setNameSpaceEntity(nsEntity);
        FileInfoEntity updated = (FileInfoEntity)this.fileInfoDAO.update(fileInfoEntity);
        return this.convertFileEntityToFileInfo(updated);
    }

    public void deleteFileInfo(long id) {
        FileInfoEntity fileInfoEntity = (FileInfoEntity)this.fileInfoDAO.find(Long.valueOf(id));
        if (fileInfoEntity == null) {
            return;
        }
        this.fileInfoDAO.delete(fileInfoEntity);
    }

    public void createOrphanFile(FileInfo fileInfo) {
        FileInfoEntity fileInfoEntity = new FileInfoEntity(fileInfo.getId(), fileInfo.getName(), fileInfo.getMimetype(), fileInfo.getSize(), fileInfo.getUpdatedDate(), fileInfo.getUpdater(), fileInfo.getChecksum(), fileInfo.isDeleted());
        OrphanFileEntity deletedFileEntity = new OrphanFileEntity();
        deletedFileEntity.setChecksum(fileInfo.getChecksum());
        deletedFileEntity.setFileInfoEntity(fileInfoEntity);
        deletedFileEntity.setDeletedDate(new Date());
        this.orphanFileDAO.create(deletedFileEntity);
    }

    public void deleteOrphanFile(long id) {
        OrphanFileEntity orphanFileEntity = (OrphanFileEntity)this.orphanFileDAO.find(Long.valueOf(id));
        if (orphanFileEntity != null) {
            this.orphanFileDAO.delete(orphanFileEntity);
        }
    }

    public List<FileInfo> getAllDeletedFiles(Date date) {
        List<FileInfoEntity> result = this.fileInfoDAO.findDeletedFiles(date);
        ArrayList<FileInfo> fileInfoList = new ArrayList<FileInfo>();
        for (FileInfoEntity f : result) {
            FileInfo obj = this.convertFileEntityToFileInfo(f);
            if (obj == null) continue;
            fileInfoList.add(this.convertFileEntityToFileInfo(f));
        }
        return fileInfoList;
    }

    public List<OrphanFile> getAllOrphanFile(Date date) {
        List<OrphanFileEntity> result = this.orphanFileDAO.findDeletedFiles(date);
        ArrayList<OrphanFile> orphanFileList = new ArrayList<OrphanFile>();
        for (OrphanFileEntity o : result) {
            OrphanFile file = this.convertOrphanFileEntity(o);
            if (file == null) continue;
            orphanFileList.add(file);
        }
        return orphanFileList;
    }

    private FileInfo convertFileEntityToFileInfo(FileInfoEntity fileInfoEntity) {
        if (fileInfoEntity == null) {
            return null;
        }
        FileInfo fileInfo = new FileInfo(fileInfoEntity.getId(), fileInfoEntity.getName(), fileInfoEntity.getMimetype(), fileInfoEntity.getNameSpaceEntity().getName(), fileInfoEntity.getSize(), fileInfoEntity.getUpdatedDate(), fileInfoEntity.getUpdater(), fileInfoEntity.getChecksum(), fileInfoEntity.isDeleted());
        return fileInfo;
    }

    private NameSpace convertNameSpace(NameSpaceEntity nameSpaceEntity) {
        if (nameSpaceEntity == null) {
            return null;
        }
        return new NameSpace(nameSpaceEntity.getId(), nameSpaceEntity.getName(), nameSpaceEntity.getDescription());
    }

    private OrphanFile convertOrphanFileEntity(OrphanFileEntity orphanFileEntity) {
        if (orphanFileEntity == null) {
            return null;
        }
        OrphanFile orphanFile = orphanFileEntity.getFileInfoEntity() != null ? new OrphanFile(orphanFileEntity.getId(), orphanFileEntity.getFileInfoEntity().getId(), orphanFileEntity.getChecksum(), orphanFileEntity.getDeletedDate()) : new OrphanFile(orphanFileEntity.getId(), -1L, orphanFileEntity.getChecksum(), orphanFileEntity.getDeletedDate());
        return orphanFile;
    }

    static {
        DataStorage.ajc$preClinit();
    }

    static /* synthetic */ NameSpace getNameSpace_aroundBody0(DataStorage ajc$this, String name, JoinPoint joinPoint) {
        NameSpaceEntity nameSpaceEntity = ajc$this.nameSpaceDAO.getNameSpaceByName(name);
        return ajc$this.convertNameSpace(nameSpaceEntity);
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("DataStorage.java", DataStorage.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getNameSpace", "org.exoplatform.commons.file.storage.DataStorage", "java.lang.String", "name", "", "org.exoplatform.commons.file.model.NameSpace"), 78);
    }
}

