/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.account.setup.web;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.exoplatform.account.setup.web.AccountSetupService;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.web.filter.Filter;

public class AccountSetupFilter
implements Filter {
    private static final String PLF_PLATFORM_EXTENSION_SERVLET_CTX = "/commons-extension";
    private static final String ACCOUNT_SETUP_SERVLET = "/accountSetup";

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpServletRequest = (HttpServletRequest)request;
        HttpServletResponse httpServletResponse = (HttpServletResponse)response;
        PortalContainer container = PortalContainer.getInstance();
        AccountSetupService accountSetupService = (AccountSetupService)container.getComponentInstanceOfType(AccountSetupService.class);
        boolean setupDone = accountSetupService.mustSkipAccountSetup();
        String requestUri = httpServletRequest.getRequestURI();
        boolean isRestUri = requestUri.contains(container.getContext().getRestContextName());
        if (!setupDone && !isRestUri) {
            ServletContext platformExtensionContext = httpServletRequest.getSession().getServletContext().getContext(PLF_PLATFORM_EXTENSION_SERVLET_CTX);
            platformExtensionContext.getRequestDispatcher(ACCOUNT_SETUP_SERVLET).forward((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
            return;
        }
        chain.doFilter(request, response);
    }
}

