/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.kudos.listener;

import java.util.HashMap;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.kudos.model.Kudos;
import org.exoplatform.kudos.service.KudosService;
import org.exoplatform.services.listener.Asynchronous;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.manager.ActivityManager;
import org.exoplatform.social.core.service.LinkProvider;

@Asynchronous
public class GamificationIntegrationListener
extends Listener<KudosService, Kudos> {
    private static final Log LOG = ExoLogger.getLogger(GamificationIntegrationListener.class);
    private ListenerService listenerService;
    private ActivityManager activityManager;
    private PortalContainer container;

    public GamificationIntegrationListener(PortalContainer container, ListenerService listenerService) {
        this.container = container;
        this.listenerService = listenerService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onEvent(Event<KudosService, Kudos> event) throws Exception {
        ExoContainerContext.setCurrentContainer((ExoContainer)this.container);
        RequestLifeCycle.begin((ExoContainer)this.container);
        try {
            HashMap<String, String> gam;
            Kudos kudos = (Kudos)event.getData();
            long activityId = kudos.getActivityId();
            String activityURL = "/";
            if (activityId > 0L) {
                ExoSocialActivity activity = this.getActivityManager().getActivity("comment" + activityId);
                if (activity != null) {
                    activityURL = LinkProvider.getSingleActivityUrl((String)(activity.getParentId() + "#comment-" + activity.getId()));
                } else {
                    activity = this.getActivityManager().getActivity(String.valueOf(activityId));
                    if (activity != null) {
                        activityURL = LinkProvider.getSingleActivityUrl((String)activity.getId());
                    }
                }
            }
            try {
                gam = new HashMap<String, String>();
                gam.put("ruleTitle", "sendKudos");
                gam.put("object", activityURL);
                gam.put("senderId", kudos.getSenderId());
                gam.put("receiverId", kudos.getReceiverId());
                this.listenerService.broadcast("exo.gamification.generic.action", gam, (Object)String.valueOf(kudos.getTechnicalId()));
            }
            catch (Exception e) {
                LOG.error((Object)"Cannot broadcast gamification event");
            }
            try {
                gam = new HashMap();
                gam.put("ruleTitle", "receiveKudos");
                gam.put("object", activityURL);
                gam.put("senderId", kudos.getReceiverId());
                gam.put("receiverId", kudos.getSenderId());
                this.listenerService.broadcast("exo.gamification.generic.action", gam, (Object)String.valueOf(kudos.getTechnicalId()));
            }
            catch (Exception e) {
                LOG.error((Object)"Cannot broadcast gamification event");
            }
        }
        finally {
            RequestLifeCycle.end();
        }
    }

    public ActivityManager getActivityManager() {
        if (this.activityManager == null) {
            this.activityManager = (ActivityManager)CommonsUtils.getService(ActivityManager.class);
        }
        return this.activityManager;
    }
}

