/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.kudos.rest;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.List;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.kudos.model.Kudos;
import org.exoplatform.kudos.model.KudosList;
import org.exoplatform.kudos.model.KudosPeriod;
import org.exoplatform.kudos.model.KudosPeriodType;
import org.exoplatform.kudos.service.KudosService;
import org.exoplatform.kudos.service.utils.Utils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.IdentityManager;

@Path(value="/kudos/api/kudos")
@Api(value="/kudos/api/kudos", description="Manages Kudos")
@RolesAllowed(value={"users"})
public class KudosREST
implements ResourceContainer {
    private static final Log LOG = ExoLogger.getLogger(KudosREST.class);
    private KudosService kudosService;
    private IdentityManager identityManager;

    public KudosREST(IdentityManager identityManager, KudosService kudosService) {
        this.identityManager = identityManager;
        this.kudosService = kudosService;
    }

    @GET
    @Produces(value={"application/json"})
    @RolesAllowed(value={"administrators"})
    @ApiOperation(value="Get Kudos list created in a period contained a selected date in seconds", httpMethod="GET", response=Response.class, produces="application/json", notes="returns list of Kudos")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=400, message="Invalid query input"), @ApiResponse(code=500, message="Internal server error")})
    public Response getKudosByPeriodOfDate(@ApiParam(value="Timestamp in seconds of date in the middle of selected period. If not defined, current time will be used.", required=false) @QueryParam(value="dateInSeconds") long dateInSeconds, @ApiParam(value="Limit of results to return", required=false) @QueryParam(value="limit") int limit) {
        if (dateInSeconds == 0L) {
            dateInSeconds = System.currentTimeMillis() / 1000L;
        }
        try {
            List<Kudos> allKudosByPeriod = this.kudosService.getKudosByPeriodOfDate(dateInSeconds, this.getLimit(limit));
            return Response.ok(allKudosByPeriod).build();
        }
        catch (Exception e) {
            LOG.warn("Error getting kudos list of period with date {}", new Object[]{dateInSeconds, e});
            return Response.serverError().build();
        }
    }

    @Path(value="byEntity")
    @GET
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @ApiOperation(value="Get Kudos list by entity type and id", httpMethod="GET", response=Response.class, produces="application/json", notes="returns list of Kudos")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=400, message="Invalid query input"), @ApiResponse(code=403, message="Unauthorized operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response getEntityKudos(@ApiParam(value="kudos entity type (for example activity, comment...)", required=true) @QueryParam(value="entityType") String entityType, @ApiParam(value="kudos entity id", required=true) @QueryParam(value="entityId") String entityId, @ApiParam(value="Limit of results to return", required=false) @QueryParam(value="limit") int limit) {
        if (StringUtils.isBlank((String)entityType) || StringUtils.isBlank((String)entityId)) {
            LOG.warn((Object)"Bad request sent to server with empty 'attached entity id or type'");
            return Response.status((int)400).build();
        }
        try {
            List<Kudos> allKudosByEntity = this.kudosService.getKudosByEntity(entityType, entityId, this.getLimit(limit));
            return Response.ok(allKudosByEntity).build();
        }
        catch (Exception e) {
            LOG.warn("Error getting kudos entity of entity {}/{}", new Object[]{entityType, entityId, e});
            return Response.serverError().build();
        }
    }

    @GET
    @Path(value="byDates")
    @Produces(value={"application/json"})
    @RolesAllowed(value={"administrators"})
    @ApiOperation(value="Get Kudos list created between start and end dates in seconds", httpMethod="GET", response=Response.class, produces="application/json", notes="returns list of Kudos")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=400, message="Invalid query input"), @ApiResponse(code=403, message="Unauthorized operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response getKudosByDates(@QueryParam(value="startDateInSeconds") long startDateInSeconds, @QueryParam(value="endDateInSeconds") long endDateInSeconds, @ApiParam(value="Limit of results to return", required=false) @QueryParam(value="limit") int limit) {
        if (startDateInSeconds == 0L || endDateInSeconds == 0L) {
            LOG.warn((Object)"Bad request sent to server with empty 'start or end' dates parameter");
            return Response.status((int)400).build();
        }
        try {
            List<Kudos> allKudosByPeriod = this.kudosService.getKudosByPeriod(startDateInSeconds, endDateInSeconds, this.getLimit(limit));
            return Response.ok(allKudosByPeriod).build();
        }
        catch (Exception e) {
            LOG.warn("Error getting kudos list of period: from {} to {}", new Object[]{startDateInSeconds, endDateInSeconds, e});
            return Response.serverError().build();
        }
    }

    @GET
    @Path(value="{identityId}/received")
    @RolesAllowed(value={"users"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Retrieve the list of received Kudos by a user or space in a selected period", httpMethod="GET", response=Response.class, produces="application/json", notes="returns list of Kudos")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=400, message="Invalid query input"), @ApiResponse(code=500, message="Internal server error")})
    public Response getReceivedKudosByPeriod(@ApiParam(value="User or space identity technical id", required=true) @PathParam(value="identityId") long identityId, @ApiParam(value="Date in the middle of a period defined using a timestamp in seconds", required=true) @QueryParam(value="dateInSeconds") long dateInSeconds, @ApiParam(value="Period type, can be: WEEK, MONTH, QUARTER, SEMESTER and YEAR. Default is the same as configured period", required=true) @QueryParam(value="periodType") String periodType, @ApiParam(value="Limit of kudos to retrieve, if equal to 0, no kudos will be retrieved", required=true) @QueryParam(value="limit") int limit, @ApiParam(value="Whether return size of received kudos, default = false", required=false) @QueryParam(value="returnSize") boolean returnSize) {
        if (identityId <= 0L) {
            return Response.status((int)400).entity((Object)"identityId is mandatory").build();
        }
        if (dateInSeconds < 0L) {
            return Response.status((int)400).entity((Object)"dateInSeconds parameter should be a positive number").build();
        }
        if (limit < 0) {
            return Response.status((int)400).entity((Object)"limit parameter should be a positive number").build();
        }
        if (!returnSize && limit == 0) {
            return Response.status((int)400).entity((Object)"you should whether use 'limit' to get a list of kudos or 'returnSize' to return the size").build();
        }
        Identity identity = this.identityManager.getIdentity(String.valueOf(identityId), true);
        if (identity == null) {
            return Response.status((int)400).entity((Object)("Can't find identity with id " + identityId)).build();
        }
        if (dateInSeconds == 0L) {
            dateInSeconds = System.currentTimeMillis() / 1000L;
        }
        KudosPeriodType kudosPeriodType = null;
        if (StringUtils.isBlank((String)periodType)) {
            kudosPeriodType = this.kudosService.getDefaultKudosPeriodType();
        } else {
            try {
                kudosPeriodType = KudosPeriodType.valueOf(periodType.toUpperCase());
            }
            catch (Exception e) {
                return Response.status((int)400).entity((Object)("periodType  '" + periodType + "' is not valid")).build();
            }
        }
        KudosPeriod period = kudosPeriodType.getPeriodOfTime(Utils.timeFromSeconds(dateInSeconds));
        KudosList kudosList = new KudosList();
        if (returnSize) {
            long size = this.kudosService.countKudosByPeriodAndReceiver(identityId, period.getStartDateInSeconds(), period.getEndDateInSeconds());
            kudosList.setSize(size);
            if (size == 0L || limit == 0) {
                return Response.ok((Object)kudosList).build();
            }
        }
        List<Kudos> kudos = this.kudosService.getKudosByPeriodAndReceiver(identityId, period.getStartDateInSeconds(), period.getEndDateInSeconds(), this.getLimit(limit));
        kudosList.setKudos(kudos);
        return Response.ok((Object)kudosList).build();
    }

    @Path(value="{identityId}/sent")
    @GET
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @ApiOperation(value="Retrieve the list of sent Kudos for a user in a selected period", httpMethod="GET", response=Response.class, produces="application/json", notes="returns list of Kudos")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=400, message="Invalid query input"), @ApiResponse(code=500, message="Internal server error")})
    public Response getSentKudosByPeriod(@ApiParam(value="User or space identity technical id", required=true) @PathParam(value="identityId") long identityId, @ApiParam(value="Date in the middle of a period defined using a timestamp in seconds", required=false) @QueryParam(value="dateInSeconds") long dateInSeconds, @ApiParam(value="Period type, can be: WEEK, MONTH, QUARTER, SEMESTER and YEAR. Default is the same as configured period", required=false) @QueryParam(value="periodType") String periodType, @ApiParam(value="Limit of kudos to retrieve, if equal to 0, no kudos will be retrieved", required=false) @QueryParam(value="limit") int limit, @ApiParam(value="Whether return size of sent kudos, default = false", required=false) @QueryParam(value="returnSize") boolean returnSize) {
        if (identityId <= 0L) {
            return Response.status((int)400).entity((Object)"identityId is mandatory").build();
        }
        if (dateInSeconds < 0L) {
            return Response.status((int)400).entity((Object)"dateInSeconds parameter should be a positive number").build();
        }
        if (limit < 0) {
            return Response.status((int)400).entity((Object)"limit parameter should be a positive number").build();
        }
        if (!returnSize && limit == 0) {
            return Response.status((int)400).entity((Object)"you should whether use 'limit' to get a list of kudos or 'returnSize' to return the size").build();
        }
        Identity identity = this.identityManager.getIdentity(String.valueOf(identityId), true);
        if (identity == null) {
            return Response.status((int)400).entity((Object)("Can't find identity with id " + identityId)).build();
        }
        if (dateInSeconds == 0L) {
            dateInSeconds = System.currentTimeMillis() / 1000L;
        }
        KudosPeriodType kudosPeriodType = null;
        if (StringUtils.isBlank((String)periodType)) {
            kudosPeriodType = this.kudosService.getDefaultKudosPeriodType();
        } else {
            try {
                kudosPeriodType = KudosPeriodType.valueOf(periodType.toUpperCase());
            }
            catch (Exception e) {
                return Response.status((int)400).entity((Object)("periodType  '" + periodType + "' is not valid")).build();
            }
        }
        KudosPeriod period = kudosPeriodType.getPeriodOfTime(Utils.timeFromSeconds(dateInSeconds));
        KudosList kudosList = new KudosList();
        if (returnSize) {
            long size = this.kudosService.countKudosByPeriodAndSender(identityId, period.getStartDateInSeconds(), period.getEndDateInSeconds());
            kudosList.setSize(size);
            if (size == 0L || limit == 0) {
                return Response.ok((Object)kudosList).build();
            }
        }
        List<Kudos> kudos = this.kudosService.getKudosByPeriodAndSender(identityId, period.getStartDateInSeconds(), period.getEndDateInSeconds(), this.getLimit(limit));
        kudosList.setKudos(kudos);
        return Response.ok((Object)kudosList).build();
    }

    @POST
    @Consumes(value={"application/json"})
    @RolesAllowed(value={"users"})
    @ApiOperation(value="Creates new Kudos", httpMethod="POST", response=Response.class, consumes="application/json", notes="returns empty response")
    @ApiResponses(value={@ApiResponse(code=204, message="Request fulfilled"), @ApiResponse(code=400, message="Invalid query input"), @ApiResponse(code=403, message="Unauthorized operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response createKudos(@ApiParam(value="Kudos object to create", required=true) Kudos kudos) {
        if (kudos == null) {
            LOG.warn((Object)"Bad request sent to server with empty kudos");
            return Response.status((int)400).build();
        }
        if (StringUtils.isBlank((String)kudos.getReceiverId()) || StringUtils.isBlank((String)kudos.getReceiverType())) {
            LOG.warn((Object)"Bad request sent to server with empty 'receiver id or type'");
            return Response.status((int)400).build();
        }
        if (StringUtils.isNotBlank((String)kudos.getSenderId())) {
            LOG.warn((Object)"Bad request sent to server with a preset 'sender'");
            return Response.status((int)400).build();
        }
        if (StringUtils.isBlank((String)kudos.getEntityId()) || StringUtils.isBlank((String)kudos.getEntityType())) {
            LOG.warn((Object)"Bad request sent to server with empty 'attached entity id or type'");
            return Response.status((int)400).build();
        }
        try {
            kudos.setSenderId(Utils.getCurrentUserId());
            this.kudosService.createKudos(kudos, Utils.getCurrentUserId());
            return Response.noContent().build();
        }
        catch (Exception e) {
            LOG.warn("Error saving kudos: {}", new Object[]{kudos, e});
            return Response.serverError().build();
        }
    }

    @Path(value="period")
    @GET
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @ApiOperation(value="Get Kudos period of time by computing it using period type and a selected date", httpMethod="GET", response=Response.class, produces="application/json", notes="returns Kudos period object")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=400, message="Invalid query input"), @ApiResponse(code=403, message="Unauthorized operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response getPeriodDates(@ApiParam(value="Period type, can be: WEEK, MONTH, QUARTER, SEMESTER and YEAR. Default is the same as configured period", required=false) @QueryParam(value="periodType") String periodType, @ApiParam(value="Date in the middle of a period defined using a timestamp in seconds", required=false) @QueryParam(value="dateInSeconds") long dateInSeconds) {
        if (dateInSeconds == 0L) {
            LOG.warn((Object)"Bad request sent to server with empty 'dateInSeconds' parameter");
            return Response.status((int)400).build();
        }
        if (StringUtils.isBlank((String)periodType)) {
            LOG.warn((Object)"Bad request sent to server with empty 'periodType' parameter");
            return Response.status((int)400).build();
        }
        try {
            KudosPeriodType kudosPeriodType = KudosPeriodType.valueOf(periodType);
            KudosPeriod kudosPeriod = kudosPeriodType.getPeriodOfTime(Utils.timeFromSeconds(dateInSeconds));
            return Response.ok((Object)kudosPeriod.toString()).build();
        }
        catch (Exception e) {
            LOG.warn("Error getting period dates of type {} and date {}", new Object[]{periodType, dateInSeconds, e});
            return Response.serverError().build();
        }
    }

    private int getLimit(int limit) {
        if (limit <= 0) {
            limit = 1000;
        }
        return limit;
    }
}

