/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.webui.profile.settings;

import java.io.IOException;
import org.exoplatform.container.component.BaseComponentPlugin;
import org.exoplatform.container.configuration.ConfigurationException;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.social.core.profile.settings.IMType;
import org.exoplatform.social.core.profile.settings.UserProfileSettingsService;
import org.exoplatform.webui.application.WebuiRequestContext;

public abstract class UIIMControlRenderer
extends BaseComponentPlugin {
    public static final String IM_TYPE_ID = "im-type-id";
    protected final IMType imType;

    protected static String readTypeID(InitParams initParams) throws ConfigurationException {
        if (initParams != null) {
            String id;
            ValueParam v = initParams.getValueParam(IM_TYPE_ID);
            if (v != null && (id = v.getValue()) != null && (id = id.trim()).length() > 0) {
                return id;
            }
            throw new ConfigurationException("Field required: im-type-id");
        }
        throw new ConfigurationException("init-params required in renderer configuration");
    }

    protected static IMType findIMType(String imtId, UserProfileSettingsService settingsService) throws ConfigurationException {
        IMType imt = settingsService.getIMType(imtId);
        if (imt != null) {
            return imt;
        }
        throw new ConfigurationException("No such IM type: " + imtId);
    }

    protected UIIMControlRenderer(UserProfileSettingsService settingsService, InitParams initParams) throws ConfigurationException {
        this(UIIMControlRenderer.findIMType(UIIMControlRenderer.readTypeID(initParams), settingsService));
    }

    public UIIMControlRenderer(IMType imtype) {
        this.imType = imtype;
    }

    public IMType getType() {
        return this.imType;
    }

    public abstract void render(String var1, WebuiRequestContext var2) throws IOException, Exception;
}

