/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.security;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.PasswordEncrypter;

public class DigestPasswordEncrypter
implements PasswordEncrypter {
    private static final Log LOG = ExoLogger.getLogger((String)"exo.core.component.security.core.DigestPasswordEncrypter");
    private final int HASH_HEX_LENGTH = 32;
    private final Map<String, String> context;
    private final String username;

    public DigestPasswordEncrypter(String username, Map<String, String> context) {
        this.context = context;
        this.username = username;
    }

    private String convertToHex(byte[] bin) {
        StringBuffer tmpStr = new StringBuffer(32);
        for (int i = 0; i < 16; ++i) {
            int digit = bin[i] >> 4 & 0xF;
            tmpStr.append(Integer.toHexString(digit));
            digit = bin[i] & 0xF;
            tmpStr.append(Integer.toHexString(digit));
        }
        return tmpStr.toString();
    }

    @Override
    public byte[] encrypt(byte[] plainPassword) {
        String nc = this.context.get("nc");
        String a2 = this.context.get("md5a2");
        String uri = this.context.get("uri");
        String qop = this.context.get("qop");
        String nonce = this.context.get("nonce");
        String realm = this.context.get("realmName");
        String cnonce = this.context.get("cnonce");
        String entity = this.context.get("entity");
        String method = this.context.get("method");
        if (realm == null) {
            realm = this.context.get("realm");
        }
        if (a2 == null) {
            a2 = this.context.get("a2hash");
        }
        MessageDigest md = null;
        try {
            md = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Could not find any MessageDigestSpi implementation for MD5.", e);
        }
        String a1 = this.username + ":" + realm + ":" + new String(plainPassword);
        md.update(a1.getBytes());
        a1 = this.convertToHex(md.digest());
        if (a2 == null) {
            if (qop.equals("auth")) {
                md.update((method + ":" + uri).getBytes());
                a2 = this.convertToHex(md.digest());
            } else if (qop.equals("auth-int")) {
                md.update((method + ":" + uri + ":" + this.convertToHex(entity.getBytes())).getBytes());
                a2 = this.convertToHex(md.digest());
            }
        }
        String digest = a1 + ":" + nonce + ":" + nc + ":" + cnonce + ":" + qop + ":" + a2;
        md.update(digest.getBytes());
        return this.convertToHex(md.digest()).getBytes();
    }
}

