/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hslf.record;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.poi.ddf.DefaultEscherRecordFactory;
import org.apache.poi.ddf.EscherBoolProperty;
import org.apache.poi.ddf.EscherContainerRecord;
import org.apache.poi.ddf.EscherDgRecord;
import org.apache.poi.ddf.EscherOptRecord;
import org.apache.poi.ddf.EscherProperty;
import org.apache.poi.ddf.EscherRGBProperty;
import org.apache.poi.ddf.EscherRecord;
import org.apache.poi.ddf.EscherRecordFactory;
import org.apache.poi.ddf.EscherSimpleProperty;
import org.apache.poi.ddf.EscherSpRecord;
import org.apache.poi.ddf.EscherSpgrRecord;
import org.apache.poi.ddf.EscherTextboxRecord;
import org.apache.poi.ddf.UnknownEscherRecord;
import org.apache.poi.hslf.record.BinaryTagDataBlob;
import org.apache.poi.hslf.record.CString;
import org.apache.poi.hslf.record.EscherTextboxWrapper;
import org.apache.poi.hslf.record.HSLFEscherRecordFactory;
import org.apache.poi.hslf.record.Record;
import org.apache.poi.hslf.record.RecordAtom;
import org.apache.poi.hslf.record.RecordTypes;
import org.apache.poi.hslf.record.StyleTextProp9Atom;
import org.apache.poi.sl.usermodel.ShapeType;
import org.apache.poi.util.LittleEndian;

public final class PPDrawing
extends RecordAtom {
    private byte[] _header = new byte[8];
    private long _type;
    private EscherRecord[] childRecords;
    private EscherTextboxWrapper[] textboxWrappers;
    private EscherDgRecord dg;

    public EscherRecord[] getEscherRecords() {
        return this.childRecords;
    }

    public EscherTextboxWrapper[] getTextboxWrappers() {
        return this.textboxWrappers;
    }

    protected PPDrawing(byte[] source, int start, int len) {
        System.arraycopy(source, start, this._header, 0, 8);
        this._type = LittleEndian.getUShort((byte[])this._header, (int)2);
        byte[] contents = new byte[len];
        System.arraycopy(source, start, contents, 0, len);
        HSLFEscherRecordFactory erf = new HSLFEscherRecordFactory();
        ArrayList<EscherRecord> escherChildren = new ArrayList<EscherRecord>();
        this.findEscherChildren(erf, contents, 8, len - 8, escherChildren);
        this.childRecords = escherChildren.toArray(new EscherRecord[escherChildren.size()]);
        if (1 == this.childRecords.length && -4094 == this.childRecords[0].getRecordId() && this.childRecords[0] instanceof EscherContainerRecord) {
            this.textboxWrappers = this.findInDgContainer((EscherContainerRecord)this.childRecords[0]);
        } else {
            ArrayList<EscherTextboxWrapper> textboxes = new ArrayList<EscherTextboxWrapper>();
            this.findEscherTextboxRecord(this.childRecords, textboxes);
            this.textboxWrappers = textboxes.toArray(new EscherTextboxWrapper[textboxes.size()]);
        }
    }

    private EscherTextboxWrapper[] findInDgContainer(EscherContainerRecord dgContainer) {
        EscherContainerRecord[] spContainers;
        LinkedList<EscherTextboxWrapper> found = new LinkedList<EscherTextboxWrapper>();
        EscherContainerRecord spgrContainer = this.findFirstEscherContainerRecordOfType((short)-4093, dgContainer);
        for (EscherContainerRecord spContainer : spContainers = this.findAllEscherContainerRecordOfType((short)-4092, spgrContainer)) {
            StyleTextProp9Atom nineAtom = this.findInSpContainer(spContainer);
            EscherSpRecord sp = (EscherSpRecord)this.findFirstEscherRecordOfType((short)-4086, spContainer);
            EscherTextboxRecord clientTextbox = (EscherTextboxRecord)this.findFirstEscherRecordOfType((short)-4083, spContainer);
            if (null == clientTextbox) continue;
            EscherTextboxWrapper w = new EscherTextboxWrapper(clientTextbox);
            w.setStyleTextProp9Atom(nineAtom);
            if (null != sp) {
                w.setShapeId(sp.getShapeId());
            }
            found.add(w);
        }
        return found.toArray(new EscherTextboxWrapper[found.size()]);
    }

    private StyleTextProp9Atom findInSpContainer(EscherContainerRecord spContainer) {
        EscherContainerRecord clientData = this.findFirstEscherContainerRecordOfType((short)-4079, spContainer);
        if (null == clientData) {
            return null;
        }
        EscherContainerRecord progTagsContainer = this.findFirstEscherContainerRecordOfType((short)5000, clientData);
        if (null == progTagsContainer) {
            return null;
        }
        EscherContainerRecord progBinaryTag = this.findFirstEscherContainerRecordOfType((short)5002, progTagsContainer);
        if (null == progBinaryTag) {
            return null;
        }
        int size = progBinaryTag.getChildRecords().size();
        if (2 != size) {
            return null;
        }
        Record r0 = this.buildFromUnknownEscherRecord((UnknownEscherRecord)progBinaryTag.getChild(0));
        Record r1 = this.buildFromUnknownEscherRecord((UnknownEscherRecord)progBinaryTag.getChild(1));
        if (!(r0 instanceof CString)) {
            return null;
        }
        if (!"___PPT9".equals(((CString)r0).getText())) {
            return null;
        }
        if (!(r1 instanceof BinaryTagDataBlob)) {
            return null;
        }
        BinaryTagDataBlob blob = (BinaryTagDataBlob)r1;
        if (1 != blob.getChildRecords().length) {
            return null;
        }
        return (StyleTextProp9Atom)blob.findFirstOfType(RecordTypes.StyleTextProp9Atom.typeID);
    }

    public PPDrawing() {
        LittleEndian.putUShort((byte[])this._header, (int)0, (int)15);
        LittleEndian.putUShort((byte[])this._header, (int)2, (int)RecordTypes.PPDrawing.typeID);
        LittleEndian.putInt((byte[])this._header, (int)4, (int)0);
        this.textboxWrappers = new EscherTextboxWrapper[0];
        this.create();
    }

    private void findEscherChildren(DefaultEscherRecordFactory erf, byte[] source, int startPos, int lenToGo, List<EscherRecord> found) {
        int escherBytes = LittleEndian.getInt((byte[])source, (int)(startPos + 4)) + 8;
        EscherRecord r = erf.createRecord(source, startPos);
        r.fillFields(source, startPos, (EscherRecordFactory)erf);
        found.add(r);
        int size = r.getRecordSize();
        if (size < 8) {
            logger.log(5, new Object[]{"Hit short DDF record at " + startPos + " - " + size});
        }
        if (size != escherBytes) {
            logger.log(5, new Object[]{"Record length=" + escherBytes + " but getRecordSize() returned " + r.getRecordSize() + "; record: " + r.getClass()});
            size = escherBytes;
        }
        startPos += size;
        if ((lenToGo -= size) >= 8) {
            this.findEscherChildren(erf, source, startPos, lenToGo, found);
        }
    }

    private void findEscherTextboxRecord(EscherRecord[] toSearch, List<EscherTextboxWrapper> found) {
        block0: for (int i = 0; i < toSearch.length; ++i) {
            if (toSearch[i] instanceof EscherTextboxRecord) {
                EscherTextboxRecord tbr = (EscherTextboxRecord)toSearch[i];
                EscherTextboxWrapper w = new EscherTextboxWrapper(tbr);
                found.add(w);
                for (int j = i; j >= 0; --j) {
                    if (!(toSearch[j] instanceof EscherSpRecord)) continue;
                    EscherSpRecord sp = (EscherSpRecord)toSearch[j];
                    w.setShapeId(sp.getShapeId());
                    continue block0;
                }
                continue;
            }
            if (!toSearch[i].isContainerRecord()) continue;
            List childrenL = toSearch[i].getChildRecords();
            EscherRecord[] children = new EscherRecord[childrenL.size()];
            childrenL.toArray(children);
            this.findEscherTextboxRecord(children, found);
        }
    }

    @Override
    public long getRecordType() {
        return this._type;
    }

    @Override
    public Record[] getChildRecords() {
        return null;
    }

    @Override
    public void writeOut(OutputStream out) throws IOException {
        for (EscherTextboxWrapper w : this.textboxWrappers) {
            w.writeOut(null);
        }
        int newSize = 0;
        for (EscherRecord er : this.childRecords) {
            newSize += er.getRecordSize();
        }
        LittleEndian.putInt((byte[])this._header, (int)4, (int)newSize);
        out.write(this._header);
        byte[] b = new byte[newSize];
        int done = 0;
        for (int i = 0; i < this.childRecords.length; ++i) {
            int written = this.childRecords[i].serialize(done, b);
            done += written;
        }
        out.write(b);
    }

    private void create() {
        EscherContainerRecord dgContainer = new EscherContainerRecord();
        dgContainer.setRecordId((short)-4094);
        dgContainer.setOptions((short)15);
        EscherDgRecord dg = new EscherDgRecord();
        dg.setOptions((short)16);
        dg.setNumShapes(1);
        dgContainer.addChildRecord((EscherRecord)dg);
        EscherContainerRecord spgrContainer = new EscherContainerRecord();
        spgrContainer.setOptions((short)15);
        spgrContainer.setRecordId((short)-4093);
        EscherContainerRecord spContainer = new EscherContainerRecord();
        spContainer.setOptions((short)15);
        spContainer.setRecordId((short)-4092);
        EscherSpgrRecord spgr = new EscherSpgrRecord();
        spgr.setOptions((short)1);
        spContainer.addChildRecord((EscherRecord)spgr);
        EscherSpRecord sp = new EscherSpRecord();
        sp.setOptions((short)((ShapeType.NOT_PRIMITIVE.nativeId << 4) + 2));
        sp.setFlags(5);
        spContainer.addChildRecord((EscherRecord)sp);
        spgrContainer.addChildRecord((EscherRecord)spContainer);
        dgContainer.addChildRecord((EscherRecord)spgrContainer);
        spContainer = new EscherContainerRecord();
        spContainer.setOptions((short)15);
        spContainer.setRecordId((short)-4092);
        sp = new EscherSpRecord();
        sp.setOptions((short)((ShapeType.RECT.nativeId << 4) + 2));
        sp.setFlags(3072);
        spContainer.addChildRecord((EscherRecord)sp);
        EscherOptRecord opt = new EscherOptRecord();
        opt.setRecordId((short)-4085);
        opt.addEscherProperty((EscherProperty)new EscherRGBProperty(385, 0x8000000));
        opt.addEscherProperty((EscherProperty)new EscherRGBProperty(387, 0x8000005));
        opt.addEscherProperty((EscherProperty)new EscherSimpleProperty(403, 10064750));
        opt.addEscherProperty((EscherProperty)new EscherSimpleProperty(404, 7778750));
        opt.addEscherProperty((EscherProperty)new EscherBoolProperty(447, 0x120012));
        opt.addEscherProperty((EscherProperty)new EscherBoolProperty(511, 524288));
        opt.addEscherProperty((EscherProperty)new EscherSimpleProperty(772, 9));
        opt.addEscherProperty((EscherProperty)new EscherSimpleProperty(831, 65537));
        spContainer.addChildRecord((EscherRecord)opt);
        dgContainer.addChildRecord((EscherRecord)spContainer);
        this.childRecords = new EscherRecord[]{dgContainer};
    }

    public void addTextboxWrapper(EscherTextboxWrapper txtbox) {
        EscherTextboxWrapper[] tw = new EscherTextboxWrapper[this.textboxWrappers.length + 1];
        System.arraycopy(this.textboxWrappers, 0, tw, 0, this.textboxWrappers.length);
        tw[this.textboxWrappers.length] = txtbox;
        this.textboxWrappers = tw;
    }

    public EscherDgRecord getEscherDgRecord() {
        if (this.dg == null) {
            EscherContainerRecord dgContainer = (EscherContainerRecord)this.childRecords[0];
            Iterator it = dgContainer.getChildIterator();
            while (it.hasNext()) {
                EscherRecord r = (EscherRecord)it.next();
                if (!(r instanceof EscherDgRecord)) continue;
                this.dg = (EscherDgRecord)r;
                break;
            }
        }
        return this.dg;
    }

    protected EscherContainerRecord findFirstEscherContainerRecordOfType(short type, EscherContainerRecord parent) {
        if (null == parent) {
            return null;
        }
        List children = parent.getChildContainers();
        for (EscherContainerRecord child : children) {
            if (type != child.getRecordId()) continue;
            return child;
        }
        return null;
    }

    protected EscherRecord findFirstEscherRecordOfType(short type, EscherContainerRecord parent) {
        if (null == parent) {
            return null;
        }
        List children = parent.getChildRecords();
        for (EscherRecord child : children) {
            if (type != child.getRecordId()) continue;
            return child;
        }
        return null;
    }

    protected EscherContainerRecord[] findAllEscherContainerRecordOfType(short type, EscherContainerRecord parent) {
        if (null == parent) {
            return new EscherContainerRecord[0];
        }
        List children = parent.getChildContainers();
        LinkedList<EscherContainerRecord> result = new LinkedList<EscherContainerRecord>();
        for (EscherContainerRecord child : children) {
            if (type != child.getRecordId()) continue;
            result.add(child);
        }
        return result.toArray(new EscherContainerRecord[result.size()]);
    }

    protected Record buildFromUnknownEscherRecord(UnknownEscherRecord unknown) {
        byte[] bingo = unknown.getData();
        byte[] restoredRecord = new byte[8 + bingo.length];
        System.arraycopy(bingo, 0, restoredRecord, 8, bingo.length);
        short recordVersion = unknown.getVersion();
        short recordId = unknown.getRecordId();
        int recordLength = unknown.getRecordSize();
        LittleEndian.putShort((byte[])restoredRecord, (int)0, (short)recordVersion);
        LittleEndian.putShort((byte[])restoredRecord, (int)2, (short)recordId);
        LittleEndian.putInt((byte[])restoredRecord, (int)4, (int)recordLength);
        return Record.createRecordForType(recordId, restoredRecord, 0, restoredRecord.length);
    }

    public StyleTextProp9Atom[] getNumberedListInfo() {
        EscherContainerRecord[] spContainers;
        LinkedList<StyleTextProp9Atom> result = new LinkedList<StyleTextProp9Atom>();
        EscherContainerRecord dgContainer = (EscherContainerRecord)this.childRecords[0];
        EscherContainerRecord spgrContainer = this.findFirstEscherContainerRecordOfType((short)-4093, dgContainer);
        for (EscherContainerRecord spContainer : spContainers = this.findAllEscherContainerRecordOfType((short)-4092, spgrContainer)) {
            StyleTextProp9Atom prop9 = this.findInSpContainer(spContainer);
            if (prop9 == null) continue;
            result.add(prop9);
        }
        return result.toArray(new StyleTextProp9Atom[result.size()]);
    }
}

