/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j.utils;

import com.github.sommeri.less4j.LessCompiler;
import com.github.sommeri.less4j.LessSource;
import java.net.URI;
import java.util.HashSet;
import java.util.List;

public class ProblemsPrinter {
    private SourceNamePrinter sourceNamePrinter = new AbsoluteSourceNamePrinter();

    public ProblemsPrinter() {
    }

    public ProblemsPrinter(SourceNamePrinter sourceNamePrinter) {
        this.sourceNamePrinter = sourceNamePrinter;
    }

    public String printWarnings(List<LessCompiler.Problem> warnings) {
        StringBuilder builder = new StringBuilder();
        for (LessCompiler.Problem warning : warnings) {
            builder.append(this.toWarning(warning, this.sourceNamePrinter)).append("\n");
        }
        return builder.toString();
    }

    public String printErrors(List<LessCompiler.Problem> errors) {
        StringBuilder builder = new StringBuilder();
        HashSet<String> previousMessages = new HashSet<String>();
        for (LessCompiler.Problem error : errors) {
            String message = this.toError(error, this.sourceNamePrinter);
            if (previousMessages.contains(message)) continue;
            builder.append(message).append("\n");
            previousMessages.add(message);
        }
        return builder.toString();
    }

    private String toWarning(LessCompiler.Problem warning, SourceNamePrinter sourceNamePrinter) {
        return "WARNING " + this.toString(warning, sourceNamePrinter);
    }

    private String toError(LessCompiler.Problem warning, SourceNamePrinter sourceNamePrinter) {
        return "ERROR " + this.toString(warning, sourceNamePrinter);
    }

    private String toString(LessCompiler.Problem problem, SourceNamePrinter sourceNamePrinter) {
        String lineChar;
        String filename = sourceNamePrinter.printSourceName(problem.getSource());
        if (!filename.isEmpty()) {
            filename = filename + " ";
        }
        if (!(lineChar = this.toLineCharReport(problem)).isEmpty()) {
            lineChar = lineChar + " ";
        }
        return filename + lineChar + problem.getMessage();
    }

    private String toLineCharReport(LessCompiler.Problem problem) {
        if (problem.getLine() == -1 || problem.getCharacter() == -1) {
            return "";
        }
        return problem.getLine() + ":" + problem.getCharacter();
    }

    public static class AbsoluteSourceNamePrinter
    implements SourceNamePrinter {
        @Override
        public String printSourceName(LessSource source) {
            if (source == null) {
                return "";
            }
            URI uri = source.getURI();
            return uri == null ? "" : uri.toString();
        }
    }

    public static interface SourceNamePrinter {
        public String printSourceName(LessSource var1);
    }
}

