/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.ispn;

import java.security.PrivilegedExceptionAction;
import java.util.Map;
import javax.transaction.TransactionManager;
import org.exoplatform.commons.utils.SecurityHelper;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.container.util.TemplateConfigurationHelper;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.PropertiesParam;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.services.ispn.Utils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.transaction.TransactionService;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.configuration.parsing.ConfigurationBuilderHolder;
import org.infinispan.configuration.parsing.ParserRegistry;
import org.infinispan.manager.DefaultCacheManager;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.transaction.lookup.TransactionManagerLookup;
import org.picocontainer.Startable;

public class DistributedCacheManager
implements Startable {
    private static final Log LOG = ExoLogger.getLogger((String)"exo.kernel.component.ext.cache.impl.infinispan.v8.DistributedCacheManager");
    private static final String CONFIG_FILE_PARAMETER_NAME = "infinispan-configuration";
    private static final String PARAMS_PARAMETER_NAME = "parameters";
    protected final EmbeddedCacheManager manager;

    public DistributedCacheManager(String configurationFile, Map<String, String> parameters, ConfigurationManager configManager) {
        this.manager = this.init(configurationFile, parameters, configManager, null);
    }

    public DistributedCacheManager(InitParams params, ConfigurationManager configManager) {
        this(params, configManager, null);
    }

    public DistributedCacheManager(InitParams params, ConfigurationManager configManager, TransactionService ts) {
        String result;
        ValueParam vp;
        if (params == null || (vp = params.getValueParam(CONFIG_FILE_PARAMETER_NAME)) == null || (result = vp.getValue()) == null || result.isEmpty()) {
            throw new IllegalArgumentException("The parameter 'infinispan-configuration' must be set");
        }
        PropertiesParam pp = params.getPropertiesParam(PARAMS_PARAMETER_NAME);
        this.manager = this.init(result, (Map<String, String>)(pp == null ? null : pp.getProperties()), configManager, ts == null ? null : ts.getTransactionManager());
    }

    private EmbeddedCacheManager init(final String configurationFile, final Map<String, String> parameters, final ConfigurationManager configManager, final TransactionManager tm) {
        try {
            if (configurationFile == null || configurationFile.isEmpty()) {
                throw new IllegalArgumentException("The parameter 'configurationFile' must be set");
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("The configuration file of the DistributedCacheManager will be loaded from " + configurationFile));
            }
            final TemplateConfigurationHelper helper = new TemplateConfigurationHelper(new String[]{"^.*"}, new String[0], configManager);
            if (LOG.isDebugEnabled() && parameters != null && !parameters.isEmpty()) {
                LOG.debug((Object)("The parameters to use while processing the configuration file are " + parameters));
            }
            return (EmbeddedCacheManager)SecurityHelper.doPrivilegedIOExceptionAction((PrivilegedExceptionAction)new PrivilegedExceptionAction<EmbeddedCacheManager>(){

                @Override
                public EmbeddedCacheManager run() throws Exception {
                    ParserRegistry parser = new ParserRegistry(Thread.currentThread().getContextClassLoader());
                    ConfigurationBuilderHolder holder = parser.parse(helper.fillTemplate(configurationFile, parameters));
                    GlobalConfigurationBuilder configBuilder = holder.getGlobalConfigurationBuilder();
                    Utils.loadJGroupsConfig(configManager, configBuilder.build(), configBuilder);
                    DefaultCacheManager manager = new DefaultCacheManager(configBuilder.build(), holder.getDefaultConfigurationBuilder().build());
                    TransactionManagerLookup tml = new TransactionManagerLookup(){

                        public TransactionManager getTransactionManager() throws Exception {
                            return tm;
                        }
                    };
                    for (Map.Entry entry : holder.getNamedConfigurationBuilders().entrySet()) {
                        ConfigurationBuilder b = (ConfigurationBuilder)entry.getValue();
                        if (tm != null) {
                            b.transaction().transactionManagerLookup(tml);
                        }
                        manager.defineConfiguration((String)entry.getKey(), b.build());
                    }
                    for (String cacheName : manager.getCacheNames()) {
                        manager.getCache(cacheName);
                    }
                    return manager;
                }
            });
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not initialize the cache manager corresponding to the configuration file " + configurationFile, e);
        }
    }

    public <K, V> Cache<K, V> getCache(String cacheName) {
        Cache cache = this.manager.getCache(cacheName);
        if (cache == null) {
            throw new IllegalArgumentException("The expected cache named '" + cacheName + "' has not been defined in the configuration of infinispan as named cache.");
        }
        return cache;
    }

    public void start() {
    }

    public void stop() {
        this.manager.stop();
    }
}

