/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.service.rest;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.NotificationMessageUtils;
import org.exoplatform.commons.api.notification.channel.AbstractChannel;
import org.exoplatform.commons.api.notification.channel.template.AbstractTemplateBuilder;
import org.exoplatform.commons.api.notification.model.ChannelKey;
import org.exoplatform.commons.api.notification.model.MessageInfo;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.api.notification.model.PluginKey;
import org.exoplatform.commons.api.notification.model.WebNotificationFilter;
import org.exoplatform.commons.api.notification.plugin.BaseNotificationPlugin;
import org.exoplatform.commons.api.notification.service.storage.WebNotificationStorage;
import org.exoplatform.commons.notification.impl.NotificationContextImpl;
import org.exoplatform.commons.notification.net.WebNotificationSender;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.manager.RelationshipManager;
import org.exoplatform.social.core.relationship.model.Relationship;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.service.rest.RestChecker;
import org.exoplatform.social.service.rest.Util;
import org.exoplatform.web.security.csrf.ExoCSRFCheck;

@Path(value="social/intranet-notification")
public class IntranetNotificationRestService
implements ResourceContainer {
    private static final Log LOG = ExoLogger.getLogger(IntranetNotificationRestService.class);
    private IdentityManager identityManager;
    private RelationshipManager relationshipManager;
    private SpaceService spaceService;
    private WebNotificationStorage webNotificationStorage;
    public static final String MESSAGE_JSON_FILE_NAME = "message.json";

    public IntranetNotificationRestService(IdentityManager identityManager, RelationshipManager relationshipManager, SpaceService spaceService, WebNotificationStorage webNotificationStorage) {
        this.identityManager = identityManager;
        this.relationshipManager = relationshipManager;
        this.spaceService = spaceService;
        this.webNotificationStorage = webNotificationStorage;
    }

    @GET
    @RolesAllowed(value={"users"})
    @ExoCSRFCheck
    @Path(value="confirmInvitationToConnect/{senderId}/{receiverId}/{notificationId}/message.{format}")
    public Response confirmInvitationToConnect(@Context UriInfo uriInfo, @PathParam(value="senderId") String senderId, @PathParam(value="receiverId") String receiverId, @PathParam(value="notificationId") String notificationId, @PathParam(value="format") String format) throws Exception {
        RestChecker.checkAuthenticatedUserPermission(receiverId);
        Identity sender = this.identityManager.getOrCreateIdentity("organization", senderId, true);
        Identity receiver = this.identityManager.getOrCreateIdentity("organization", receiverId, true);
        if (sender == null || receiver == null) {
            throw new WebApplicationException(Response.Status.BAD_REQUEST);
        }
        Relationship invitation = this.relationshipManager.get(sender, receiver);
        if (invitation == null || !invitation.getStatus().equals((Object)Relationship.Type.PENDING) || !invitation.isReceiver(receiver)) {
            throw new WebApplicationException(Response.Status.FORBIDDEN);
        }
        String[] mediaTypes = new String[]{"json", "xml"};
        MediaType mediaType = Util.getMediaType(format, mediaTypes);
        NotificationInfo info = this.webNotificationStorage.get(notificationId);
        info.key(new PluginKey("RelationshipReceivedRequestPlugin"));
        info.setFrom(senderId);
        info.setTo(receiverId);
        HashMap<String, String> ownerParameter = new HashMap<String, String>();
        ownerParameter.put("sender", senderId);
        ownerParameter.put("status", "accepted");
        info.setOwnerParameter(ownerParameter);
        MessageInfo messageInfo = this.sendBackNotif(info);
        if (messageInfo == null) {
            throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
        }
        this.relationshipManager.confirm(sender, receiver);
        return Util.getResponse(messageInfo, uriInfo, mediaType, Response.Status.OK);
    }

    @GET
    @RolesAllowed(value={"users"})
    @ExoCSRFCheck
    @Path(value="ignoreInvitationToConnect/{senderId}/{receiverId}/{notificationId}/message.{format}")
    public Response ignoreInvitationToConnect(@Context UriInfo uriInfo, @PathParam(value="senderId") String senderId, @PathParam(value="receiverId") String receiverId, @PathParam(value="notificationId") String notificationId, @PathParam(value="format") String format) throws Exception {
        RestChecker.checkAuthenticatedUserPermission(receiverId);
        String[] mediaTypes = new String[]{"json", "xml"};
        MediaType mediaType = Util.getMediaType(format, mediaTypes);
        Identity sender = this.identityManager.getOrCreateIdentity("organization", senderId, true);
        Identity receiver = this.identityManager.getOrCreateIdentity("organization", receiverId, true);
        if (sender == null || receiver == null) {
            throw new WebApplicationException(Response.Status.BAD_REQUEST);
        }
        this.relationshipManager.deny(sender, receiver);
        this.webNotificationStorage.remove(notificationId);
        return Util.getResponse(this.getUserWebNotification(receiverId), uriInfo, mediaType, Response.Status.OK);
    }

    @GET
    @RolesAllowed(value={"users"})
    @ExoCSRFCheck
    @Path(value="acceptInvitationToJoinSpace/{spaceId}/{userId}/{notificationId}/message.{format}")
    public Response acceptInvitationToJoinSpace(@Context UriInfo uriInfo, @PathParam(value="spaceId") String spaceId, @PathParam(value="userId") String userId, @PathParam(value="notificationId") String notificationId, @PathParam(value="format") String format) throws Exception {
        RestChecker.checkAuthenticatedUserPermission(userId);
        Space space = this.spaceService.getSpaceById(spaceId);
        if (space == null) {
            throw new WebApplicationException(Response.Status.BAD_REQUEST);
        }
        List<String> invitedUsers = Arrays.asList(space.getInvitedUsers());
        if (!invitedUsers.contains(userId)) {
            throw new WebApplicationException(Response.Status.FORBIDDEN);
        }
        String[] mediaTypes = new String[]{"json", "xml"};
        MediaType mediaType = Util.getMediaType(format, mediaTypes);
        NotificationInfo info = this.webNotificationStorage.get(notificationId);
        info.setTo(userId);
        info.key(new PluginKey("SpaceInvitationPlugin"));
        HashMap<String, String> ownerParameter = new HashMap<String, String>();
        ownerParameter.put("spaceId", spaceId);
        ownerParameter.put("status", "accepted");
        info.setOwnerParameter(ownerParameter);
        MessageInfo messageInfo = this.sendBackNotif(info);
        if (messageInfo == null) {
            throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
        }
        this.spaceService.addMember(space, userId);
        return Util.getResponse(messageInfo, uriInfo, mediaType, Response.Status.OK);
    }

    @GET
    @RolesAllowed(value={"users"})
    @ExoCSRFCheck
    @Path(value="ignoreInvitationToJoinSpace/{spaceId}/{userId}/{notificationId}/message.{format}")
    public Response ignoreInvitationToJoinSpace(@Context UriInfo uriInfo, @PathParam(value="spaceId") String spaceId, @PathParam(value="userId") String userId, @PathParam(value="notificationId") String notificationId, @PathParam(value="format") String format) throws Exception {
        RestChecker.checkAuthenticatedUserPermission(userId);
        String[] mediaTypes = new String[]{"json", "xml"};
        MediaType mediaType = Util.getMediaType(format, mediaTypes);
        Space space = this.spaceService.getSpaceById(spaceId);
        if (space == null) {
            throw new WebApplicationException(Response.Status.BAD_REQUEST);
        }
        this.spaceService.removeInvitedUser(space, userId);
        this.webNotificationStorage.remove(notificationId);
        return Util.getResponse(this.getUserWebNotification(userId), uriInfo, mediaType, Response.Status.OK);
    }

    @GET
    @RolesAllowed(value={"users"})
    @ExoCSRFCheck
    @Path(value="validateRequestToJoinSpace/{spaceId}/{requestUserId}/{currentUserId}/{notificationId}/message.{format}")
    public Response validateRequestToJoinSpace(@Context UriInfo uriInfo, @PathParam(value="spaceId") String spaceId, @PathParam(value="requestUserId") String requestUserId, @PathParam(value="currentUserId") String currentUserId, @PathParam(value="notificationId") String notificationId, @PathParam(value="format") String format) throws Exception {
        RestChecker.checkAuthenticatedUserPermission(currentUserId);
        Space space = this.spaceService.getSpaceById(spaceId);
        if (space == null) {
            throw new WebApplicationException(Response.Status.BAD_REQUEST);
        }
        List<String> managers = Arrays.asList(space.getManagers());
        if (!managers.contains(currentUserId)) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        List<String> pendingUsers = Arrays.asList(space.getPendingUsers());
        if (!pendingUsers.contains(requestUserId)) {
            throw new WebApplicationException(Response.Status.FORBIDDEN);
        }
        String[] mediaTypes = new String[]{"json", "xml"};
        MediaType mediaType = Util.getMediaType(format, mediaTypes);
        NotificationInfo info = this.webNotificationStorage.get(notificationId);
        info.setTo(currentUserId);
        info.key(new PluginKey("RequestJoinSpacePlugin"));
        HashMap<String, String> ownerParameter = new HashMap<String, String>();
        ownerParameter.put("spaceId", spaceId);
        ownerParameter.put("request_from", requestUserId);
        ownerParameter.put("status", "accepted");
        info.setOwnerParameter(ownerParameter);
        MessageInfo messageInfo = this.sendBackNotif(info);
        if (messageInfo == null) {
            throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
        }
        this.spaceService.addMember(space, requestUserId);
        return Util.getResponse(messageInfo, uriInfo, mediaType, Response.Status.OK);
    }

    @GET
    @RolesAllowed(value={"users"})
    @ExoCSRFCheck
    @Path(value="refuseRequestToJoinSpace/{spaceId}/{requestUserId}/{currentUserId}/{notificationId}/message.{format}")
    public Response refuseRequestToJoinSpace(@Context UriInfo uriInfo, @PathParam(value="spaceId") String spaceId, @PathParam(value="requestUserId") String requestUserId, @PathParam(value="currentUserId") String currentUserId, @PathParam(value="notificationId") String notificationId, @PathParam(value="format") String format) throws Exception {
        RestChecker.checkAuthenticatedUserPermission(currentUserId);
        String[] mediaTypes = new String[]{"json", "xml"};
        MediaType mediaType = Util.getMediaType(format, mediaTypes);
        Space space = this.spaceService.getSpaceById(spaceId);
        if (space == null) {
            throw new WebApplicationException(Response.Status.BAD_REQUEST);
        }
        this.spaceService.removePendingUser(space, requestUserId);
        this.webNotificationStorage.remove(notificationId);
        return Util.getResponse(this.getUserWebNotification(currentUserId), uriInfo, mediaType, Response.Status.OK);
    }

    private MessageInfo sendBackNotif(NotificationInfo notification) {
        NotificationContext nCtx = NotificationContextImpl.cloneInstance().setNotificationInfo(notification);
        BaseNotificationPlugin plugin = nCtx.getPluginContainer().getPlugin(notification.getKey());
        if (plugin == null) {
            return null;
        }
        try {
            AbstractChannel channel = nCtx.getChannelManager().getChannel(ChannelKey.key((String)"WEB_CHANNEL"));
            AbstractTemplateBuilder builder = channel.getTemplateBuilder(notification.getKey());
            MessageInfo msg = builder.buildMessage(nCtx);
            msg.setMoveTop(false);
            WebNotificationSender.sendJsonMessage((String)notification.getTo(), (MessageInfo)msg);
            notification.setTitle(msg.getBody());
            notification.with(NotificationMessageUtils.SHOW_POPOVER_PROPERTY.getKey(), "true").with(NotificationMessageUtils.READ_PORPERTY.getKey(), "false");
            this.webNotificationStorage.update(notification, false);
            return msg;
        }
        catch (Exception e) {
            LOG.error("Can not send the message to Intranet.", new Object[]{e.getMessage()});
            return null;
        }
    }

    private Map<String, Boolean> getUserWebNotification(String userId) throws Exception {
        HashMap<String, Boolean> data = new HashMap<String, Boolean>();
        List notifications = this.webNotificationStorage.get(new WebNotificationFilter(userId), 0, 1);
        data.put("showViewAll", notifications.size() > 0);
        return data;
    }
}

