/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.mop.jdbc.service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.commons.utils.Safe;
import org.exoplatform.portal.jdbc.entity.ComponentEntity;
import org.exoplatform.portal.jdbc.entity.ContainerEntity;
import org.exoplatform.portal.jdbc.entity.PageEntity;
import org.exoplatform.portal.jdbc.entity.PermissionEntity;
import org.exoplatform.portal.jdbc.entity.SiteEntity;
import org.exoplatform.portal.jdbc.entity.WindowEntity;
import org.exoplatform.portal.mop.QueryResult;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.portal.mop.SiteType;
import org.exoplatform.portal.mop.jdbc.dao.ContainerDAO;
import org.exoplatform.portal.mop.jdbc.dao.PageDAO;
import org.exoplatform.portal.mop.jdbc.dao.PermissionDAO;
import org.exoplatform.portal.mop.jdbc.dao.SiteDAO;
import org.exoplatform.portal.mop.jdbc.dao.WindowDAO;
import org.exoplatform.portal.mop.page.PageContext;
import org.exoplatform.portal.mop.page.PageError;
import org.exoplatform.portal.mop.page.PageKey;
import org.exoplatform.portal.mop.page.PageService;
import org.exoplatform.portal.mop.page.PageServiceException;
import org.exoplatform.portal.mop.page.PageState;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.gatein.api.page.PageQuery;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class PageServiceImpl
implements PageService {
    private static Log LOG = ExoLogger.getExoLogger(PageServiceImpl.class);
    private SiteDAO siteDAO;
    private PageDAO pageDAO;
    private ContainerDAO containerDAO;
    private WindowDAO windowDAO;
    private PermissionDAO permissionDAO;
    private static Log log = ExoLogger.getExoLogger(PageServiceImpl.class);

    public PageServiceImpl(PageDAO pageDAO, ContainerDAO containerDAO, WindowDAO windowDAO, PermissionDAO permissionDAO, SiteDAO siteDAO) throws NullPointerException {
        if (pageDAO == null) {
            throw new NullPointerException("No null persistence allowed");
        }
        this.pageDAO = pageDAO;
        this.windowDAO = windowDAO;
        this.containerDAO = containerDAO;
        this.permissionDAO = permissionDAO;
        this.siteDAO = siteDAO;
    }

    @Override
    public PageContext loadPage(PageKey key) {
        if (key == null) {
            throw new NullPointerException("No null key accepted");
        }
        PageEntity entity = this.pageDAO.findByKey(key);
        if (entity != null) {
            return this.buildPageContext(entity);
        }
        return null;
    }

    @Override
    public List<PageContext> loadPages(SiteKey siteKey) throws NullPointerException, PageServiceException {
        if (siteKey == null) {
            throw new NullPointerException("No null site key accepted");
        }
        QueryResult<PageContext> pages = this.findPages(0, -1, siteKey.getType(), siteKey.getName(), null, null);
        LinkedList<PageContext> list = new LinkedList<PageContext>();
        for (PageContext page : pages) {
            list.add(page);
        }
        return list;
    }

    @Override
    public boolean savePage(PageContext page) {
        if (page == null) {
            throw new NullPointerException();
        }
        PageEntity entity = this.pageDAO.findByKey(page.getKey());
        boolean created = false;
        if (entity == null) {
            entity = this.buildPageEntityContext(null, page);
            this.pageDAO.create(entity);
            created = true;
        } else {
            entity = this.buildPageEntityContext(entity, page);
            this.pageDAO.update(entity);
        }
        this.savePagePermissions(entity.getId(), page);
        return created;
    }

    @Override
    public boolean destroyPage(PageKey key) {
        if (key == null) {
            throw new NullPointerException("No null page argument");
        }
        PageEntity page = this.pageDAO.findByKey(key);
        if (page != null) {
            String pageBody = page.getPageBody();
            JSONArray children = this.parse(pageBody);
            this.deleteChildren(children);
            this.permissionDAO.deletePermissions(PageEntity.class.getName(), page.getId());
            this.pageDAO.delete(page);
            return true;
        }
        SiteEntity site = this.siteDAO.findByKey(key.getSite());
        if (site == null) {
            throw new PageServiceException(PageError.NO_SITE);
        }
        return false;
    }

    private void deleteChildren(JSONArray children) {
        for (Object child : children) {
            JSONObject c = (JSONObject)child;
            Long id = Safe.parseLong((String)c.get((Object)"id").toString());
            ComponentEntity.TYPE t = ComponentEntity.TYPE.valueOf(c.get((Object)"type").toString());
            if (ComponentEntity.TYPE.CONTAINER.equals((Object)t)) {
                ContainerEntity container;
                JSONArray descendants = (JSONArray)c.get((Object)"children");
                if (descendants != null) {
                    this.deleteChildren(descendants);
                }
                if ((container = (ContainerEntity)this.containerDAO.find(id)) == null) continue;
                JSONArray dashboardChilds = this.parse(container.getContainerBody());
                this.deleteChildren(dashboardChilds);
                this.permissionDAO.deletePermissions(ContainerEntity.class.getName(), container.getId());
                this.containerDAO.delete(container);
                continue;
            }
            if (ComponentEntity.TYPE.WINDOW.equals((Object)t)) {
                WindowEntity window = (WindowEntity)this.windowDAO.find(id);
                if (window == null) continue;
                this.permissionDAO.deletePermissions(WindowEntity.class.getName(), window.getId());
                this.windowDAO.delete(window);
                continue;
            }
            throw new IllegalArgumentException("Can't delete child with type: " + (Object)((Object)t));
        }
    }

    @Override
    public PageContext clone(PageKey src, PageKey dst) {
        if (src == null) {
            throw new NullPointerException("No null source accepted");
        }
        if (dst == null) {
            throw new NullPointerException("No null destination accepted");
        }
        PageEntity pageSrc = this.pageDAO.findByKey(src);
        if (pageSrc == null) {
            throw new PageServiceException(PageError.CLONE_NO_SRC_PAGE, "Could not clone non existing page " + src.getName() + " from site of type " + (Object)((Object)src.getSite().getType()) + " with id " + src.getSite().getName());
        }
        PageEntity pageDst = this.pageDAO.findByKey(dst);
        if (pageDst != null) {
            throw new PageServiceException(PageError.CLONE_DST_ALREADY_EXIST, "Could not clone page " + dst.getName() + "to existing page " + (Object)((Object)dst.getSite().getType()) + " with id " + dst.getSite().getName());
        }
        SiteKey siteKey = dst.getSite();
        SiteEntity owner = this.siteDAO.findByKey(siteKey);
        if (owner == null) {
            throw new PageServiceException(PageError.CLONE_NO_DST_SITE, "Could not clone page " + siteKey.getName() + "to non existing site of type " + siteKey.getTypeName() + " with id " + siteKey.getName());
        }
        pageDst = this.buildPageEntityContext(null, this.buildPageContext(pageSrc));
        List<ComponentEntity> children = this.clone(pageSrc.getPageBody());
        pageDst.setChildren(children);
        pageDst.setPageBody(((JSONArray)pageDst.toJSON().get((Object)"children")).toJSONString());
        pageDst.setName(dst.getName());
        pageDst.setOwner(owner);
        this.pageDAO.create(pageDst);
        this.clonePermissions(pageDst.getId(), pageSrc.getId());
        PageContext result = this.buildPageContext(pageDst);
        return result;
    }

    @Override
    public QueryResult<PageContext> findPages(int from, int limit, SiteType siteType, String siteName, String pageName, String pageTitle) {
        PageQuery.Builder builder = new PageQuery.Builder();
        builder.withDisplayName(pageTitle).withSiteType(this.convert(siteType)).withSiteName(StringUtils.trim((String)siteName));
        builder.withPagination(from, limit);
        ListAccess<PageEntity> dataSet = this.pageDAO.findByQuery(builder.build());
        try {
            ArrayList<PageContext> pages = new ArrayList<PageContext>(dataSet.getSize());
            for (PageEntity data : (PageEntity[])dataSet.load(0, dataSet.getSize())) {
                pages.add(this.buildPageContext(data));
            }
            return new QueryResult<PageContext>(from, dataSet.getSize(), pages);
        }
        catch (Exception ex) {
            LOG.error((Object)ex);
            return new QueryResult<PageContext>(from, 0, Collections.emptyList());
        }
    }

    private List<ComponentEntity> clone(String pageBody) {
        LinkedList<ComponentEntity> results = new LinkedList<ComponentEntity>();
        JSONArray children = this.parse(pageBody);
        block4: for (Object child : children) {
            JSONObject c = (JSONObject)child;
            Long id = Safe.parseLong((String)c.get((Object)"id").toString());
            ComponentEntity.TYPE type = ComponentEntity.TYPE.valueOf(c.get((Object)"type").toString());
            switch (type) {
                case CONTAINER: {
                    ContainerEntity srcC = (ContainerEntity)this.containerDAO.find(id);
                    ContainerEntity dstC = this.clone(srcC);
                    JSONArray descendants = this.parse(srcC.getContainerBody());
                    if (descendants.size() > 0) {
                        dstC.setChildren(this.clone(srcC.getContainerBody()));
                    } else {
                        dstC.setChildren(this.clone(((JSONArray)c.get((Object)"children")).toJSONString()));
                    }
                    dstC.setContainerBody(((JSONArray)dstC.toJSON().get((Object)"children")).toJSONString());
                    this.containerDAO.create(dstC);
                    this.clonePermissions(dstC.getId(), srcC.getId());
                    results.add(dstC);
                    continue block4;
                }
                case WINDOW: {
                    WindowEntity srcW = (WindowEntity)this.windowDAO.find(id);
                    WindowEntity dstW = this.clone(srcW);
                    this.windowDAO.create(dstW);
                    this.clonePermissions(dstW.getId(), srcW.getId());
                    results.add(dstW);
                    continue block4;
                }
            }
            throw new IllegalStateException("Can't handle type: " + (Object)((Object)type));
        }
        return results;
    }

    private void clonePermissions(long dstId, long srcId) {
        this.clonePermissions(dstId, srcId, PermissionEntity.TYPE.ACCESS);
        this.clonePermissions(dstId, srcId, PermissionEntity.TYPE.EDIT);
        this.clonePermissions(dstId, srcId, PermissionEntity.TYPE.MOVE_APP);
        this.clonePermissions(dstId, srcId, PermissionEntity.TYPE.MOVE_CONTAINER);
    }

    private void clonePermissions(long dstId, long srcId, PermissionEntity.TYPE type) {
        List<PermissionEntity> permissions = this.permissionDAO.getPermissions(PageEntity.class.getName(), srcId, type);
        if (!permissions.isEmpty()) {
            this.permissionDAO.savePermissions(PageEntity.class.getName(), dstId, type, this.buildPermission(permissions));
        }
    }

    private WindowEntity clone(WindowEntity src) {
        WindowEntity dst = new WindowEntity();
        dst.setAppType(src.getAppType());
        dst.setContentId(src.getContentId());
        dst.setCustomization(src.getCustomization());
        dst.setDescription(src.getDescription());
        dst.setHeight(src.getHeight());
        dst.setIcon(src.getIcon());
        dst.setProperties(src.getProperties());
        dst.setShowApplicationMode(src.isShowApplicationMode());
        dst.setShowApplicationState(src.isShowApplicationState());
        dst.setShowInfoBar(src.isShowInfoBar());
        dst.setTheme(src.getTheme());
        dst.setTitle(src.getTitle());
        dst.setWidth(src.getWidth());
        return dst;
    }

    private JSONArray parse(String body) {
        JSONParser parser = new JSONParser();
        try {
            JSONArray children = (JSONArray)parser.parse(body);
            return children;
        }
        catch (ParseException e) {
            log.error((Object)e);
            throw new IllegalStateException("Can't parse body: " + body);
        }
    }

    private ContainerEntity clone(ContainerEntity src) {
        ContainerEntity dst = new ContainerEntity();
        dst.setDescription(src.getDescription());
        dst.setFactoryId(src.getFactoryId());
        dst.setHeight(src.getHeight());
        dst.setIcon(src.getIcon());
        dst.setName(src.getName());
        dst.setProperties(src.getProperties());
        dst.setTemplate(src.getTemplate());
        dst.setTitle(src.getTitle());
        dst.setWidth(src.getWidth());
        dst.setContainerBody(src.getContainerBody());
        return dst;
    }

    private org.gatein.api.site.SiteType convert(SiteType siteType) {
        if (siteType == null) {
            return null;
        }
        switch (siteType) {
            case GROUP: {
                return org.gatein.api.site.SiteType.SPACE;
            }
            case PORTAL: {
                return org.gatein.api.site.SiteType.SITE;
            }
            case USER: {
                return org.gatein.api.site.SiteType.DASHBOARD;
            }
        }
        return null;
    }

    private PageEntity buildPageEntityContext(PageEntity entity, PageContext page) {
        PageState state;
        if (entity == null) {
            entity = new PageEntity();
        }
        if ((state = page.getState()) != null) {
            entity.setDescription(state.getDescription());
            entity.setDisplayName(state.getDisplayName());
            entity.setFactoryId(state.getFactoryId());
            entity.setShowMaxWindow(state.getShowMaxWindow());
        }
        SiteKey siteKey = page.getKey().getSite();
        entity.setOwner(this.siteDAO.findByKey(siteKey));
        entity.setName(page.getKey().getName());
        return entity;
    }

    private PageContext buildPageContext(PageEntity entity) {
        List<PermissionEntity> access = this.permissionDAO.getPermissions(PageEntity.class.getName(), entity.getId(), PermissionEntity.TYPE.ACCESS);
        List<String> edit = this.buildPermission(this.permissionDAO.getPermissions(PageEntity.class.getName(), entity.getId(), PermissionEntity.TYPE.EDIT));
        List<PermissionEntity> moveApps = this.permissionDAO.getPermissions(PageEntity.class.getName(), entity.getId(), PermissionEntity.TYPE.MOVE_APP);
        List<PermissionEntity> moveConts = this.permissionDAO.getPermissions(PageEntity.class.getName(), entity.getId(), PermissionEntity.TYPE.MOVE_CONTAINER);
        PageState state = new PageState(entity.getDisplayName(), entity.getDescription(), entity.isShowMaxWindow(), entity.getFactoryId(), this.buildPermission(access), edit.isEmpty() ? null : edit.get(0), this.buildPermission(moveApps), this.buildPermission(moveConts));
        SiteKey siteKey = new SiteKey(entity.getOwnerType(), entity.getOwnerId());
        PageKey pageKey = new PageKey(siteKey, entity.getName());
        PageContext context = new PageContext(pageKey, state);
        return context;
    }

    private List<String> buildPermission(List<PermissionEntity> permissions) {
        ArrayList<String> results = new ArrayList<String>();
        if (permissions != null) {
            for (PermissionEntity per : permissions) {
                results.add(per.getPermission());
            }
        }
        return results;
    }

    private void savePagePermissions(long pageId, PageContext page) {
        PageState state = page.getState();
        if (state != null) {
            this.permissionDAO.savePermissions(PageEntity.class.getName(), pageId, PermissionEntity.TYPE.ACCESS, state.getAccessPermissions());
            this.permissionDAO.savePermissions(PageEntity.class.getName(), pageId, PermissionEntity.TYPE.EDIT, Arrays.asList(state.getEditPermission()));
            this.permissionDAO.savePermissions(PageEntity.class.getName(), pageId, PermissionEntity.TYPE.MOVE_APP, state.getMoveAppsPermissions());
            this.permissionDAO.savePermissions(PageEntity.class.getName(), pageId, PermissionEntity.TYPE.MOVE_CONTAINER, state.getMoveContainersPermissions());
        }
    }
}

