/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addons.gamification.upgrade;

import java.util.List;
import java.util.stream.Collectors;
import org.exoplatform.addons.gamification.entities.domain.effective.GamificationActionsHistory;
import org.exoplatform.addons.gamification.service.configuration.BadgeService;
import org.exoplatform.addons.gamification.service.configuration.DomainService;
import org.exoplatform.addons.gamification.service.configuration.RuleService;
import org.exoplatform.addons.gamification.service.dto.configuration.BadgeDTO;
import org.exoplatform.addons.gamification.service.dto.configuration.DomainDTO;
import org.exoplatform.addons.gamification.service.dto.configuration.RuleDTO;
import org.exoplatform.addons.gamification.service.mapper.DomainMapper;
import org.exoplatform.addons.gamification.storage.dao.GamificationHistoryDAO;
import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.commons.api.settings.SettingValue;
import org.exoplatform.commons.api.settings.data.Context;
import org.exoplatform.commons.api.settings.data.Scope;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.picocontainer.Startable;

public class DomainMigrationService
implements Startable {
    private static final Log LOG = ExoLogger.getLogger(DomainMigrationService.class);
    public static final String GAMIFICATION_DATA_VERSION = "gamifictaionDataVertion";
    public static final int DOMAIN_MIGRATION_DATA_VERSION = 1;
    public static final int RULES_EVENT_MIGRATION_DATA_VERSION = 2;
    protected PortalContainer portalContainer;
    protected RuleService ruleService;
    protected DomainService domainService;
    protected BadgeService badgeService;
    protected GamificationHistoryDAO gamificationHistoryDAO;
    protected DomainMapper domainMapper;
    protected SettingService settingService;

    public DomainMigrationService(PortalContainer portalContainer, RuleService ruleService, DomainService domainService, BadgeService badgeService, GamificationHistoryDAO gamificationHistoryDAO, DomainMapper domainMapper, SettingService settingService) {
        this.ruleService = ruleService;
        this.domainService = domainService;
        this.badgeService = badgeService;
        this.gamificationHistoryDAO = gamificationHistoryDAO;
        this.domainMapper = domainMapper;
        this.settingService = settingService;
        this.portalContainer = portalContainer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        long startTime;
        if (this.getDataversion() < 1) {
            DomainDTO domainDTO;
            long l;
            DomainDTO domainDTO2;
            List<String> domains;
            startTime = System.currentTimeMillis();
            long glStartTime = System.currentTimeMillis();
            boolean entitiesToMigrate = false;
            boolean rulesmigrationDone = false;
            boolean badgesMigrationDone = false;
            boolean pointsMigrationDone = false;
            RequestLifeCycle.begin((ExoContainer)this.portalContainer);
            try {
                LOG.info((Object)"=== Start migration of Rules");
                domains = this.ruleService.getDomainListFromRules();
                for (String string : domains) {
                    List<RuleDTO> rules;
                    DomainDTO domainDTO22 = this.domainService.findDomainByTitle(string);
                    if (domainDTO22 == null || (rules = this.ruleService.getAllRulesByDomain(string)) == null || rules.size() <= 0) continue;
                    for (RuleDTO rule2 : rules) {
                        if (rule2.getDomainDTO() != null) continue;
                        entitiesToMigrate = true;
                        rule2.setDomainDTO(domainDTO22);
                        this.ruleService.updateRule(rule2);
                    }
                }
                rulesmigrationDone = true;
                List<RuleDTO> rules = this.ruleService.getAllRulesWithNullDomain();
                if (rules != null && rules.size() > 0) {
                    entitiesToMigrate = true;
                    for (RuleDTO rule3 : rules) {
                        domainDTO2 = this.domainService.findDomainByTitle(rule3.getArea());
                        if (domainDTO2 != null) {
                            entitiesToMigrate = true;
                            rule3.setDomainDTO(domainDTO2);
                            this.ruleService.updateRule(rule3);
                            continue;
                        }
                        rulesmigrationDone = false;
                    }
                }
                l = System.currentTimeMillis();
                if (entitiesToMigrate) {
                    LOG.info((Object)("=== Migration of Rules is done in " + (l - startTime) + " ms"));
                } else {
                    LOG.info((Object)"=== No rules to migrate");
                }
            }
            catch (Exception e) {
                LOG.error((Object)"Error when migration Rules ", (Throwable)e);
            }
            finally {
                RequestLifeCycle.end();
            }
            RequestLifeCycle.begin((ExoContainer)this.portalContainer);
            try {
                LOG.info((Object)"=== Start migration of Badges");
                startTime = System.currentTimeMillis();
                entitiesToMigrate = false;
                domains = this.badgeService.getDomainListFromBadges();
                for (String string : domains) {
                    List<BadgeDTO> badges;
                    domainDTO = this.domainService.findDomainByTitle(string);
                    if (domainDTO == null || (badges = this.badgeService.findBadgesByDomain(string)) == null || badges.size() <= 0) continue;
                    for (BadgeDTO badge : badges) {
                        if (badge.getDomainDTO() != null) continue;
                        entitiesToMigrate = true;
                        badge.setDomainDTO(domainDTO);
                        this.badgeService.updateBadge(badge);
                    }
                }
                badgesMigrationDone = true;
                List<BadgeDTO> badges = this.badgeService.getAllBadgesWithNullDomain();
                if (badges != null && badges.size() > 0) {
                    entitiesToMigrate = true;
                    for (BadgeDTO badge : badges) {
                        domainDTO2 = this.domainService.findDomainByTitle(badge.getDomain());
                        if (domainDTO2 != null) {
                            entitiesToMigrate = true;
                            badge.setDomainDTO(domainDTO2);
                            this.badgeService.updateBadge(badge);
                            continue;
                        }
                        badgesMigrationDone = false;
                    }
                }
                l = System.currentTimeMillis();
                if (entitiesToMigrate) {
                    LOG.info((Object)("=== Migration of Badges is done in " + (l - startTime) + " ms"));
                } else {
                    LOG.info((Object)"=== No badges to migrate");
                }
            }
            catch (Exception e) {
                LOG.error((Object)"Error when migration badges ", (Throwable)e);
            }
            finally {
                RequestLifeCycle.end();
            }
            RequestLifeCycle.begin((ExoContainer)this.portalContainer);
            try {
                LOG.info((Object)"=== Start migration of History");
                startTime = System.currentTimeMillis();
                entitiesToMigrate = false;
                domains = this.gamificationHistoryDAO.getDomainList();
                for (String string : domains) {
                    List<GamificationActionsHistory> points;
                    domainDTO = this.domainService.findDomainByTitle(string);
                    if (domainDTO == null || (points = this.gamificationHistoryDAO.getAllPointsByDomain(string)) == null || points.size() <= 0) continue;
                    for (GamificationActionsHistory point : points) {
                        if (point.getDomainEntity() != null) continue;
                        entitiesToMigrate = true;
                        point.setDomainEntity(this.domainMapper.domainDTOToDomain(domainDTO));
                        this.gamificationHistoryDAO.update(point);
                    }
                }
                pointsMigrationDone = true;
                List<GamificationActionsHistory> points = this.gamificationHistoryDAO.getAllPointsWithNullDomain();
                if (points != null && points.size() > 0) {
                    for (GamificationActionsHistory point : points) {
                        domainDTO2 = this.domainService.findDomainByTitle(point.getDomain());
                        if (domainDTO2 != null) {
                            entitiesToMigrate = true;
                            point.setDomainEntity(this.domainMapper.domainDTOToDomain(domainDTO2));
                            this.gamificationHistoryDAO.update(point);
                            continue;
                        }
                        pointsMigrationDone = false;
                    }
                }
                l = System.currentTimeMillis();
                if (entitiesToMigrate) {
                    LOG.info((Object)("=== Migration of Points is done in " + (l - startTime) + " ms"));
                } else {
                    LOG.info((Object)"=== No Points to migrate");
                }
            }
            catch (Exception e) {
                LOG.error((Object)"Error when migration Points ", (Throwable)e);
            }
            finally {
                RequestLifeCycle.end();
            }
            if (badgesMigrationDone && rulesmigrationDone && pointsMigrationDone) {
                this.setDataversion(1);
                long endTime2 = System.currentTimeMillis();
                LOG.info((Object)("=== Domains Migration done in " + (endTime2 - glStartTime) + " ms"));
            }
        }
        if (this.getDataversion() < 2) {
            startTime = System.currentTimeMillis();
            try {
                LOG.info((Object)"=== Start migration of Rules");
                boolean rulesmigrationDone = false;
                List<RuleDTO> rules = this.ruleService.getAllRules();
                if (rules != null && rules.size() > 0) {
                    List noEvents = rules.stream().filter(rule -> rule.getEvent() == null).collect(Collectors.toList());
                    if (noEvents.size() == 0) {
                        rulesmigrationDone = true;
                    } else {
                        for (RuleDTO rule4 : noEvents) {
                            rule4.setEvent(rule4.getTitle());
                            this.ruleService.updateRule(rule4);
                        }
                        rules = this.ruleService.getAllRules();
                        noEvents = rules.stream().filter(rule -> rule.getEvent() == null).collect(Collectors.toList());
                        if (noEvents.size() == 0) {
                            rulesmigrationDone = true;
                        }
                    }
                }
                long endTime = System.currentTimeMillis();
                if (rulesmigrationDone) {
                    this.setDataversion(2);
                    LOG.info((Object)("=== Migration of Rules is done in " + (endTime - startTime) + " ms"));
                } else {
                    LOG.info((Object)"=== No rules to migrate");
                }
            }
            catch (Exception e) {
                LOG.error((Object)"Error when migration Rules ", (Throwable)e);
            }
        }
    }

    public void stop() {
    }

    private int getDataversion() {
        SettingValue settingValue = this.settingService.get(Context.GLOBAL, Scope.GLOBAL, GAMIFICATION_DATA_VERSION);
        if (settingValue != null) {
            return Integer.parseInt(settingValue.getValue().toString());
        }
        return 0;
    }

    private void setDataversion(int version) {
        this.settingService.set(Context.GLOBAL, Scope.GLOBAL, GAMIFICATION_DATA_VERSION, new SettingValue((Object)String.valueOf(version)));
    }
}

