/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.document.impl;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.poi.hsmf.MAPIMessage;
import org.apache.poi.hsmf.exceptions.ChunkNotFoundException;
import org.exoplatform.services.document.DocumentReadException;
import org.exoplatform.services.document.impl.BaseDocumentReader;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class MSOutlookDocumentReader
extends BaseDocumentReader {
    private static final Log LOG = ExoLogger.getLogger((String)"exo.core.component.document.MSOutlookDocumentReader");

    @Override
    public String[] getMimeTypes() {
        return new String[]{"application/vnd.ms-outlook"};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getContentAsText(InputStream is) throws IOException, DocumentReadException {
        if (is == null) {
            throw new IllegalArgumentException("InputStream is null.");
        }
        try {
            StringBuilder builder;
            block26: {
                MAPIMessage message;
                block25: {
                    block24: {
                        block23: {
                            if (is.available() == 0) {
                                String string = "";
                                return string;
                            }
                            try {
                                message = new MAPIMessage(is);
                            }
                            catch (IOException e) {
                                throw new DocumentReadException("Can't open message.", e);
                            }
                            builder = new StringBuilder();
                            try {
                                builder.append(message.getDisplayFrom()).append('\n');
                            }
                            catch (ChunkNotFoundException e) {
                                if (!LOG.isTraceEnabled()) break block23;
                                LOG.trace((Object)("An exception occurred: " + e.getMessage()));
                            }
                        }
                        try {
                            builder.append(message.getDisplayTo()).append('\n');
                        }
                        catch (ChunkNotFoundException e) {
                            if (!LOG.isTraceEnabled()) break block24;
                            LOG.trace((Object)("An exception occurred: " + e.getMessage()));
                        }
                    }
                    try {
                        builder.append(message.getSubject()).append('\n');
                    }
                    catch (ChunkNotFoundException e) {
                        if (!LOG.isTraceEnabled()) break block25;
                        LOG.trace((Object)("An exception occurred: " + e.getMessage()));
                    }
                }
                try {
                    builder.append(message.getTextBody());
                }
                catch (ChunkNotFoundException e) {
                    if (!LOG.isTraceEnabled()) break block26;
                    LOG.trace((Object)("An exception occurred: " + e.getMessage()));
                }
            }
            String string = builder.toString();
            return string;
        }
        finally {
            block27: {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException e) {
                        if (!LOG.isTraceEnabled()) break block27;
                        LOG.trace((Object)("An exception occurred: " + e.getMessage()));
                    }
                }
            }
        }
    }

    @Override
    public String getContentAsText(InputStream is, String encoding) throws IOException, DocumentReadException {
        return this.getContentAsText(is);
    }

    @Override
    public Properties getProperties(InputStream is) throws IOException, DocumentReadException {
        block2: {
            try {
                is.close();
            }
            catch (IOException e) {
                if (!LOG.isTraceEnabled()) break block2;
                LOG.trace((Object)("An exception occurred: " + e.getMessage()));
            }
        }
        return new Properties();
    }

    static {
        MAPIMessage.class.getName();
    }
}

