/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j.core.compiler.selectors;

import com.github.sommeri.less4j.core.ast.ElementSubsequent;
import com.github.sommeri.less4j.core.ast.SelectorCombinator;
import com.github.sommeri.less4j.core.ast.SimpleSelector;
import com.github.sommeri.less4j.core.compiler.selectors.ElementSubsequentComparator;
import com.github.sommeri.less4j.core.compiler.selectors.SelectorsComparatorUtils;
import com.github.sommeri.less4j.core.compiler.stages.AstLogic;
import com.github.sommeri.less4j.core.parser.HiddenTokenAwareTree;
import com.github.sommeri.less4j.utils.ListsComparator;
import java.util.ArrayList;
import java.util.List;

public class SimpleSelectorComparator
implements ListsComparator.ListMemberComparator<SimpleSelector> {
    private final SelectorsComparatorUtils utils;
    private final ElementSubsequentComparator elementSubsequentComparator;
    private final ListsComparator listsComparator = new ListsComparator();

    public SimpleSelectorComparator(ElementSubsequentComparator elementSubsequentComparator, SelectorsComparatorUtils utils) {
        this.utils = utils;
        this.elementSubsequentComparator = elementSubsequentComparator;
    }

    @Override
    public boolean equals(SimpleSelector first, SimpleSelector second) {
        if (!this.prefix(first, second)) {
            return false;
        }
        List<ElementSubsequent> firstSubsequent = first.getSubsequent();
        List<ElementSubsequent> secondSubsequent = second.getSubsequent();
        return firstSubsequent.size() == secondSubsequent.size();
    }

    @Override
    public boolean prefix(SimpleSelector lookFor, SimpleSelector inside) {
        if (!this.combinatorsEqual(lookFor.getLeadingCombinator(), inside.getLeadingCombinator())) {
            return false;
        }
        if (!lookFor.hasSubsequent() && !lookFor.hasElement()) {
            return true;
        }
        if (!this.simpleSelectorsElementsEqual(lookFor, inside)) {
            return false;
        }
        List<ElementSubsequent> lookForSubsequent = lookFor.getSubsequent();
        List<ElementSubsequent> inSelectorSubsequent = inside.getSubsequent();
        return this.listsComparator.prefix(lookForSubsequent, inSelectorSubsequent, this.elementSubsequentComparator);
    }

    @Override
    public boolean suffix(SimpleSelector lookFor, SimpleSelector inside) {
        boolean hasElement;
        boolean hasCombinator = AstLogic.hasNonSpaceCombinator(lookFor);
        boolean bl = hasElement = !this.hasNoElement(lookFor);
        if (hasCombinator) {
            return this.equals(lookFor, inside);
        }
        if (hasElement && (!this.simpleSelectorsElementsEqual(lookFor, inside) || lookFor.getSubsequent().size() != inside.getSubsequent().size())) {
            return false;
        }
        if (!lookFor.hasSubsequent()) {
            return true;
        }
        return this.listsComparator.suffix(lookFor.getSubsequent(), inside.getSubsequent(), this.elementSubsequentComparator);
    }

    public SimpleSelector cutSuffix(SimpleSelector cutOff, SimpleSelector inside) {
        ListsComparator.MatchMarker<ElementSubsequent> match;
        SelectorCombinator combinator;
        boolean hasElement;
        boolean hasCombinator = AstLogic.hasNonSpaceCombinator(cutOff);
        boolean bl = hasElement = !this.hasNoElement(cutOff);
        if (hasCombinator) {
            return null;
        }
        SelectorCombinator selectorCombinator = combinator = inside.hasLeadingCombinator() ? inside.getLeadingCombinator().clone() : null;
        if (hasElement) {
            SimpleSelector result = this.createNoElementSelector(inside.getUnderlyingStructure(), combinator);
            return result;
        }
        List<ElementSubsequent> lfSubsequent = cutOff.getSubsequent();
        List<ElementSubsequent> insideSubsequent = inside.getSubsequent();
        SimpleSelector result = this.removeMatch(inside, insideSubsequent, match = this.listsComparator.suffixMatches(lfSubsequent, insideSubsequent, this.elementSubsequentComparator));
        return this.isEmpty(result) ? null : result;
    }

    private SimpleSelector removeMatch(SimpleSelector owner, List<ElementSubsequent> subsequentsList, ListsComparator.MatchMarker<ElementSubsequent> match) {
        if (match == null) {
            return owner;
        }
        int indexOfFirst = subsequentsList.indexOf(match.getFirst());
        int indexOfLast = subsequentsList.indexOf(match.getLast());
        List<ElementSubsequent> subList = subsequentsList.subList(indexOfFirst, indexOfLast + 1);
        for (ElementSubsequent elementSubsequent : subList) {
            elementSubsequent.setParent(null);
        }
        subList.removeAll(subList);
        return owner;
    }

    private boolean isEmpty(SimpleSelector owner) {
        return !AstLogic.hasNonSpaceCombinator(owner) && this.hasNoElement(owner) && !owner.hasSubsequent();
    }

    public SimpleSelector cutPrefix(SimpleSelector cutOff, SimpleSelector inside) {
        inside.setStar(true);
        inside.setEmptyForm(true);
        if (inside.hasElement()) {
            inside.getElementName().setParent(null);
        }
        inside.setElementName(null);
        List<ElementSubsequent> lfSubsequent = cutOff.getSubsequent();
        List<ElementSubsequent> insideSubsequent = inside.getSubsequent();
        ListsComparator.MatchMarker<ElementSubsequent> match = this.listsComparator.prefixMatches(lfSubsequent, insideSubsequent, this.elementSubsequentComparator);
        SimpleSelector result = this.removeMatch(inside, insideSubsequent, match);
        return this.isEmpty(result) ? null : result;
    }

    private boolean hasNoElement(SimpleSelector selector) {
        return selector.isStar() && selector.isEmptyForm();
    }

    private boolean simpleSelectorsElementsEqual(SimpleSelector first, SimpleSelector second) {
        if (first.isStar() != second.isStar()) {
            return false;
        }
        if (first.isEmptyForm() != second.isEmptyForm()) {
            return false;
        }
        return this.utils.interpolableNamesEqual(first.getElementName(), second.getElementName());
    }

    private boolean combinatorsEqual(SelectorCombinator cmb1, SelectorCombinator cmb2) {
        if (cmb1 == null) {
            return cmb2 == null || cmb2.getCombinator() == SelectorCombinator.Combinator.DESCENDANT;
        }
        if (cmb2 == null) {
            return cmb1 == null || cmb1.getCombinator() == SelectorCombinator.Combinator.DESCENDANT;
        }
        return cmb1.getCombinator() == cmb2.getCombinator();
    }

    @Override
    public boolean contains(SimpleSelector lookFor, SimpleSelector inside) {
        if (this.hasNoElement(lookFor)) {
            return this.listsComparator.contains(lookFor.getSubsequent(), inside.getSubsequent(), this.elementSubsequentComparator);
        }
        return this.prefix(lookFor, inside);
    }

    public SimpleSelector[] splitOn(SimpleSelector lookFor, SimpleSelector inside) {
        if (this.hasNoElement(lookFor)) {
            List<ElementSubsequent> subsequents = inside.getSubsequent();
            HiddenTokenAwareTree underlying = inside.getUnderlyingStructure();
            List<ListsComparator.MatchMarker<ElementSubsequent>> matches = this.listsComparator.findMatches(lookFor.getSubsequent(), subsequents, this.elementSubsequentComparator);
            ArrayList<SimpleSelector> result = new ArrayList<SimpleSelector>();
            result.add(inside);
            for (ListsComparator.MatchMarker<ElementSubsequent> current : matches) {
                if (!current.isIn(subsequents)) continue;
                List<ElementSubsequent> tail = this.splitAfter(current.getLast(), subsequents);
                this.removeMatch(inside, subsequents, current);
                SimpleSelector second = this.createNoElementSelector(underlying, tail);
                result.add(second);
                subsequents = second.getSubsequent();
            }
            return result.toArray(new SimpleSelector[0]);
        }
        return new SimpleSelector[]{null, this.cutPrefix(lookFor, inside)};
    }

    private SimpleSelector createNoElementSelector(HiddenTokenAwareTree underlying, SelectorCombinator combinator) {
        SimpleSelector second = this.createEmptySelector(underlying);
        second.setLeadingCombinator(combinator);
        second.configureParentToAllChilds();
        return second;
    }

    private SimpleSelector createNoElementSelector(HiddenTokenAwareTree underlying, List<ElementSubsequent> tail) {
        SimpleSelector second = this.createEmptySelector(underlying);
        second.addSubsequent(tail);
        second.configureParentToAllChilds();
        return second;
    }

    private SimpleSelector createEmptySelector(HiddenTokenAwareTree underlying) {
        SimpleSelector second = new SimpleSelector(underlying, null, null, true);
        second.setEmptyForm(true);
        return second;
    }

    private List<ElementSubsequent> splitAfter(ElementSubsequent element, List<ElementSubsequent> list) {
        int indx = list.indexOf(element) + 1;
        if (indx == -1) {
            indx = list.size();
        }
        List<ElementSubsequent> subList = list.subList(indx, list.size());
        ArrayList<ElementSubsequent> result = new ArrayList<ElementSubsequent>(subList);
        subList.clear();
        return result;
    }
}

