/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j.utils;

import com.github.sommeri.less4j.core.ast.ASTCssNode;
import com.github.sommeri.less4j.core.ast.MixinReference;
import com.github.sommeri.less4j.core.ast.ReusableStructureName;
import com.github.sommeri.less4j.core.ast.Variable;
import java.util.Iterator;
import java.util.List;

public class LessPrinter {
    public String toString(MixinReference reference) {
        StringBuilder result = new StringBuilder();
        Iterator<ReusableStructureName> iterator = reference.getNameChain().iterator();
        if (iterator.hasNext()) {
            result.append(iterator.next().asString());
        }
        while (iterator.hasNext()) {
            result.append(" > ");
            result.append(iterator.next().asString());
        }
        result.append(" > ");
        result.append(reference.getFinalNameAsString());
        result.append("(...)");
        return result.toString();
    }

    public String toVariablesString(List<Variable> cycle) {
        String result = "";
        Iterator<Variable> iCycle = cycle.iterator();
        while (iCycle.hasNext()) {
            Variable variable = iCycle.next();
            result = result + variable.getName() + " (" + variable.getSourceLine() + ":" + variable.getSourceColumn() + ") ";
            if (!iCycle.hasNext()) continue;
            result = result + "-> ";
        }
        return result;
    }

    public String toMixinReferencesString(List<MixinReference> cycle) {
        String result = "";
        Iterator<MixinReference> iReference = cycle.iterator();
        while (iReference.hasNext()) {
            MixinReference reference = iReference.next();
            result = result + reference.getFinalName() + " (" + reference.getSourceLine() + ":" + reference.getSourceColumn() + ") ";
            if (!iReference.hasNext()) continue;
            result = result + "-> ";
        }
        return result;
    }

    public String toNodesPositions(List<? extends ASTCssNode> nodes) {
        String result = "";
        Iterator<? extends ASTCssNode> node = nodes.iterator();
        while (node.hasNext()) {
            ASTCssNode reference = node.next();
            result = result + "(" + reference.getSourceLine() + ":" + reference.getSourceColumn() + ")";
            if (!node.hasNext()) continue;
            result = result + " -> ";
        }
        return result;
    }
}

