/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.webui;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.commons.utils.MimeTypeResolver;
import org.exoplatform.social.core.image.ImageUtils;
import org.exoplatform.social.core.model.AvatarAttachment;
import org.exoplatform.social.webui.UIAvatarUploadContent;
import org.exoplatform.upload.UploadResource;
import org.exoplatform.upload.UploadService;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.ComponentConfigs;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIPopupWindow;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.input.UIUploadInput;

@ComponentConfigs(value={@ComponentConfig(lifecycle=UIFormLifecycle.class, template="war:/groovy/social/webui/UIAvatarUploader.gtmpl", events={@EventConfig(listeners={ConfirmActionListener.class}), @EventConfig(listeners={CancelActionListener.class})})})
public class UIAvatarUploader
extends UIForm {
    public static final int WIDTH = 200;
    public static final int HEIGHT = 200;
    private static final String MSG_MIMETYPE_NOT_ACCEPTED = "UIAvatarUploader.msg.mimetype_not_accepted";
    private static final String MSG_IMAGE_NOT_LOADED = "UIAvatarUploader.msg.img_not_loaded";
    private static final String FIELD_UPLOADER = "Uploader";
    private static final int uploadLimit = 2;
    private static final String[] ACCEPTED_MIME_TYPES = new String[]{"image/gif", "image/jpeg", "image/jpg", "image/png", "image/x-png", "image/pjpeg"};
    private final Map<String, String> IE_MIME_TYPES = new HashMap<String, String>(){
        private static final long serialVersionUID = 1L;
        {
            this.put("image/pjpeg", "image/jpeg");
            this.put("image/x-png", "image/png");
        }
    };

    public UIAvatarUploader() throws Exception {
        UIUploadInput uiAvatarUploadInput = new UIUploadInput(FIELD_UPLOADER, FIELD_UPLOADER, 1, 2);
        this.addUIFormInput((UIFormInput)uiAvatarUploadInput);
        this.setActions(new String[]{"Confirm", "Cancel"});
    }

    private boolean isAcceptedMimeType(String mimeType) {
        for (String acceptedMimeType : ACCEPTED_MIME_TYPES) {
            if (!mimeType.equals(acceptedMimeType)) continue;
            return true;
        }
        return false;
    }

    private String getStandardMimeType(String mimeType) {
        return this.IE_MIME_TYPES.get(mimeType);
    }

    public static class CancelActionListener
    extends EventListener<UIAvatarUploader> {
        public void execute(Event<UIAvatarUploader> event) throws Exception {
            UIAvatarUploader uiAvatarUploader = (UIAvatarUploader)((Object)event.getSource());
            UIPopupWindow uiPopup = (UIPopupWindow)uiAvatarUploader.getParent();
            uiPopup.setShow(false);
            uiPopup.setRendered(false);
            uiPopup.setUIComponent(null);
            event.getRequestContext().addUIComponentToUpdateByAjax(uiPopup.getParent());
        }
    }

    public static class ConfirmActionListener
    extends EventListener<UIAvatarUploader> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void execute(Event<UIAvatarUploader> event) throws Exception {
            WebuiRequestContext ctx = event.getRequestContext();
            UIAvatarUploader uiAvatarUploader = (UIAvatarUploader)((Object)event.getSource());
            UIUploadInput uiAvatarUploadInput = (UIUploadInput)uiAvatarUploader.getChild(UIUploadInput.class);
            if (uiAvatarUploadInput.getUploadResources().length < 1) {
                ctx.getUIApplication().addMessage(new ApplicationMessage(UIAvatarUploader.MSG_IMAGE_NOT_LOADED, null, 0));
                ctx.addUIComponentToUpdateByAjax((UIComponent)uiAvatarUploader);
            }
            for (UploadResource uploadResource : uiAvatarUploadInput.getUploadResources()) {
                if (uploadResource == null) continue;
                try {
                    String fileName = uploadResource.getFileName();
                    if (fileName == null || fileName.length() == 0) continue;
                    String mimeType = uploadResource.getMimeType();
                    if (!uiAvatarUploader.isAcceptedMimeType(mimeType)) {
                        ctx.getUIApplication().addMessage(new ApplicationMessage(UIAvatarUploader.MSG_MIMETYPE_NOT_ACCEPTED, null, 0));
                        ctx.addUIComponentToUpdateByAjax((UIComponent)uiAvatarUploader);
                    } else {
                        AvatarAttachment avatarAttachment;
                        FileInputStream uploadedStream = new FileInputStream(new File(uploadResource.getStoreLocation()));
                        MimeTypeResolver mimeTypeResolver = new MimeTypeResolver();
                        String extension = mimeTypeResolver.getExtension(mimeType);
                        if ("".equals(extension)) {
                            mimeType = uiAvatarUploader.getStandardMimeType(mimeType);
                        }
                        if ((avatarAttachment = ImageUtils.createResizedAvatarAttachment((InputStream)uploadedStream, (int)200, (int)200, null, (String)fileName, (String)mimeType, null)) == null) {
                            avatarAttachment = new AvatarAttachment(null, fileName, mimeType, (InputStream)uploadedStream, System.currentTimeMillis());
                        }
                        UIAvatarUploadContent uiAvatarUploadContent = (UIAvatarUploadContent)uiAvatarUploader.createUIComponent(UIAvatarUploadContent.class, null, null);
                        uiAvatarUploadContent.setAvatarAttachment(avatarAttachment);
                        UIPopupWindow uiPopup = (UIPopupWindow)uiAvatarUploader.getParent();
                        uiPopup.setUIComponent((UIComponent)uiAvatarUploadContent);
                        ctx.addUIComponentToUpdateByAjax((UIComponent)uiPopup);
                    }
                    return;
                }
                finally {
                    UploadService uploadService = (UploadService)CommonsUtils.getService(UploadService.class);
                    uploadService.removeUploadResource(uploadResource.getUploadId());
                }
            }
        }
    }
}

