/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.perkstore.plugin;

import java.util.List;
import org.exoplatform.commons.api.settings.FeaturePlugin;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.perkstore.model.GlobalSettings;
import org.exoplatform.perkstore.service.PerkStoreService;
import org.exoplatform.perkstore.service.utils.Utils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.ConversationRegistry;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.StateKey;

public class PerkStoreFeaturePlugin
extends FeaturePlugin {
    private static final Log LOG = ExoLogger.getLogger(PerkStoreService.class);
    private static final String PERK_STORE_FEATURE_NAME = "perkstore";
    private static final String PERKSTORE_ENABLED_FLAG = "perkstore.enabled";
    private ConversationRegistry conversationRegistry;
    private PerkStoreService perkStoreService;

    public String getName() {
        return PERK_STORE_FEATURE_NAME;
    }

    public boolean isFeatureActiveForUser(String featureName, String username) {
        List stateKeys = this.getConversationRegistry().getStateKeys(username);
        for (StateKey stateKey : stateKeys) {
            ConversationState state = this.getConversationRegistry().getState(stateKey);
            Boolean perkStoreEnabled = (Boolean)state.getAttribute(PERKSTORE_ENABLED_FLAG);
            if (perkStoreEnabled == null) continue;
            return perkStoreEnabled;
        }
        boolean perkStoreEnabled = false;
        try {
            GlobalSettings settings = this.getPerkStoreService().getGlobalSettings();
            if (settings == null) {
                return false;
            }
            perkStoreEnabled = Utils.hasPermission(username, settings.getAccessPermissions());
            for (StateKey stateKey : stateKeys) {
                ConversationState state = this.getConversationRegistry().getState(stateKey);
                state.setAttribute(PERKSTORE_ENABLED_FLAG, (Object)perkStoreEnabled);
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Error while checking user ACL on Perk Store Feature", (Throwable)e);
        }
        return perkStoreEnabled;
    }

    private ConversationRegistry getConversationRegistry() {
        if (this.conversationRegistry == null) {
            this.conversationRegistry = (ConversationRegistry)CommonsUtils.getService(ConversationRegistry.class);
        }
        return this.conversationRegistry;
    }

    private PerkStoreService getPerkStoreService() {
        if (this.perkStoreService == null) {
            this.perkStoreService = (PerkStoreService)CommonsUtils.getService(PerkStoreService.class);
        }
        return this.perkStoreService;
    }
}

